/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.layoutManagers;

import com.ibm.eNetwork.onDemand.common.TraceLevels;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Panel;
import java.util.Enumeration;
import java.util.Vector;

public class VerticalButtonLayout
implements LayoutManager,
LayoutManager2,
TraceLevels {
    boolean bSizesEstablished = false;
    int nVGap;
    int nWidth;
    int nHeight;
    Vector vButtons;
    protected static final boolean DEBUG = true;

    public VerticalButtonLayout() {
        this(0);
    }

    public VerticalButtonLayout(int n) {
        this.nVGap = n;
        this.vButtons = new Vector(10);
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        Panel panel = new Panel();
        panel.setLayout(new VerticalButtonLayout(5));
        panel.add(new Button("hey!"));
        panel.add(new Button("chicken"));
        panel.add(new Button("and jelly!!!"));
        panel.add(new Button("is good"));
        panel.add(new Button("on"));
        panel.add(new Button("biscuits"));
        ((Component)frame).setBackground(Color.lightGray);
        frame.add(panel);
        ((Component)frame).setSize(300, 200);
        frame.show();
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        if (!this.bSizesEstablished) {
            this.establishSizes();
        }
        Insets insets = container.getInsets();
        return new Dimension(this.nWidth + insets.left + insets.right, this.nHeight + insets.top + insets.bottom);
    }

    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = new Dimension(this.nWidth + insets.left + insets.right, this.nHeight + insets.top + insets.bottom);
        return dimension;
    }

    protected void establishSizes() {
        Enumeration enumeration = this.vButtons.elements();
        while (enumeration.hasMoreElements()) {
            Button button = (Button)enumeration.nextElement();
            Dimension dimension = button.getPreferredSize();
            this.nWidth = Math.max(this.nWidth, dimension.width);
            this.nHeight += dimension.height + this.nVGap;
        }
        this.bSizesEstablished = true;
    }

    public void layoutContainer(Container container) {
        container.getSize();
        Insets insets = container.getInsets();
        int n = insets.top;
        if (!this.bSizesEstablished) {
            this.establishSizes();
        }
        Enumeration enumeration = this.vButtons.elements();
        while (enumeration.hasMoreElements()) {
            Button button = (Button)enumeration.nextElement();
            if (!button.isVisible()) continue;
            Dimension dimension = button.getPreferredSize();
            button.setSize(this.nWidth, dimension.height);
            button.setLocation(insets.left, n);
            n += dimension.height + this.nVGap;
        }
    }

    public void addLayoutComponent(Component component, Object object) {
        if (component instanceof Button) {
            this.vButtons.addElement(component);
            this.bSizesEstablished = false;
            return;
        }
        System.out.println("ASSERT EntryFieldLayout.addLayoutComponent:  could not add " + component);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
    }
}

