/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.memoryTextField;

import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;

public class MemoryTextField
extends TextField
implements KeyListener {
    protected Vector cmdHist;
    protected int chp = -1;

    public MemoryTextField(String string, int n, int n2) {
        super(string, n);
        this.addKeyListener(this);
        this.cmdHist = new Vector(n2);
        this.cmdHist.addElement("");
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 10: {
                String string = this.getText();
                if (string.equals("")) break;
                this.processCmd(string);
                return;
            }
            case 38: {
                if (this.chp == -1) {
                    this.chp = this.cmdHist.size();
                }
                --this.chp;
                if (this.chp < 0) {
                    this.chp = this.cmdHist.size() - 1;
                }
                super.setText((String)this.cmdHist.elementAt(this.chp));
                return;
            }
            case 40: {
                ++this.chp;
                if (this.chp >= this.cmdHist.size()) {
                    this.chp = 0;
                }
                super.setText((String)this.cmdHist.elementAt(this.chp));
                return;
            }
        }
    }

    public void processCmd(String string) {
        int n = this.cmdHist.indexOf(string);
        if (n != -1) {
            this.cmdHist.removeElementAt(n);
        }
        this.cmdHist.addElement(string);
        this.chp = -1;
    }

    public void setText(String string) {
        this.processCmd(string);
        super.setText(string);
    }

    public void setText(String string, boolean bl) {
        if (bl) {
            this.processCmd(string);
        }
        super.setText(string);
    }

    public void removeFromHistory(String string) {
        int n = this.cmdHist.indexOf(string);
        if (n != -1) {
            this.cmdHist.removeElementAt(n);
        }
    }
}

