/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.messageBox;

import com.ibm.eNetwork.onDemand.common.audio.AudioLoader;
import com.ibm.eNetwork.onDemand.common.gui.OnDemandApplet;
import com.ibm.eNetwork.onDemand.common.gui.eNoDApplet;
import com.ibm.eNetwork.onDemand.common.gui.eNoDGUIMetrics;
import com.ibm.eNetwork.onDemand.common.gui.imageButton.ImageButton;
import com.ibm.eNetwork.onDemand.common.gui.messageBox.MBCanvas;
import com.ibm.eNetwork.onDemand.common.gui.messageBox.mbData;
import com.ibm.eNetwork.onDemand.common.gui.slidingDialog.SlidingDialog;
import com.ibm.eNetwork.onDemand.common.images.ImageLoader;
import com.ibm.eNetwork.onDemand.common.nls.MessageLoader;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Locale;
import java.util.Vector;

public class MessageBox
extends SlidingDialog
implements ActionListener,
WindowListener {
    protected MessageLoader msgLoader;
    protected static String MESSAGE_FILE = "MessageBox_msgprop";
    public static final short MB_ABORTRETRYIGNORE = 0;
    public static final short MB_OK = 1;
    public static final short MB_OKCANCEL = 2;
    public static final short MB_RETRYCANCEL = 3;
    public static final short MB_YESNO = 4;
    public static final short MB_YESNOCANCEL = 5;
    public static final short MB_ICONINFORMATION = 16;
    public static final short MB_ICONQUESTION = 32;
    public static final short MB_ICONEXCLAMATION = 48;
    public static final short MB_ICONSTOP = 64;
    public static final short MB_APPMODAL = 256;
    public static final short MB_SYSTEMMODAL = 512;
    public static final short MB_DEFBUTTON1 = 4096;
    public static final short MB_DEFBUTTON2 = 8192;
    public static final short MB_DEFBUTTON3 = 12288;
    public static final short IDABORT = 1;
    public static final short IDCANCEL = 2;
    public static final short IDIGNORE = 3;
    public static final short IDNO = 4;
    public static final short IDOK = 5;
    public static final short IDRETRY = 6;
    public static final short IDYES = 7;
    public static final short IDERROR = -1;
    private static final short BASEIMAGE = 1;
    private static final short HIGHLIGHTED = 2;
    private boolean ENHANCED = false;
    private ImageButton m_EnhButton1;
    private ImageButton m_EnhButton2;
    private ImageButton m_EnhButton3;
    private ImageButton m_StdButton1;
    private ImageButton m_StdButton2;
    private ImageButton m_StdButton3;
    private ImageButton help_button;
    private Font m_TAFont;
    private mbData m_mbVariableData;
    private int[] iResponseCode;
    private String[] sButtonTitles;
    private int iNumberOfButtons = -1;
    private int iUserResponse;
    private boolean withHelp = false;
    private String sHelpName;
    private String sHelpId;
    private Image m_offImage;
    protected int m_nDialogWidth;
    protected int m_nDialogHeight;
    protected int m_nTextWidth;
    protected int m_nTextHeight;
    protected static final int m_nTextInset = 10;
    protected static final int m_nImageInset = 10;
    protected static final int m_nButtonInset = 10;
    protected Vector m_MessageStrings;
    Container parent;
    MBCanvas mbCanvas;
    Panel buttonPanel;

    public MessageBox(Container container, String string, String string2, int n, String string3, String string4) {
        this(container, string, string2, n);
        this.withHelp = true;
        this.sHelpId = string3;
        this.sHelpName = string4;
    }

    public MessageBox(Container container, String string, String string2, int n) {
        super(container, string2, true);
        this.parent = container;
        try {
            this.msgLoader = new MessageLoader(Class.forName("com.ibm.eNetwork.onDemand.common.gui.messageBox.MessageBox"), MESSAGE_FILE, Locale.getDefault());
            this.setLayout(new BorderLayout());
            this.buttonPanel = new Panel();
            this.buttonPanel.setBackground(eNoDGUIMetrics.dialogBackgroundColor);
            this.mbCanvas = new MBCanvas(this);
            this.add("Center", this.mbCanvas);
            this.add("South", this.buttonPanel);
            this.initDialog(container, string, string2, n);
            return;
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: creating MessageLoader" + exception.toString());
            return;
        }
    }

    public MessageBox(String string, int n, String string2, Container container) {
        this(container, string, string2, n);
    }

    public MessageBox(mbData mbData2) {
        this(mbData2.m_ParentFrame, mbData2.m_szWindowText, mbData2.m_szMessageText, 1);
        this.m_mbVariableData = mbData2;
    }

    protected void initDialog(Container container, String string, String string2, int n) {
        this.m_mbVariableData = new mbData();
        this.m_mbVariableData.m_ParentFrame = container;
        this.m_mbVariableData.m_szMessageText = string;
        this.m_mbVariableData.m_szWindowText = string2;
        this.m_mbVariableData.m_iMessageBoxType = n;
        super.addWindowListener(this);
    }

    public void addNotify() {
        super.addNotify();
        this.setResizable(false);
        if (this.m_mbVariableData.m_Locale == null) {
            this.m_mbVariableData.m_Locale = Locale.getDefault();
        }
        this.loadDialogData();
        this.loadDialogImages();
        if (this.addButtons() == -1) {
            this.iUserResponse = -1;
            return;
        }
        this.m_StdButton1.requestFocus();
        this.repaint();
        this.doLayout();
    }

    protected void loadDialogData() {
        this.iResponseCode = new int[3];
        this.sButtonTitles = new String[3];
        switch (this.m_mbVariableData.m_iMessageBoxType) {
            case 0: {
                this.iNumberOfButtons = 3;
                this.sButtonTitles[0] = new String(this.msgLoader.get("BTN_ABORT"));
                this.sButtonTitles[1] = new String(this.msgLoader.get("BTN_RETRY"));
                this.sButtonTitles[2] = new String(this.msgLoader.get("BTN_IGNORE"));
                this.iResponseCode[0] = 1;
                this.iResponseCode[1] = 6;
                this.iResponseCode[2] = 3;
                return;
            }
            case 1: {
                this.iNumberOfButtons = 1;
                this.sButtonTitles[0] = new String(this.msgLoader.get("BTN_OK"));
                this.iResponseCode[0] = 5;
                return;
            }
            case 2: {
                this.iNumberOfButtons = 2;
                this.sButtonTitles[0] = new String(this.msgLoader.get("BTN_OK"));
                this.sButtonTitles[1] = new String(this.msgLoader.get("BTN_CANCEL"));
                this.iResponseCode[0] = 5;
                this.iResponseCode[1] = 2;
                return;
            }
            case 3: {
                this.iNumberOfButtons = 2;
                this.sButtonTitles[0] = new String(this.msgLoader.get("BTN_RETRY"));
                this.sButtonTitles[1] = new String(this.msgLoader.get("BTN_CANCEL"));
                this.iResponseCode[0] = 6;
                this.iResponseCode[1] = 2;
                return;
            }
            case 4: {
                this.iNumberOfButtons = 2;
                this.sButtonTitles[0] = new String(this.msgLoader.get("BTN_YES"));
                this.sButtonTitles[1] = new String(this.msgLoader.get("BTN_NO"));
                this.iResponseCode[0] = 7;
                this.iResponseCode[1] = 4;
                return;
            }
            case 5: {
                this.iNumberOfButtons = 3;
                this.sButtonTitles[0] = new String(this.msgLoader.get("BTN_YES"));
                this.sButtonTitles[1] = new String(this.msgLoader.get("BTN_NO"));
                this.sButtonTitles[2] = new String(this.msgLoader.get("BTN_CANCEL"));
                this.iResponseCode[0] = 7;
                this.iResponseCode[1] = 4;
                this.iResponseCode[2] = 2;
                return;
            }
        }
    }

    protected Image checkAndLoadImage(Image image, String string) {
        Image image2 = image;
        if (image == null) {
            if (string != null && string.length() > 0) {
                ImageLoader imageLoader = new ImageLoader(this);
                image2 = imageLoader.getImage(string);
            } else {
                image2 = null;
            }
        }
        return image2;
    }

    protected void loadDialogImages() {
        this.m_mbVariableData.m_imBackgroundBitmap = this.checkAndLoadImage(this.m_mbVariableData.m_imBackgroundBitmap, this.m_mbVariableData.m_szBackgroundBitmap);
        this.m_mbVariableData.m_imStyleImage = this.checkAndLoadImage(this.m_mbVariableData.m_imStyleImage, this.m_mbVariableData.m_szStyleImage);
        this.m_mbVariableData.m_imButton1BaseGraphic = this.checkAndLoadImage(this.m_mbVariableData.m_imButton1BaseGraphic, this.m_mbVariableData.m_szButton1BaseGraphic);
        if (this.m_mbVariableData.m_imButton1BaseGraphic != null) {
            this.m_mbVariableData.m_imButton1HLGraphic = this.checkAndLoadImage(this.m_mbVariableData.m_imButton1HLGraphic, this.m_mbVariableData.m_szButton1HLGraphic);
            if (this.m_mbVariableData.m_imButton1HLGraphic == null) {
                this.m_mbVariableData.m_imButton1HLGraphic = this.m_mbVariableData.m_imButton1BaseGraphic;
            }
        }
        this.m_mbVariableData.m_imButton2BaseGraphic = this.checkAndLoadImage(this.m_mbVariableData.m_imButton2BaseGraphic, this.m_mbVariableData.m_szButton2BaseGraphic);
        if (this.m_mbVariableData.m_imButton2BaseGraphic != null) {
            this.m_mbVariableData.m_imButton2HLGraphic = this.checkAndLoadImage(this.m_mbVariableData.m_imButton2HLGraphic, this.m_mbVariableData.m_szButton2HLGraphic);
            if (this.m_mbVariableData.m_imButton2HLGraphic == null) {
                this.m_mbVariableData.m_imButton2HLGraphic = this.m_mbVariableData.m_imButton2BaseGraphic;
            }
        }
        this.m_mbVariableData.m_imButton3BaseGraphic = this.checkAndLoadImage(this.m_mbVariableData.m_imButton3BaseGraphic, this.m_mbVariableData.m_szButton3BaseGraphic);
        if (this.m_mbVariableData.m_imButton3BaseGraphic != null) {
            this.m_mbVariableData.m_imButton3HLGraphic = this.checkAndLoadImage(this.m_mbVariableData.m_imButton3HLGraphic, this.m_mbVariableData.m_szButton3HLGraphic);
            if (this.m_mbVariableData.m_imButton3HLGraphic == null) {
                this.m_mbVariableData.m_imButton3HLGraphic = this.m_mbVariableData.m_imButton3BaseGraphic;
            }
        }
    }

    protected int addButtons() {
        int n = this.getNumberOfButtons();
        int n2 = 0;
        if (n != -1) {
            if (n >= 1) {
                if (this.m_mbVariableData.m_imButton1BaseGraphic != null) {
                    this.m_EnhButton1 = new ImageButton(this.m_mbVariableData.m_imButton1BaseGraphic, this.m_mbVariableData.m_imButton1HLGraphic, null, this.getButtonText(0), false, 1, 13, true, true);
                    this.buttonPanel.add(this.m_EnhButton1);
                    this.m_EnhButton1.addActionListener(this);
                } else {
                    String string = this.getButtonText(0);
                    this.m_StdButton1 = new ImageButton(string);
                    this.buttonPanel.add(this.m_StdButton1);
                    this.m_StdButton1.addActionListener(this);
                }
            }
            if (n >= 2) {
                if (this.m_mbVariableData.m_imButton2BaseGraphic != null) {
                    this.m_EnhButton1 = new ImageButton(this.m_mbVariableData.m_imButton2BaseGraphic, this.m_mbVariableData.m_imButton2HLGraphic, null, this.getButtonText(1), false, 1, 13, true, true);
                    this.buttonPanel.add(this.m_EnhButton2);
                    this.m_EnhButton2.addActionListener(this);
                } else {
                    this.m_StdButton2 = new ImageButton(this.getButtonText(1));
                    this.buttonPanel.add(this.m_StdButton2);
                    this.m_StdButton2.addActionListener(this);
                }
            }
            if (n >= 3) {
                if (this.m_mbVariableData.m_imButton3BaseGraphic != null) {
                    this.m_EnhButton3 = new ImageButton(this.m_mbVariableData.m_imButton3BaseGraphic, this.m_mbVariableData.m_imButton3HLGraphic, null, this.getButtonText(2), false, 1, 13, true, true);
                    this.buttonPanel.add(this.m_EnhButton3);
                    this.m_EnhButton3.addActionListener(this);
                } else {
                    this.m_StdButton3 = new ImageButton(this.getButtonText(2));
                    this.buttonPanel.add(this.m_StdButton3);
                    this.m_StdButton3.addActionListener(this);
                }
            }
        } else {
            n2 = -1;
        }
        if (this.withHelp) {
            this.help_button = new ImageButton(this.msgLoader.get("BTN_HELP"));
            this.buttonPanel.add(this.help_button);
            this.help_button.addActionListener(this);
        }
        return n2;
    }

    protected String getButtonText(int n) {
        return this.sButtonTitles[n];
    }

    protected int getResponseCode(int n) {
        return this.iResponseCode[n];
    }

    protected int getNumberOfButtons() {
        return this.iNumberOfButtons;
    }

    protected short loadWaveFile() {
        int n = 0;
        AudioClip audioClip = null;
        AudioLoader audioLoader = null;
        if (this.ENHANCED && this.m_mbVariableData.m_szWavAudioFile != null && (audioLoader = new AudioLoader(this)) != null && this.m_mbVariableData.m_szWavAudioFile != null && this.m_mbVariableData.m_szWavAudioFile.length() > 0) {
            audioClip = audioLoader.getAudio(this.m_mbVariableData.m_szWavAudioFile);
            if (audioClip != null) {
                audioClip.play();
            } else {
                n = -1;
            }
        }
        return (short)n;
    }

    public Insets getMessageInsets() {
        Insets insets = this.getInsets();
        insets.top += 10;
        insets.bottom += 0;
        insets.right += 10;
        insets.left += 10;
        if (this.m_mbVariableData.m_imStyleImage != null) {
            insets.left += this.m_mbVariableData.m_imStyleImage.getWidth(this);
            insets.left += 10;
        }
        return insets;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public int doModal() {
        if (this.iUserResponse != -1) {
            this.loadWaveFile();
            int n = this.calculateDialogWidth() + 5;
            this.splitMessageIntoLines();
            int n2 = this.calculateDialogHeight();
            this.setSize(n, n2);
            this.show();
        }
        return this.iUserResponse;
    }

    private void destroyWindow() {
        this.mbCanvas.dispose();
        if (this.m_EnhButton1 != null) {
            this.m_EnhButton1.dispose();
            this.m_EnhButton1 = null;
        }
        if (this.m_EnhButton2 != null) {
            this.m_EnhButton2.dispose();
            this.m_EnhButton2 = null;
        }
        if (this.m_EnhButton3 != null) {
            this.m_EnhButton3.dispose();
            this.m_EnhButton3 = null;
        }
        if (this.m_StdButton1 != null) {
            this.m_StdButton1.dispose();
            this.m_StdButton1 = null;
        }
        if (this.m_StdButton2 != null) {
            this.m_StdButton2.dispose();
            this.m_StdButton2 = null;
        }
        if (this.m_StdButton3 != null) {
            this.m_StdButton3.dispose();
            this.m_StdButton3 = null;
        }
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.withHelp && actionEvent.getActionCommand().equals(this.msgLoader.get("BTN_HELP"))) {
            eNoDApplet eNoDApplet2 = OnDemandApplet.getAppletFromHelpId(this.sHelpId);
            eNoDApplet2.showHelp(this.sHelpId, this.sHelpName);
            return;
        }
        int n = 0;
        while (n < this.getNumberOfButtons()) {
            if (this.getButtonText(n) == actionEvent.getActionCommand()) {
                this.iUserResponse = this.getResponseCode(n);
            }
            ++n;
        }
        this.destroyWindow();
    }

    protected int calculateDialogWidth() {
        Dimension dimension = this.parent.getSize();
        Insets insets = this.getMessageInsets();
        int n = dimension.width - 10;
        int n2 = 400;
        this.m_nDialogWidth = n > n2 ? n2 : n;
        this.m_nTextWidth = this.m_nDialogWidth - (insets.left + insets.right);
        return this.m_nDialogWidth;
    }

    protected int calculateDialogHeight() {
        int n = 50;
        if (this.m_MessageStrings != null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            FontMetrics fontMetrics = toolkit.getFontMetrics(eNoDGUIMetrics.labelFont);
            int n2 = fontMetrics.getMaxAscent();
            int n3 = this.m_MessageStrings.size();
            n += n3 * n2;
            n += 10;
        }
        if (this.m_mbVariableData.m_imStyleImage != null) {
            int n4 = this.m_mbVariableData.m_imStyleImage.getHeight(this);
            if ((n4 += 20) > n) {
                n = n4;
            }
        }
        this.m_nDialogHeight = this.getMinimumSize().height + n;
        return this.m_nDialogHeight;
    }

    protected void splitMessageIntoLines() {
        this.m_MessageStrings = new Vector(10, 10);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.m_mbVariableData.m_szMessageText.length();
        new String();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        FontMetrics fontMetrics = toolkit.getFontMetrics(eNoDGUIMetrics.labelFont);
        int n5 = 0;
        while (n5 <= n4) {
            char c;
            boolean bl = false;
            if (n5 < n4) {
                n = fontMetrics.stringWidth(this.m_mbVariableData.m_szMessageText.substring(n2, n5 + 1));
                if (n >= this.m_nTextWidth) {
                    int n6 = n5;
                    c = '\u0001';
                    while (c == '\u0001') {
                        char c2 = this.m_mbVariableData.m_szMessageText.charAt(n6);
                        if (c2 == ' ' && n6 != n5) {
                            c = '\u0000';
                            n5 = n6;
                            continue;
                        }
                        if (--n6 != n2) continue;
                        c = '\u0000';
                    }
                    bl = true;
                } else if (this.m_mbVariableData.m_szMessageText.charAt(n5) == '\n') {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl) {
                String string = new String(this.m_mbVariableData.m_szMessageText.substring(n2, n5));
                this.m_MessageStrings.addElement(string);
                ++n3;
                if (n5 < n4) {
                    c = this.m_mbVariableData.m_szMessageText.charAt(n5);
                    if (c == '\n' || c == ' ') {
                        // empty if block
                    }
                } else if (n5 == n4) {
                    ++n5;
                }
                n2 = ++n5;
                n = 0;
                continue;
            }
            ++n5;
        }
    }

    public Vector getMessageStrings() {
        return this.m_MessageStrings;
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.destroyWindow();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

