/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.selectorpanel;

import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.DrawableNode;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.LeftAlignedNode;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class SelectorPanelNode
extends LeftAlignedNode {
    private int internalIndex;
    private int indentWidth;
    private boolean isChild;
    private boolean showCompleted = true;
    private boolean completed = false;
    private boolean enabled = false;
    private boolean visible = false;
    private boolean childSelected = false;
    private boolean choppedOff;
    private SelectorPanelNode firstChild;
    private SelectorPanelNode parentNode;
    public static final int DEFAULT_INDENT_WIDTH = 20;
    private static final Color FOCUS_COLOR = Color.black;

    public SelectorPanelNode(String string, DrawableNode drawableNode, ColorsForCanvas colorsForCanvas, FontsForCanvas fontsForCanvas, ImagesForCanvas imagesForCanvas) {
        super(string, drawableNode, colorsForCanvas, fontsForCanvas, imagesForCanvas);
        this.internalInit();
    }

    public SelectorPanelNode(String string, ColorsForCanvas colorsForCanvas, FontsForCanvas fontsForCanvas, ImagesForCanvas imagesForCanvas) {
        super(string, colorsForCanvas, fontsForCanvas, imagesForCanvas);
        this.internalInit();
    }

    protected void calcSpaces() {
        this.iHorzSpace = this.ffcFont.getFontMaxWidth(1) * 2 / 3;
        this.iVertSpace = this.ffcFont.getFontDescent(1) / 2;
    }

    private void internalInit() {
        this.setIndentWidth(20);
        this.setCompleted(false);
    }

    public void setIndentWidth(int n) {
        this.indentWidth = n;
    }

    public int getIndentWidth() {
        return this.indentWidth;
    }

    public void setIsChild(boolean bl) {
        this.isChild = bl;
    }

    public boolean getIsChild() {
        return this.isChild;
    }

    public void setParentNode(SelectorPanelNode selectorPanelNode) {
        this.parentNode = selectorPanelNode;
    }

    public SelectorPanelNode getParentNode() {
        return this.parentNode;
    }

    public void setFirstChild(SelectorPanelNode selectorPanelNode) {
        this.firstChild = selectorPanelNode;
    }

    public SelectorPanelNode getFirstChild() {
        return this.firstChild;
    }

    public void setCompleted(boolean bl) {
        this.completed = bl;
    }

    public boolean getCompleted() {
        return this.completed;
    }

    public void setShowCompleted(boolean bl) {
        this.showCompleted = bl;
    }

    public boolean getShowCompleted() {
        return this.showCompleted;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public boolean getChoppedOff() {
        return this.choppedOff;
    }

    protected void setInternalIndex(int n) {
        this.internalIndex = n;
    }

    protected int getInternalIndex() {
        return this.internalIndex;
    }

    protected void setChildSelected(boolean bl) {
        this.childSelected = bl;
    }

    protected boolean getChildSelected() {
        return this.childSelected;
    }

    protected int drawAtX(int n) {
        if (this.isChild) {
            n += this.indentWidth;
        }
        if (!this.showCompleted) {
            int n2 = 1;
            n = n - this.ifcImage.getImageWidth(n2) - this.iHorzSpace;
        }
        return n;
    }

    public void draw(Graphics graphics, Rectangle rectangle) {
        rectangle.x += 5;
        rectangle.width -= 10;
        Point point = new Point(rectangle.x, rectangle.y);
        this.setLocation(point);
        this.paintBackground(graphics, rectangle);
        if (this.showCompleted) {
            this.drawGraphic(graphics, rectangle);
        }
        if (this.isChild) {
            rectangle.x += this.indentWidth;
            rectangle.width -= this.indentWidth;
        }
        if (!this.showCompleted) {
            int n = 1;
            rectangle.x = rectangle.x - this.ifcImage.getImageWidth(n) - this.iHorzSpace / 2;
        }
        if (this.enabled) {
            this.drawCaption(this.cfcColor.getColor(1), graphics, rectangle);
            return;
        }
        this.drawCaption(new Color(150, 150, 150), graphics, rectangle);
    }

    protected void drawGraphic(Graphics graphics, Rectangle rectangle) {
        int n = this.getOffsetForCenter(2);
        Rectangle rectangle2 = null;
        int n2 = 0;
        rectangle2 = new Rectangle(this.getGraphicX(rectangle), this.getGraphicY(rectangle, n), 0, 0);
        if (this.getCompleted()) {
            n2 = 1;
        }
        this.ifcImage.drawImage(n2, graphics, rectangle2);
    }

    protected String computeText(int n) {
        try {
            String string;
            int n2;
            this.choppedOff = false;
            int n3 = this.getWidth() - 10 - this.ifcImage.getImageWidth(n) - 2 * this.iHorzSpace;
            if (this.isChild) {
                n3 -= this.indentWidth;
            }
            if (!this.showCompleted) {
                n3 = n3 + this.ifcImage.getImageWidth(n) + this.iHorzSpace;
            }
            if ((n2 = this.ffcFont.getStringWidth(string = this.getText(), n)) < n3) {
                return string;
            }
            int n4 = this.ffcFont.getFontAverageWidth(n);
            if (this.ffcFont.getStringWidth("...", n) > n3) {
                return "";
            }
            String string2 = "";
            int n5 = 1;
            while (n3 - this.ffcFont.getStringWidth(string2 = String.valueOf(string.substring(0, n5++)) + "...", n) > n4) {
            }
            this.choppedOff = true;
            return string2;
        }
        catch (Exception exception) {
            return "";
        }
    }

    protected void drawFocusBox(Graphics graphics, Rectangle rectangle) {
        rectangle.x += 5;
        rectangle.width -= 10;
        graphics.setColor(FOCUS_COLOR);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + rectangle.width - 2, rectangle.y + 1);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, rectangle.y + rectangle.height - 2);
        graphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y + 1, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
    }

    protected void paintBackground(Graphics graphics, Rectangle rectangle) {
        if (!this.bPaintBackground) {
            return;
        }
        if (this.getSelected()) {
            graphics.setColor(this.cfcColor.getColor(2));
        } else {
            graphics.setColor(this.cfcColor.getColor(0));
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

