/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.spinBox;

import com.ibm.eNetwork.onDemand.common.gui.filteredTextField.SpecificLengthIntTextField;
import com.ibm.eNetwork.onDemand.common.gui.jvcScrollbar.JVCScrollbarButton;
import com.ibm.eNetwork.onDemand.common.gui.spinBox.SpinButtons;
import com.ibm.eNetwork.onDemand.common.wizard.GridbagPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextListener;

public class SpinBox
extends GridbagPanel
implements ActionListener {
    private SpecificLengthIntTextField intTF;
    private SpinButtons buttons;
    private int num_chars;
    private int int_value;
    private int min_int;
    private int max_int;

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        Panel panel = new Panel();
        panel.setBackground(SystemColor.control);
        panel.add(new SpinBox(4));
        ((Component)frame).setBackground(Color.lightGray);
        frame.add(panel);
        ((Component)frame).setSize(300, 200);
        ((Component)frame).setVisible(true);
    }

    public SpinBox(int n) {
        super(new GridBagLayout());
        this.num_chars = n;
        this.int_value = 0;
        this.SpinBoxConstructor();
    }

    public SpinBox(int n, int n2) {
        super(new GridBagLayout());
        this.num_chars = Math.max(n, n2);
        this.int_value = n2;
        this.SpinBoxConstructor();
    }

    private void SpinBoxConstructor() {
        this.min_int = 0;
        this.max_int = this.calculateMaxInt(this.num_chars);
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.intTF = new SpecificLengthIntTextField(this.num_chars);
        this.constraintBuilder(gridBagConstraints, 0, 0, 1, 1, 50, 100);
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.intTF, gridBagConstraints);
        this.add(this.intTF);
        this.buttons = new SpinButtons();
        this.buttons.addActionListener(this);
        this.constraintBuilder(gridBagConstraints, 1, 0, 1, 1, 50, 0);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.buttons, gridBagConstraints);
        this.add(this.buttons);
        this.updateSpinBoxValue();
        this.setVisible(true);
    }

    public int calculateMaxInt(int n) {
        int n2 = 0;
        int n3 = 0;
        if (n > 9) {
            n3 = Integer.MAX_VALUE;
        } else {
            n2 = 0;
            while (n2 < n) {
                n3 += 9 * (int)Math.pow(10.0, n2);
                ++n2;
            }
        }
        return n3;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (((JVCScrollbarButton)actionEvent.getSource()).getType() == 1) {
            if (this.intTF.getText().trim().length() == 0) {
                this.int_value = 0;
            } else {
                Integer n = new Integer(this.intTF.getText());
                this.int_value = n;
            }
            ++this.int_value;
            if (this.int_value > this.max_int) {
                this.int_value = this.min_int;
            }
            this.updateSpinBoxValue();
            return;
        }
        if (((JVCScrollbarButton)actionEvent.getSource()).getType() == 2) {
            if (this.intTF.getText().trim().length() == 0) {
                this.int_value = 0;
            } else {
                Integer n = new Integer(this.intTF.getText());
                this.int_value = n;
            }
            --this.int_value;
            if (this.int_value < this.min_int) {
                this.int_value = this.max_int;
            }
            this.updateSpinBoxValue();
        }
    }

    public synchronized void addTextListener(TextListener textListener) {
        this.intTF.addTextListener(textListener);
    }

    public synchronized void removeTextListener(TextListener textListener) {
        this.intTF.removeTextListener(textListener);
    }

    public void setSpinBoxValue(int n) {
        this.int_value = n;
        this.updateSpinBoxValue();
    }

    public void setSpinBoxValue(String string) {
        Integer n = new Integer(string);
        this.int_value = n;
        this.updateSpinBoxValue();
    }

    public int getSpinBoxValue() {
        Integer n = new Integer(this.intTF.getText());
        this.int_value = n;
        return this.int_value;
    }

    public String getSpinBoxText() {
        return this.intTF.getText();
    }

    private void updateSpinBoxValue() {
        String string = Integer.toString(this.int_value);
        this.intTF.setText(string);
    }

    public void setRange(int n, int n2) {
        this.min_int = n;
        this.max_int = n2;
    }

    public int getLower() {
        return this.min_int;
    }

    public int getUpper() {
        return this.max_int;
    }

    public void setEnabled(boolean bl) {
        this.intTF.setEnabled(bl);
    }

    public synchronized void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.intTF.setBounds(0, 0, n3 - this.buttons.getPreferredSize().width, n4);
    }

    public Dimension getMinimumSize() {
        return new Dimension(2 * this.buttons.getPreferredSize().width, 2 * this.buttons.getPreferredSize().height);
    }

    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }
}

