/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.splitterPanel;

import com.ibm.eNetwork.onDemand.common.TraceLevels;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Panel;
import java.awt.Point;

public class SplitterPanelLayout
implements LayoutManager,
LayoutManager2,
TraceLevels {
    static final boolean DEBUG = false;
    Component firstComponent;
    Component secondComponent;
    Panel splitter;
    int nOrientation = 0;
    Point currentPosition;
    Point currentDelta = new Point(0, 0);

    protected SplitterPanelLayout() {
        this(0);
    }

    protected SplitterPanelLayout(int n) {
        this.setOrientation(n);
    }

    protected void setOrientation(int n) {
        this.nOrientation = n;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
        if (component == this.firstComponent) {
            this.firstComponent = null;
        }
        if (component == this.secondComponent) {
            this.secondComponent = null;
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        return container.getSize();
    }

    public Dimension minimumLayoutSize(Container container) {
        return container.getSize();
    }

    public void layoutContainer(Container container) {
        Dimension dimension = container.getSize();
        if (this.secondComponent == null) {
            if (this.firstComponent == null) {
                return;
            }
            this.firstComponent.setSize(dimension);
            this.firstComponent.setLocation(0, 0);
            return;
        }
        if (this.nOrientation == 0) {
            this.layoutVertical(dimension);
            return;
        }
        this.layoutHorizontal(dimension);
    }

    protected void layoutVertical(Dimension dimension) {
        if (dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        Dimension dimension2 = this.firstComponent.getPreferredSize();
        Dimension dimension3 = this.secondComponent.getPreferredSize();
        Dimension dimension4 = this.splitter.getPreferredSize();
        if (this.currentPosition == null) {
            int n = 0;
            if (dimension2.width + dimension3.width + dimension4.width <= dimension.width) {
                n = dimension2.width;
            } else {
                n = (int)((float)dimension2.width / (float)(dimension2.width + dimension3.width) * (float)dimension.width);
                n = Math.min(n, dimension.width - dimension4.width);
            }
            this.currentPosition = new Point(n, 0);
        } else {
            this.currentPosition.x += this.currentDelta.x;
            this.currentPosition.x = Math.min(this.currentPosition.x, dimension.width - dimension4.width);
        }
        this.firstComponent.setSize(this.currentPosition.x, dimension.height);
        this.firstComponent.setBounds(0, 0, this.currentPosition.x, dimension.height);
        this.firstComponent.invalidate();
        this.firstComponent.validate();
        this.splitter.setSize(dimension4.width, dimension.height);
        this.splitter.setLocation(this.currentPosition.x, 0);
        this.secondComponent.setSize(dimension.width - this.currentPosition.x - dimension4.width, dimension.height);
        this.secondComponent.setBounds(this.currentPosition.x + dimension4.width, 0, dimension.width - this.currentPosition.x - dimension4.width, dimension.height);
        this.secondComponent.invalidate();
        this.secondComponent.validate();
        this.currentDelta.x = 0;
        this.currentDelta.y = 0;
    }

    protected void layoutHorizontal(Dimension dimension) {
        if (dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        Dimension dimension2 = this.firstComponent.getPreferredSize();
        Dimension dimension3 = this.secondComponent.getPreferredSize();
        Dimension dimension4 = this.splitter.getPreferredSize();
        if (this.currentPosition == null) {
            int n = 0;
            if (dimension2.height + dimension3.height + dimension4.height <= dimension.height) {
                n = dimension2.height;
            } else {
                n = (int)((float)dimension2.height / (float)(dimension2.height + dimension3.height) * (float)dimension.height);
                n = Math.min(n, dimension.height - dimension4.height);
            }
            this.currentPosition = new Point(0, n);
        } else {
            this.currentPosition.y += this.currentDelta.y;
            this.currentPosition.y = Math.min(this.currentPosition.y, dimension.height - dimension4.height);
        }
        this.firstComponent.setSize(dimension.width, this.currentPosition.y);
        this.firstComponent.setLocation(0, 0);
        this.firstComponent.invalidate();
        this.firstComponent.validate();
        this.splitter.setSize(dimension.width, dimension4.height);
        this.splitter.setLocation(0, this.currentPosition.y);
        this.secondComponent.setSize(dimension.width, dimension.height - this.currentPosition.y - dimension4.height);
        this.secondComponent.setLocation(0, this.currentPosition.y + dimension4.height);
        this.secondComponent.invalidate();
        this.secondComponent.validate();
        this.currentDelta.x = 0;
        this.currentDelta.y = 0;
    }

    public void addLayoutComponent(Component component, Object object) {
        if (this.splitter == null) {
            this.splitter = (Panel)component;
            return;
        }
        if (this.firstComponent == null) {
            this.firstComponent = component;
            return;
        }
        if (this.secondComponent == null) {
            this.secondComponent = component;
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
    }

    public void splitterMoved(Point point) {
        this.currentDelta = point;
    }
}

