/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.statusBar;

import com.ibm.eNetwork.onDemand.common.TraceLevels;
import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.statusObject.StatusObjectCanvas;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import netscape.security.PrivilegeManager;

public class StatusBarCanvas
extends StatusObjectCanvas
implements Runnable,
TraceLevels {
    protected Thread thread;
    protected String LEFT_BRAC = "[ ";
    protected String RIGHT_BRAC = " ]";
    protected String sLabel = "";
    protected boolean bThreadedPaint = true;
    protected boolean bPainting = false;

    public StatusBarCanvas(String string, ColorsForCanvas colorsForCanvas, FontsForCanvas fontsForCanvas, ImagesForCanvas imagesForCanvas) {
        this.copyAttribs(colorsForCanvas, fontsForCanvas, imagesForCanvas);
        this.setAttribs();
        this.setLabel(string);
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.repaint2();
                    if (!this.bThreadedPaint) break;
                    this.thread.suspend();
                }
                return;
            }
            catch (Exception exception) {
                System.err.println("StatusBar: paint exception caught");
                continue;
            }
            break;
        }
    }

    public void repaint() {
        try {
            if (this.bPainting) {
                return;
            }
            if (this.bThreadedPaint) {
                PolicyEngine.assertPermission(PermissionID.THREAD);
                PrivilegeManager.enablePrivilege("UniversalThreadAccess");
                if (this.thread == null) {
                    this.startThread();
                }
                this.thread.resume();
                PolicyEngine.revertPermission(PermissionID.THREAD);
                return;
            }
            if (this.thread != null) {
                this.stopThread();
            }
            this.run();
            return;
        }
        catch (Exception exception) {
            System.err.println("StatusBar: paint exception caught");
            return;
        }
    }

    public void draw(Graphics graphics) {
        try {
            this.bPainting = true;
            Dimension dimension = this.getSize();
            int n = (int)((float)dimension.width * this.fPercent) - 1;
            Rectangle rectangle = new Rectangle(0, 0, dimension.width - 1, dimension.height - 1);
            graphics.setColor(this.cfcColor.getColor(2));
            graphics.fillRect(rectangle.x, rectangle.y, n, rectangle.height);
            this.drawText(graphics, rectangle);
            this.drawOutline(graphics, dimension);
            this.bPainting = false;
            return;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return;
        }
    }

    public void setLabel(String string) {
        this.sLabel = string;
    }

    public void drawOutline(Graphics graphics, Dimension dimension) {
        SystemColor systemColor = SystemColor.control;
        Color color = systemColor.brighter();
        Color color2 = systemColor.darker();
        Color color3 = color2.darker();
        graphics.setColor(color);
        graphics.drawLine(0, 0, dimension.width, 0);
        graphics.drawLine(0, 0, 0, dimension.height);
        graphics.setColor(color2);
        graphics.drawLine(1, dimension.height - 1, dimension.width - 1, dimension.height - 1);
        graphics.drawLine(dimension.width - 1, dimension.height - 1, dimension.width - 1, 1);
        graphics.setColor(color3);
        graphics.drawLine(0, dimension.height, dimension.width, dimension.height);
        graphics.drawLine(dimension.width, dimension.height, dimension.width, 1);
    }

    public void drawText(Graphics graphics, Rectangle rectangle) {
        String string = String.valueOf(this.sLabel) + this.LEFT_BRAC + (int)(this.fPercent * 100.0f) + "%" + this.RIGHT_BRAC;
        int n = this.ffcFont.getStringWidth(string, 1);
        int n2 = (rectangle.height - this.ffcFont.getFontHeight(1)) / 2 + 3;
        graphics.setColor(this.cfcColor.getColor(1));
        graphics.drawString(string, (rectangle.width - n) / 2, rectangle.height - n2);
    }

    public void repaint2() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            super.repaint();
            return;
        }
        this.update(graphics);
    }

    public boolean getThreadedPaint() {
        return this.bThreadedPaint;
    }

    public void setThreadedPaint(boolean bl) {
        this.bThreadedPaint = bl;
    }

    protected void stopThread() {
        PolicyEngine.assertPermission(PermissionID.THREAD);
        PrivilegeManager.enablePrivilege("UniversalThreadAccess");
        try {
            if (this.thread != null) {
                this.thread.stop();
                this.thread = null;
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        PolicyEngine.revertPermission(PermissionID.THREAD);
    }

    protected void startThread() {
        PolicyEngine.assertPermission(PermissionID.THREAD);
        PrivilegeManager.enablePrivilege("UniversalThreadAccess");
        try {
            this.thread = new Thread(this);
            this.thread.setDaemon(true);
            this.thread.start();
            this.thread.suspend();
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        PolicyEngine.revertPermission(PermissionID.THREAD);
    }

    public boolean isFocusTraversable() {
        return false;
    }
}

