/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.statusPanel;

import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ExtendedCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;

public class StatusPanelBar
extends ExtendedCanvas {
    protected String sText = "";
    protected int iFontHeight = 1;
    protected Dimension dim;
    protected static final int X_OFFSET = 8;
    protected static final int Y_OFFSET = 5;
    protected static final String DEFAULT_TEXT = "";

    public StatusPanelBar(ColorsForCanvas colorsForCanvas, FontsForCanvas fontsForCanvas) {
        this.copyAttribs(colorsForCanvas, fontsForCanvas, this.ifcImage);
        this.setAttribs();
    }

    public void setText(String string) {
        if (string == null) {
            this.sText = DEFAULT_TEXT;
            return;
        }
        this.sText = string;
    }

    public void draw(Graphics graphics) {
        try {
            Dimension dimension = this.size();
            graphics.setColor(SystemColor.control);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(this.cfcColor.getColor(1));
            graphics.setFont(this.ffcFont.getFont(1));
            String string = this.computeText(1);
            graphics.drawString(string, 8, this.iFontHeight + 5);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void committ() {
        try {
            int n = this.ffcFont.getFontDescent(1);
            this.iFontHeight = this.ffcFont.getFontHeight(1) - n - 4;
            int n2 = this.iFontHeight + 10 + n;
            this.dim = new Dimension(1, n2);
            this.setSize(1, n2);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected String computeText(int n) {
        try {
            Dimension dimension = this.getSize();
            int n2 = dimension.width;
            String string = this.sText;
            int n3 = this.ffcFont.getStringWidth(string, n);
            if (n3 < n2) {
                return string;
            }
            int n4 = n3 - n2;
            int n5 = this.ffcFont.getFontAverageWidth(n);
            int n6 = (int)((float)n4 / (float)n5 + 3.0f);
            int n7 = string.length() - n6 - 1;
            if (n7 < 1) {
                return DEFAULT_TEXT;
            }
            return String.valueOf(string.substring(0, n7)) + "...";
        }
        catch (Exception exception) {
            return DEFAULT_TEXT;
        }
    }

    public Dimension getPreferredSize() {
        return this.dim;
    }

    public void repaint() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            super.repaint();
        }
        this.update(graphics);
    }
}

