/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.tabView;

import com.ibm.eNetwork.onDemand.common.TraceLevels;
import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ExtendedPanel;
import com.ibm.eNetwork.onDemand.common.gui.tabView.CardViewCanvas;
import com.ibm.eNetwork.onDemand.common.gui.tabView.CardViewLayout;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabViewNode;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;

public class CardView
extends ExtendedPanel
implements TraceLevels {
    protected static final int HORZ_GAP = 3;
    protected static final int VERT_GAP = 3;
    protected CardLayout layout;
    protected String sSelectedPanel;
    protected TabViewNode tvnSelected;
    protected CardViewCanvas cvc;
    protected Panel pCardLayout;

    public CardView(Dimension dimension, ColorsForCanvas colorsForCanvas) {
        this.copyAttribs(colorsForCanvas, this.ffcFont, this.ifcImage);
        this.setAttribs();
        this.cvc = new CardViewCanvas(colorsForCanvas);
        this.pCardLayout = new Panel();
        this.setLayout(new CardViewLayout());
        this.add("pcv", this.pCardLayout);
        this.add("cvc", this.cvc);
        this.layout = new CardLayout();
        this.pCardLayout.setLayout(this.layout);
    }

    public void removePanel(TabViewNode tabViewNode) {
        try {
            Panel panel = tabViewNode.getPanel();
            this.pCardLayout.remove(panel);
            return;
        }
        catch (Exception exception) {
            System.err.println("Error: " + tabViewNode.toString() + " not removed");
            return;
        }
    }

    public void addPanel(TabViewNode tabViewNode) {
        try {
            String string = tabViewNode.toString();
            Panel panel = tabViewNode.getPanel();
            this.pCardLayout.add((Component)panel, string);
            if (this.sSelectedPanel == null) {
                this.sSelectedPanel = string;
                this.tvnSelected = tabViewNode;
            }
            this.layout.layoutContainer(panel);
            return;
        }
        catch (Exception exception) {
            System.err.println("CardView: Panel not created: " + exception);
            return;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
    }

    public void selectPanel(TabViewNode tabViewNode) {
        this.sSelectedPanel = tabViewNode.toString();
        this.tvnSelected = tabViewNode;
        this.showSelectedPanel();
    }

    public TabViewNode getSelectedPanel() {
        return this.tvnSelected;
    }

    private void showSelectedPanel() {
        this.layout.show(this.pCardLayout, this.sSelectedPanel);
    }

    public Dimension getDisplaySize() {
        Dimension dimension = this.pCardLayout.getSize();
        return dimension;
    }
}

