/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.tabView;

import com.ibm.eNetwork.onDemand.common.gui.common.LeftAlignedNode;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabViewNode;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;

public abstract class Tab
extends LeftAlignedNode {
    protected boolean bIsPartial = false;
    protected boolean bFirst = false;
    protected boolean bLast = false;
    protected Color cBack;
    protected TabViewNode tvn;

    protected abstract void drawTabOutline(Graphics var1, Rectangle var2);

    public Tab(TabViewNode tabViewNode) {
        super(tabViewNode.getText(), tabViewNode.getColors(), tabViewNode.getFonts(), tabViewNode.getImage());
        this.setTabViewNode(tabViewNode);
    }

    public void draw(Graphics graphics, Rectangle rectangle) {
        super.draw(graphics, rectangle);
        this.drawTabOutline(graphics, rectangle);
        this.drawOnFocus(graphics, rectangle);
    }

    protected void drawOnFocus(Graphics graphics, Rectangle rectangle) {
        if (this.hasFocus() && this.getSelected()) {
            graphics.setColor(SystemColor.controlDkShadow);
            graphics.drawRoundRect(rectangle.x + (int)(0.5 * (double)this.iHorzSpace), rectangle.y + (int)(1.5 * (double)this.iVertSpace), rectangle.width - this.iHorzSpace, rectangle.height - 3 * this.iVertSpace, 5, 5);
        }
    }

    public TabViewNode getTabViewNode() {
        return this.tvn;
    }

    public void setTabViewNode(TabViewNode tabViewNode) {
        this.tvn = tabViewNode;
    }

    public boolean getTabPartiallyDisplayed() {
        return this.bIsPartial;
    }

    public void setParentBackground(Color color) {
        this.cBack = color;
    }

    public void setTabPartiallyDisplayed(boolean bl) {
        this.bIsPartial = bl;
    }

    public void committ() {
        super.committ();
    }

    protected void calcSpaces() {
        this.iHorzSpace = 2;
        this.iVertSpace = this.ffcFont.getFontDescent(1) / 4;
    }

    protected void setFirst(boolean bl) {
        this.bFirst = bl;
    }

    protected void setLast(boolean bl) {
        this.bLast = bl;
    }
}

