/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.tabView;

import com.ibm.eNetwork.onDemand.common.TraceLevels;
import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.Controler;
import com.ibm.eNetwork.onDemand.common.gui.common.ExtendedPanel;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.dbCanvasImageIndexMap;
import com.ibm.eNetwork.onDemand.common.gui.tabView.CardView;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabViewEventListener;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabViewLayout;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabViewNode;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabsView;
import com.ibm.eNetwork.onDemand.common.gui.tabView.ableToUseTabsView;
import com.ibm.eNetwork.onDemand.common.gui.tabView.tabOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;

public class TabView
extends ExtendedPanel
implements ableToUseTabsView,
tabOrientation,
dbCanvasImageIndexMap,
TraceLevels {
    protected TabsView tv;
    protected CardView cv;
    protected Dimension dimView;
    protected int iTabOrientation;
    public static final int PANEL_EXPOSED = 1;
    protected String sTab;
    protected Vector vTabs = new Vector(10, 10);

    public TabView(Point point, Dimension dimension, FontsForCanvas fontsForCanvas, ColorsForCanvas colorsForCanvas, ImagesForCanvas imagesForCanvas, int n) {
        this.copyAttribs(colorsForCanvas, fontsForCanvas, imagesForCanvas);
        this.setAttribs();
        this.dimView = dimension;
        this.iTabOrientation = n;
        this.setLayout(new TabViewLayout());
        this.setBounds(point.x, point.y, dimension.width, dimension.height);
        this.createComponents(point, dimension, this.cfcColor, this.ffcFont, this.ifcImage, n);
        this.setBackground(colorsForCanvas.getColor(0));
    }

    public int getOrientation() {
        return this.iTabOrientation;
    }

    private void createComponents(Point point, Dimension dimension, ColorsForCanvas colorsForCanvas, FontsForCanvas fontsForCanvas, ImagesForCanvas imagesForCanvas, int n) {
        this.tv = new TabsView(this, dimension, colorsForCanvas, fontsForCanvas, imagesForCanvas, n);
        this.cv = new CardView(dimension, colorsForCanvas);
        this.add("tv", this.tv);
        this.add("cv", this.cv);
    }

    public void setAutoFocus(boolean bl) {
        try {
            this.tv.setAutoFocus(bl);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public Dimension getMinSize() {
        return this.dimView;
    }

    public void addTab(TabViewNode tabViewNode) {
        this.cv.addPanel(tabViewNode);
        this.tv.addTab(tabViewNode);
        this.vTabs.addElement(tabViewNode);
    }

    public void removeTab(TabViewNode tabViewNode) {
        this.cv.removePanel(tabViewNode);
        this.tv.removeTab(tabViewNode);
        this.vTabs.removeElement(tabViewNode);
    }

    public void removeAllTabs() {
        try {
            Enumeration enumeration = this.vTabs.elements();
            TabViewNode tabViewNode = null;
            while (enumeration.hasMoreElements()) {
                tabViewNode = (TabViewNode)enumeration.nextElement();
                this.cv.removePanel(tabViewNode);
                this.tv.removeTab(tabViewNode);
            }
            return;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return;
        }
    }

    public void addControler(Controler controler) {
        this.tv.setControler(controler);
    }

    public void tabSelected(TabViewNode tabViewNode) {
        this.cv.selectPanel(tabViewNode);
    }

    public void selectTab(TabViewNode tabViewNode) {
        this.selectTab(tabViewNode, false);
    }

    public void selectTab(TabViewNode tabViewNode, boolean bl) {
        this.selectTab(tabViewNode, bl, true);
    }

    public void selectTab(TabViewNode tabViewNode, boolean bl, boolean bl2) {
        this.tv.selectTab(tabViewNode, bl2);
        if (bl) {
            this.tv.showTab(tabViewNode);
        }
    }

    public TabViewNode getSelectedTab() {
        return this.cv.getSelectedPanel();
    }

    public Dimension getDisplaySize() {
        return this.cv.getDisplaySize();
    }

    public void committ() {
        this.tv.committ();
        this.repaint();
    }

    public void addTabViewEventListener(TabViewEventListener tabViewEventListener) {
        this.tv.addListener(tabViewEventListener);
    }

    public void removeTabViewEventListener(TabViewEventListener tabViewEventListener) {
        this.tv.removeListener(tabViewEventListener);
    }
}

