/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.textPanel;

import com.ibm.eNetwork.onDemand.common.TraceLevels;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.StringTokenizer;

public class TextCanvas
extends Canvas
implements TraceLevels {
    String string;
    Font font;
    Insets insets;

    public TextCanvas(String string) {
        this(string, null);
    }

    public TextCanvas(String string, Font font) {
        this.string = string;
        this.font = font == null ? this.getFont() : font;
        this.insets = new Insets(0, 0, 0, 0);
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        ((Component)frame).setSize(400, 200);
        ((Component)frame).setVisible(true);
    }

    public void setInsets(Insets insets) {
        if (insets != null) {
            this.insets = insets;
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        StringTokenizer stringTokenizer = new StringTokenizer(this.string, " \n", true);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        int n2 = this.insets.right;
        int n3 = n + this.insets.top;
        while (stringTokenizer.hasMoreTokens() && n3 - n < dimension.height - this.insets.bottom) {
            String string = stringTokenizer.nextToken();
            int n4 = fontMetrics.stringWidth(string);
            if (string.compareTo("\n") == 0) {
                n3 += n;
                n2 = this.insets.right;
                string = "";
                n4 = 0;
            } else if (n2 + n4 > dimension.width - this.insets.left) {
                n3 += n;
                n2 = this.insets.right;
            }
            graphics.drawString(string, n2, n3);
            n2 += n4;
        }
    }

    public Dimension getPreferredSize() {
        int n = this.getParent().getSize().width;
        int n2 = this.getPreferredHeight(n);
        if (this.insets != null) {
            n += this.insets.left + this.insets.right;
            n2 += this.insets.top + this.insets.bottom;
        }
        return new Dimension(n, n2);
    }

    protected int getPreferredHeight(int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.string, " \n", true);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return 100;
        }
        int n2 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        int n3 = this.insets.right;
        int n4 = n2 + this.insets.top;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            int n5 = fontMetrics.stringWidth(string);
            if (string.compareTo("\n") == 0) {
                n4 += n2;
                n3 = this.insets.right;
                n5 = 0;
            }
            if (n3 + n5 > n - this.insets.left || string.compareTo("\n") == 0) {
                n4 += n2;
                n3 = this.insets.right;
            }
            n3 += n5;
        }
        return n4;
    }
}

