/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.tooltip;

import com.ibm.eNetwork.onDemand.common.TimerListener;
import com.ibm.eNetwork.onDemand.common.gui.tooltip.TooltipWindow;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Frame;
import netscape.security.PrivilegeManager;

public class Tooltip
implements TimerListener {
    protected int iTimerCount;
    protected int iStartWaitTime;
    protected String sLabel = "";
    protected static boolean boolFastDisplay;
    protected static Tooltip currentToolTip;
    protected boolean boolWaitingToShow = false;
    protected boolean boolListeningToTimer = false;
    protected boolean boolIsEnabled = true;
    protected Frame parentFrame;
    protected TooltipWindow tooltipWindow;
    protected static int iHalfSecsToWait;
    protected boolean boolToFront = true;

    public Tooltip(Frame frame, String string) {
        this.parentFrame = frame;
        this.iTimerCount = 0;
        this.sLabel = string;
    }

    public void setDelay(int n) {
        iHalfSecsToWait = n;
    }

    public void setToFront(boolean bl) {
        this.boolToFront = bl;
    }

    private void init() {
        if (this.tooltipWindow != null) {
            FontMetrics fontMetrics = this.tooltipWindow.getFontMetrics(this.tooltipWindow.getFont());
            int n = fontMetrics.stringWidth(this.sLabel) + 4;
            int n2 = fontMetrics.getHeight() + 2;
            ((Component)this.tooltipWindow).setSize(n, n2);
        }
    }

    public void showAfterDelay(int n, int n2) {
        if (this.tooltipWindow == null) {
            PrivilegeManager.enablePrivilege("UniversalTopLevelWindow");
            PolicyEngine.assertPermission(PermissionID.SYSTEM);
            this.tooltipWindow = new TooltipWindow(this.parentFrame, this.sLabel);
        }
        if (!this.tooltipWindow.isVisible()) {
            if (currentToolTip == null) {
                currentToolTip = this;
            } else {
                currentToolTip.hideTooltip();
                currentToolTip = this;
            }
            ((Component)this.tooltipWindow).setLocation(n, n2);
            this.iTimerCount = 0;
            this.boolWaitingToShow = true;
            this.boolListeningToTimer = true;
        }
    }

    protected void showNow() {
        if (!this.boolIsEnabled) {
            return;
        }
        TooltipWindow tooltipWindow = this.tooltipWindow;
        synchronized (tooltipWindow) {
            if (this.tooltipWindow == null) {
                PrivilegeManager.enablePrivilege("UniversalTopLevelWindow");
                PolicyEngine.assertPermission(PermissionID.SYSTEM);
                this.tooltipWindow = new TooltipWindow(this.parentFrame, this.sLabel);
            }
            ((Component)this.tooltipWindow).setVisible(true);
            if (this.boolToFront) {
                this.tooltipWindow.toFront();
            }
            this.tooltipWindow.repaint();
            this.boolWaitingToShow = false;
            if (this.boolListeningToTimer) {
                this.boolListeningToTimer = false;
            }
            return;
        }
    }

    public void hideTooltip() {
        if (this.tooltipWindow == null) {
            return;
        }
        TooltipWindow tooltipWindow = this.tooltipWindow;
        synchronized (tooltipWindow) {
            this.boolListeningToTimer = false;
            this.boolWaitingToShow = false;
            if (this.tooltipWindow != null) {
                ((Component)this.tooltipWindow).setVisible(false);
                this.tooltipWindow.dispose();
                this.tooltipWindow = null;
            }
            if (currentToolTip == this) {
                currentToolTip = null;
            }
            this.iTimerCount = 50;
            this.boolListeningToTimer = true;
            return;
        }
    }

    public String getLabel() {
        return this.sLabel;
    }

    public void setLabel(String string) {
        this.sLabel = string;
    }

    public void setEnabled(boolean bl) {
        this.boolIsEnabled = bl;
    }

    public boolean getEnabled() {
        return this.boolIsEnabled;
    }

    public synchronized void setFastDisplay(boolean bl) {
        boolFastDisplay = bl;
    }

    public void timerFired() {
        if (this.boolListeningToTimer) {
            ++this.iTimerCount;
            if (this.boolWaitingToShow) {
                if (this.iTimerCount == iHalfSecsToWait) {
                    this.boolListeningToTimer = false;
                    boolFastDisplay = true;
                    this.showNow();
                } else if (boolFastDisplay && this.iTimerCount == 1) {
                    this.boolListeningToTimer = false;
                    boolFastDisplay = true;
                    this.showNow();
                }
            }
            if (this.iTimerCount > 49 && this.iTimerCount < 75) {
                if (currentToolTip != null) {
                    this.boolListeningToTimer = false;
                    return;
                }
                this.iTimerCount = 75;
                return;
            }
            if (this.iTimerCount > 75) {
                if (currentToolTip != null) {
                    this.boolListeningToTimer = false;
                    return;
                }
                boolFastDisplay = false;
                this.boolListeningToTimer = false;
            }
        }
    }

    public void finalize() {
        if (this.tooltipWindow != null) {
            this.tooltipWindow.dispose();
            this.tooltipWindow = null;
        }
    }

    static {
        currentToolTip = null;
        iHalfSecsToWait = 4;
    }
}

