/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.treeView;

import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewCanvas;
import com.ibm.eNetwork.onDemand.common.gui.treeView.ableToUseDragManager;
import com.ibm.eNetwork.onDemand.common.gui.treeView.addableToTreeView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class DragManager {
    protected Vector vViews = new Vector(2, 2);
    protected Vector vClients = new Vector(2, 2);
    protected Vector vPositions;
    protected static final int DRAW_GHOST = 0;
    protected static final int DRAG_DROP = 1;
    protected addableToTreeView attvNode;
    protected TreeViewCanvas tvLastDest;
    protected static DragManager dm = null;

    protected DragManager() {
    }

    public static DragManager getDragManager() {
        if (dm == null) {
            dm = new DragManager();
        }
        return dm;
    }

    public void registerView(TreeViewCanvas treeViewCanvas, ableToUseDragManager ableToUseDragManager2) {
        this.vViews.addElement(treeViewCanvas);
        this.vClients.addElement(ableToUseDragManager2);
    }

    public void unregisterView(TreeViewCanvas treeViewCanvas, ableToUseDragManager ableToUseDragManager2) {
        this.vViews.removeElement(treeViewCanvas);
        this.vClients.removeElement(ableToUseDragManager2);
    }

    public void startDrag(TreeViewCanvas treeViewCanvas, addableToTreeView addableToTreeView2) {
        this.findAbsolutePositions();
        this.attvNode = addableToTreeView2;
        this.tvLastDest = null;
    }

    public void stopDrag(TreeViewCanvas treeViewCanvas, Point point) {
        TreeViewCanvas treeViewCanvas2 = this.findTarget(treeViewCanvas, point);
        int n = this.vViews.indexOf(treeViewCanvas);
        ableToUseDragManager ableToUseDragManager2 = (ableToUseDragManager)this.vClients.elementAt(n);
        if (treeViewCanvas2 != null) {
            boolean bl = this.callbackClient(treeViewCanvas, treeViewCanvas2, point, 1);
            ableToUseDragManager2.dropAccomplished(bl, this.attvNode);
        } else {
            ableToUseDragManager2.dropAccomplished(false, this.attvNode);
        }
        this.vPositions.removeAllElements();
    }

    public void drag(TreeViewCanvas treeViewCanvas, Point point) {
        TreeViewCanvas treeViewCanvas2 = this.findTarget(treeViewCanvas, point);
        if (treeViewCanvas2 != this.tvLastDest) {
            if (this.tvLastDest != null) {
                this.callbackClient(treeViewCanvas, this.tvLastDest, new Point(0, 0), 0);
            }
            this.tvLastDest = treeViewCanvas2;
        }
        if (treeViewCanvas2 != null) {
            this.callbackClient(treeViewCanvas, treeViewCanvas2, point, 0);
        }
    }

    protected boolean callbackClient(TreeViewCanvas treeViewCanvas, TreeViewCanvas treeViewCanvas2, Point point, int n) {
        int n2 = this.vViews.indexOf(treeViewCanvas2);
        ableToUseDragManager ableToUseDragManager2 = (ableToUseDragManager)this.vClients.elementAt(n2);
        Point point2 = this.findCachedPosition(treeViewCanvas2);
        Point point3 = this.findCachedPosition(treeViewCanvas);
        point3.x += point.x;
        point3.y += point.y;
        point2.x = point3.x - point2.x;
        point2.y = point3.y - point2.y;
        if (n == 0) {
            ableToUseDragManager2.drawGhostAt(point2);
            return false;
        }
        return ableToUseDragManager2.droppedAt(point2, this.attvNode);
    }

    protected Point findCachedPosition(TreeViewCanvas treeViewCanvas) {
        int n = this.vViews.indexOf(treeViewCanvas);
        Rectangle rectangle = (Rectangle)this.vPositions.elementAt(n);
        Point point = new Point(rectangle.x, rectangle.y);
        return point;
    }

    protected TreeViewCanvas findTarget(TreeViewCanvas treeViewCanvas, Point point) {
        Enumeration enumeration = this.vPositions.elements();
        Point point2 = this.findCachedPosition(treeViewCanvas);
        point2.x += point.x;
        point2.y += point.y;
        int n = 0;
        Rectangle rectangle = null;
        TreeViewCanvas treeViewCanvas2 = null;
        while (enumeration.hasMoreElements()) {
            rectangle = (Rectangle)enumeration.nextElement();
            if (point2.x >= rectangle.x && point2.x <= rectangle.x + rectangle.width && point2.y >= rectangle.y && point2.y <= rectangle.y + rectangle.height && (treeViewCanvas2 = (TreeViewCanvas)this.vViews.elementAt(n)).isShowing()) {
                return treeViewCanvas2;
            }
            ++n;
        }
        return null;
    }

    protected void findAbsolutePositions() {
        this.vPositions = new Vector();
        Enumeration enumeration = this.vViews.elements();
        TreeViewCanvas treeViewCanvas = null;
        Point point = null;
        Dimension dimension = null;
        Rectangle rectangle = null;
        while (enumeration.hasMoreElements()) {
            treeViewCanvas = (TreeViewCanvas)enumeration.nextElement();
            point = this.findAbsolutePosition(treeViewCanvas);
            dimension = treeViewCanvas.getSize();
            rectangle = new Rectangle(point.x, point.y, dimension.width, dimension.height);
            this.vPositions.addElement(rectangle);
        }
    }

    protected Point findAbsolutePosition(Component component) {
        if (component == null) {
            return null;
        }
        Point point = new Point(0, 0);
        Point point2 = null;
        do {
            point2 = component.getLocation();
            point.x += point2.x;
            point.y += point2.y;
        } while ((component = component.getParent()) != null);
        return point;
    }
}

