/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.treeView;

import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.DrawableNode;
import com.ibm.eNetwork.onDemand.common.gui.common.DrawableObject;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.LeftAlignedNode;
import com.ibm.eNetwork.onDemand.common.gui.common.ViewCanvas;
import com.ibm.eNetwork.onDemand.common.gui.treeView.CommitTypes;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewNode;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewScheme;
import com.ibm.eNetwork.onDemand.common.gui.treeView.ableToUseTreeViewCanvas;
import com.ibm.eNetwork.onDemand.common.gui.treeView.ableToUseTreeViewNode;
import com.ibm.eNetwork.onDemand.common.gui.treeView.addableToTreeView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class TreeViewCanvas
extends ViewCanvas
implements ableToUseTreeViewNode,
CommitTypes {
    protected int iTopBuffer = 10;
    protected int iInset = 20;
    protected boolean bResetNodeLocation = true;
    protected Image iPlus;
    protected Image iMinus;
    protected int iNumNodes;
    protected TreeViewNode tvnBottom;
    protected ableToUseTreeViewCanvas atutvcParent;
    protected int iNumNodesOnPage;
    protected int iCurrentNodePos = 1;
    protected TreeViewNode tvnPrev;
    protected TreeViewNode tvnOldTop;
    protected TreeViewNode tvnOldBottom;
    protected TreeViewNode tvnDropZone;
    protected addableToTreeView attvDesiredTop;
    protected int iExtraWidth;
    protected int iHorzOffset;
    protected int iPopupOffset;
    protected int iOptimisedPaint = 0;
    protected static final int MAGNIFICATION = 1;
    protected boolean bDrawNodeLines = true;
    protected boolean bNonUserSelect = false;
    private Point pTemp;
    private Point pTemp2;
    private Dimension dTemp;
    private Dimension dTemp2;
    private TreeViewNode tvnTemp;
    protected boolean bDrawAsDraggable = false;
    protected boolean bMultiSelect = false;
    protected Vector vSelectedNodes;
    protected static final int NO_OPTIMIZATION = 0;
    protected static final int ADJACENT_NODES = 1;
    protected long lCommittTime;
    protected boolean bFocus = false;

    public TreeViewCanvas(ableToUseTreeViewCanvas ableToUseTreeViewCanvas2, addableToTreeView addableToTreeView2, ColorsForCanvas colorsForCanvas, FontsForCanvas fontsForCanvas, ImagesForCanvas imagesForCanvas) {
        this.copyAttribs(colorsForCanvas, fontsForCanvas, imagesForCanvas);
        this.setAttribs();
        this.atutvcParent = ableToUseTreeViewCanvas2;
        this.calcBuffers();
        this.addRootNode(addableToTreeView2);
    }

    public void setImages(Image image, Image image2) {
        try {
            this.iPlus = image;
            this.iMinus = image2;
            this.iInset = this.ifcImage.getImageWidth(image);
            this.recommittNodes();
            return;
        }
        catch (Exception exception) {
            System.err.println("Error in " + this + "[setImages()]");
            return;
        }
    }

    protected void recommittNodes() {
        this.tvnTemp = (TreeViewNode)this.lanTop;
        while (this.tvnTemp != null) {
            this.tvnTemp.committ();
            this.tvnTemp = (TreeViewNode)this.tvnTemp.getNext();
        }
    }

    protected void calcBuffers() {
        this.iTopBuffer = this.ffcFont.getFontHeight(1) / 2;
        this.iInset = this.ffcFont.getFontMaxWidth(1);
    }

    public TreeViewCanvas() {
    }

    public DrawableObject findOnGotFocus() {
        return this.findSelectedTreeViewNode();
    }

    public DrawableObject findCurrent() {
        return this.findSelectedTreeViewNode();
    }

    public DrawableObject findOnMouseUp(int n, int n2) {
        return this.findTreeViewNode(n, n2);
    }

    public DrawableObject findOnMouseDown(int n, int n2) {
        return this.findTreeViewNode(n, n2);
    }

    public DrawableObject findOnMouseMove(int n, int n2) {
        return this.findTreeViewNode(n, n2);
    }

    public DrawableObject findOnKeyUp(int n) {
        return this.findSelectedTreeViewNode();
    }

    public DrawableObject findOnKeyDown(int n) {
        return this.findSelectedTreeViewNode();
    }

    protected void startingNode(TreeViewNode treeViewNode) {
        if (treeViewNode == null) {
            return;
        }
        this.lanCurrent = treeViewNode;
    }

    public void moveToNextNode() {
        TreeViewNode treeViewNode = (TreeViewNode)this.lanCurrent.getNext();
        this.startingNode(treeViewNode);
        this.bResetNodeLocation = true;
        this.saveOldNodes();
        if (treeViewNode != null) {
            this.atutvcParent.currentNodePos(++this.iCurrentNodePos);
        }
        this.repaint();
    }

    public void moveToNextPage(boolean bl) {
        this.startingNode(this.tvnBottom);
        this.iCurrentNodePos += this.iNumNodesOnPage - 1;
        this.atutvcParent.currentNodePos(this.iCurrentNodePos);
        this.bResetNodeLocation = true;
        this.saveOldNodes();
        if (bl) {
            this.repaint();
        }
    }

    public void moveToPrevNode() {
        TreeViewNode treeViewNode = (TreeViewNode)this.lanCurrent.getPrev();
        this.startingNode(treeViewNode);
        this.bResetNodeLocation = true;
        this.saveOldNodes();
        if (treeViewNode != null) {
            this.atutvcParent.currentNodePos(--this.iCurrentNodePos);
        }
        this.repaint();
    }

    public void moveToPrevPage(boolean bl) {
        this.startingNode(this.calcNewTop((TreeViewNode)this.lanCurrent));
        this.bResetNodeLocation = true;
        this.saveOldNodes();
        this.atutvcParent.currentNodePos(this.iCurrentNodePos);
        if (bl) {
            this.repaint();
        }
    }

    protected TreeViewNode calcNewTop(TreeViewNode treeViewNode) {
        TreeViewNode treeViewNode2 = (TreeViewNode)treeViewNode.getNext();
        int n = this.getSize().height;
        int n2 = 0;
        if (treeViewNode2 == null) {
            treeViewNode2 = treeViewNode;
        } else {
            ++this.iCurrentNodePos;
        }
        while (treeViewNode2 != null && n2 < n - treeViewNode2.getHeight()) {
            n2 += treeViewNode2.getHeight();
            --this.iCurrentNodePos;
            treeViewNode2 = (TreeViewNode)treeViewNode2.getPrev();
        }
        if (treeViewNode2 != null) {
            treeViewNode2 = (TreeViewNode)treeViewNode2.getNext();
        }
        if (treeViewNode2 == null) {
            this.iCurrentNodePos = 1;
            treeViewNode2 = (TreeViewNode)this.lanTop;
        }
        return treeViewNode2;
    }

    public void selectNextNode() {
        if (this.lanSelected == null) {
            this.selectNode((TreeViewNode)this.lanTop);
            this.repaint();
            return;
        }
        if (this.lanSelected.getNext() != null) {
            if ((TreeViewNode)this.lanSelected == this.tvnBottom) {
                this.moveToNextPage(true);
                return;
            }
            this.tvnTemp = (TreeViewNode)this.lanSelected.getNext();
            if (this.lanSelected != this.lanTop && this.tvnTemp != this.lanBottom) {
                this.pTemp = this.lanSelected.getLocation();
                this.pTemp2 = this.tvnTemp.getLocation();
                this.dTemp = new Dimension(this.tvnTemp.getMaxWidth(), this.tvnTemp.getHeight());
                this.dTemp2 = new Dimension(((TreeViewNode)this.lanSelected).getMaxWidth(), this.lanSelected.getHeight());
                this.selectNode(this.tvnTemp);
                this.iOptimisedPaint = 1;
                this.repaint(Math.min(this.pTemp.x, this.pTemp2.x), Math.min(this.pTemp.y, this.pTemp2.y), Math.max(this.dTemp.width, this.dTemp2.width), this.dTemp.height + (this.pTemp2.y - this.pTemp.y));
                return;
            }
            this.selectNode(this.tvnTemp);
            this.repaint();
        }
    }

    public void selectPrevNode() {
        if (this.lanSelected == null) {
            this.selectNode((TreeViewNode)this.lanTop);
            this.repaint();
            return;
        }
        if (this.lanSelected.getPrev() != null) {
            if (this.lanSelected == this.lanCurrent) {
                this.moveToPrevPage(true);
                return;
            }
            this.tvnTemp = (TreeViewNode)this.lanSelected.getPrev();
            if (this.lanSelected != this.lanBottom && this.tvnTemp != this.lanTop) {
                this.pTemp = this.lanSelected.getLocation();
                this.pTemp2 = this.tvnTemp.getLocation();
                this.dTemp = new Dimension(((TreeViewNode)this.lanSelected).getMaxWidth(), this.lanSelected.getHeight());
                this.dTemp2 = new Dimension(this.tvnTemp.getMaxWidth(), this.tvnTemp.getHeight());
                this.selectNode(this.tvnTemp);
                this.iOptimisedPaint = 1;
                this.repaint(Math.min(this.pTemp.x, this.pTemp2.x), Math.min(this.pTemp.y, this.pTemp2.y), Math.max(this.dTemp.width, this.dTemp2.width), this.dTemp.height + (this.pTemp.y - this.pTemp2.y));
                return;
            }
            this.selectNode(this.tvnTemp);
            this.repaint();
        }
    }

    public void selectNode(TreeViewNode treeViewNode) {
        if (treeViewNode != null) {
            if (treeViewNode.getPrev() != null && treeViewNode.getPrev() == this.tvnBottom) {
                this.moveToNextPage(true);
                return;
            }
            if (treeViewNode.getNext() != null && treeViewNode.getNext() == this.lanCurrent) {
                this.moveToPrevPage(true);
                return;
            }
            if (this.bMultiSelect) {
                this.unselectAllNodes();
                this.singleSelectNode(treeViewNode);
                return;
            }
            this.singleSelectNode(treeViewNode);
            return;
        }
        this.singleSelectNode(treeViewNode);
    }

    protected void singleSelectNode(TreeViewNode treeViewNode) {
        if (this.lanSelected != null) {
            this.lanSelected.setSelected(false);
            this.tvnPrev = (TreeViewNode)this.lanSelected;
        }
        this.lanSelected = treeViewNode;
        if (this.lanSelected != null) {
            this.lanSelected.setSelected(true);
        }
    }

    public void multiSelectNode(TreeViewNode treeViewNode) {
        if (!this.bMultiSelect || treeViewNode == null) {
            return;
        }
        try {
            if (this.lanSelected != null && this.vSelectedNodes.indexOf(this.lanSelected) == -1) {
                this.vSelectedNodes.addElement(this.lanSelected);
            }
            this.vSelectedNodes.addElement(treeViewNode);
            this.singleSelectNode(treeViewNode);
            if (this.tvnPrev != null) {
                this.tvnPrev.setSelected(true);
                this.tvnPrev.setFocus(false);
                return;
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public void unselectNode(TreeViewNode treeViewNode) {
        try {
            if (!this.bMultiSelect) {
                return;
            }
            if (treeViewNode == this.lanSelected) {
                this.lanSelected = null;
            }
            treeViewNode.setSelected(false);
            this.vSelectedNodes.removeElement(treeViewNode);
            return;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return;
        }
    }

    public void unselectAllNodes() {
        try {
            if (!this.bMultiSelect) {
                return;
            }
            Enumeration enumeration = ((Vector)this.vSelectedNodes.clone()).elements();
            while (enumeration.hasMoreElements()) {
                this.unselectNode((TreeViewNode)enumeration.nextElement());
            }
            return;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return;
        }
    }

    public void selectNode(addableToTreeView addableToTreeView2) {
        this.bNonUserSelect = true;
        TreeViewNode treeViewNode = this.createBastardTreeNode((TreeViewNode)this.lanTop, addableToTreeView2, this.lCommittTime);
        this.selectNode(treeViewNode);
        this.repaint();
        this.bNonUserSelect = false;
    }

    public void expandAllNodes(boolean bl) {
        this.traverseAndExpandAllNodes((TreeViewNode)this.lanTop, bl);
        this.commit(1);
    }

    protected void traverseAndExpandAllNodes(TreeViewNode treeViewNode, boolean bl) {
        try {
            long l = System.currentTimeMillis();
            TreeViewNode treeViewNode2 = treeViewNode;
            while (treeViewNode2 != null) {
                treeViewNode2.setExpanded(bl);
                if (treeViewNode2.hasChild()) {
                    TreeViewNode treeViewNode3 = treeViewNode.createChildTreeNode(this.lCommittTime);
                    this.traverseAndExpandAllNodes(treeViewNode3, bl);
                }
                treeViewNode2 = treeViewNode2.createNextTreeNode(l);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void expandNode(addableToTreeView addableToTreeView2, boolean bl, boolean bl2) {
        TreeViewNode treeViewNode = this.createBastardTreeNode((TreeViewNode)this.lanTop, addableToTreeView2, this.lCommittTime);
        treeViewNode.setExpanded(bl);
        if (bl2) {
            this.commit(1);
        }
    }

    public void addNode(LeftAlignedNode leftAlignedNode, LeftAlignedNode leftAlignedNode2) {
        super.addNode(leftAlignedNode, leftAlignedNode2);
        if (this.lanCurrent == null) {
            this.lanCurrent = leftAlignedNode;
        }
    }

    public void addNode(LeftAlignedNode leftAlignedNode) {
        super.addNode(leftAlignedNode);
        if (this.lanCurrent == null) {
            this.lanCurrent = leftAlignedNode;
            this.selectNode((TreeViewNode)leftAlignedNode);
        }
    }

    public void draw(Graphics graphics) {
        if (this.iOptimisedPaint > 0) {
            if (this.ifcImage.getImage(2) == null) {
                this.cfcColor.getColor(0);
                this.tvnPrev.setBackgroundPainting(true);
                ((TreeViewNode)this.lanSelected).setBackgroundPainting(true);
            }
            this.pTemp = this.tvnPrev.getLocation();
            Rectangle rectangle = new Rectangle(this.pTemp.x, this.pTemp.y, this.tvnPrev.getMaxWidth(), this.tvnPrev.getHeight());
            if (this.tvnPrev.isOnScreen()) {
                this.tvnPrev.draw(graphics, rectangle);
                this.tvnPrev.setLocation(this.pTemp);
            }
            this.pTemp = this.lanSelected.getLocation();
            rectangle = new Rectangle(this.pTemp.x, this.pTemp.y, ((TreeViewNode)this.lanSelected).getMaxWidth(), this.lanSelected.getHeight());
            this.lanSelected.draw(graphics, rectangle);
            this.lanSelected.setLocation(this.pTemp);
            if (this.ifcImage.getImage(2) == null) {
                this.tvnPrev.setBackgroundPainting(false);
                ((TreeViewNode)this.lanSelected).setBackgroundPainting(false);
            }
        } else {
            this.setNodeLocations();
            this.drawNodes(graphics);
        }
        this.tvnPrev = null;
        this.iOptimisedPaint = 0;
        this.drawDraggableBox(graphics);
    }

    protected void drawDraggableBox(Graphics graphics) {
        try {
            if (!this.bDrawAsDraggable) {
                return;
            }
            Rectangle rectangle = this.getBounds();
            graphics.setColor(Color.black);
            graphics.drawRect(2, 2, rectangle.width - 4, rectangle.height - 4);
            return;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return;
        }
    }

    protected TreeViewNode findTreeViewNode(int n, int n2) {
        this.tvnTemp = (TreeViewNode)this.lanCurrent;
        this.pTemp = null;
        int n3 = this.ifcImage.getImageWidth(this.iPlus);
        while (this.tvnTemp != null) {
            this.pTemp = this.tvnTemp.getLocation();
            if (n > this.pTemp.x - n3 && n2 > this.pTemp.y && n < this.pTemp.x + this.tvnTemp.getMaxWidth() && this.tvnTemp.isOnScreen() && n2 < this.pTemp.y + this.tvnTemp.getHeight()) {
                return this.tvnTemp;
            }
            this.tvnTemp = (TreeViewNode)this.tvnTemp.getNext();
        }
        return null;
    }

    public TreeViewNode findSelectedTreeViewNode() {
        return (TreeViewNode)this.lanSelected;
    }

    public void committ() {
        this.committ(true);
    }

    public void committ(boolean bl) {
        if (bl) {
            this.commit(3);
            return;
        }
        this.commit(2);
    }

    public synchronized void commit(int n) {
        boolean bl = false;
        this.setWaitCursor();
        if ((n & 1) == 1) {
            if (this.lanCurrent != null && this.attvDesiredTop == null) {
                bl = true;
                this.attvDesiredTop = ((TreeViewNode)this.lanCurrent).getAddableToTreeView();
            }
            if ((n & 2) == 2) {
                this.updateCommittTime();
            }
            this.buildDisplayList();
        } else if ((n & 2) == 2) {
            this.recommittNodes();
        }
        this.repaint();
        this.clearWaitCursor();
        if (bl) {
            this.attvDesiredTop = null;
        }
    }

    protected void buildDisplayList() {
        this.iNumNodes = 0;
        ((TreeViewNode)this.lanTop).setLineDrawing(this.bDrawNodeLines);
        if (this.lanTop.getNext() != null) {
            this.removeTreeLinks((TreeViewNode)this.lanTop.getNext());
        }
        this.lanTop.setNext(null);
        this.lanTop.committ();
        this.resetVars();
        this.addTreeToDisplayList(null, (TreeViewNode)this.lanTop);
        this.atutvcParent.numNodesChanged(this.iNumNodes);
        this.atutvcParent.currentNodePos(this.iCurrentNodePos);
        this.bResetNodeLocation = true;
        this.saveOldNodes();
        this.setNodeLocations();
    }

    public void showNode(addableToTreeView addableToTreeView2) {
        addableToTreeView addableToTreeView3 = addableToTreeView2;
        TreeViewNode treeViewNode = null;
        if (addableToTreeView3 == null) {
            return;
        }
        this.attvDesiredTop = addableToTreeView3;
        while (addableToTreeView3 != null) {
            treeViewNode = this.createBastardTreeNode((TreeViewNode)this.lanTop, addableToTreeView3, this.lCommittTime);
            if (treeViewNode == null) break;
            treeViewNode.setExpanded(true);
            addableToTreeView3 = addableToTreeView3.getParentNode();
        }
        this.commit(1);
        this.attvDesiredTop = null;
        this.atutvcParent.currentNodePos(this.iCurrentNodePos);
    }

    protected TreeViewNode addTreeToDisplayList(TreeViewNode treeViewNode, TreeViewNode treeViewNode2) {
        this.setWaitCursor();
        int n = 0;
        TreeViewNode treeViewNode3 = treeViewNode;
        TreeViewNode treeViewNode4 = null;
        TreeViewNode treeViewNode5 = null;
        if (treeViewNode2 == null) {
            return null;
        }
        treeViewNode2.resetNode();
        if (treeViewNode != null) {
            treeViewNode.resetNode();
            n = treeViewNode.getDepth();
        }
        ++n;
        while (treeViewNode2 != null) {
            ++this.iNumNodes;
            if (treeViewNode2.getAddableToTreeView() == this.attvDesiredTop) {
                this.lanCurrent = treeViewNode2;
                this.iCurrentNodePos = this.iNumNodes;
                this.atutvcParent.currentNodePos(this.iCurrentNodePos);
            }
            if (treeViewNode2.getSelected()) {
                this.lanSelected = treeViewNode2;
            }
            treeViewNode2.setDepth(n);
            this.addNode(treeViewNode2, treeViewNode3);
            treeViewNode3 = treeViewNode2.hasChild() && treeViewNode2.getExpanded() ? ((treeViewNode4 = this.createChildTreeNode(treeViewNode2, this.lCommittTime)) != null ? this.addTreeToDisplayList(treeViewNode2, treeViewNode4) : treeViewNode2) : treeViewNode2;
            treeViewNode5 = treeViewNode2;
            treeViewNode2 = this.createNextTreeNode(treeViewNode2, this.lCommittTime);
        }
        treeViewNode5.setLeafNode(true);
        this.clearWaitCursor();
        return treeViewNode3;
    }

    protected TreeViewNode createChildTreeNode(TreeViewNode treeViewNode, long l) {
        TreeViewNode treeViewNode2 = treeViewNode.createChildTreeNode(l);
        return treeViewNode2;
    }

    protected TreeViewNode createNextTreeNode(TreeViewNode treeViewNode, long l) {
        TreeViewNode treeViewNode2 = treeViewNode.createNextTreeNode(l);
        return treeViewNode2;
    }

    protected TreeViewNode createBastardTreeNode(TreeViewNode treeViewNode, addableToTreeView addableToTreeView2, long l) {
        TreeViewNode treeViewNode2 = treeViewNode.createBastardTreeNode(addableToTreeView2, l);
        return treeViewNode2;
    }

    protected synchronized void setNodeLocations() {
        if (!this.bResetNodeLocation) {
            return;
        }
        this.bResetNodeLocation = false;
        this.tvnTemp = this.tvnOldTop;
        int n = this.getSize().height;
        int n2 = this.iTopBuffer;
        int n3 = this.iInset;
        Point point = null;
        int n4 = this.getSize().width;
        do {
            if (this.tvnTemp == null) continue;
            this.tvnTemp.onScreen(false);
            this.tvnTemp = (TreeViewNode)this.tvnTemp.getNext();
        } while (this.tvnTemp != null && this.tvnTemp != this.tvnOldBottom);
        this.tvnTemp = (TreeViewNode)this.lanCurrent;
        while (this.tvnTemp != null && n2 < n - this.tvnTemp.getHeight()) {
            int n5;
            n3 = this.tvnTemp.getDepth() * this.iInset;
            point = new Point(n3, n2);
            this.tvnTemp.setLocation(point);
            this.tvnTemp.onScreen(true);
            if (this.tvnTemp.getSelected()) {
                this.lanSelected = this.tvnTemp;
            }
            n2 += this.tvnTemp.getHeight();
            if (n3 + this.tvnTemp.getMaxWidth() > n4 && (n5 = n3 + this.tvnTemp.getMaxWidth() - n4) > this.iExtraWidth) {
                this.iExtraWidth = n5;
            }
            this.tvnBottom = this.tvnTemp;
            this.tvnTemp = (TreeViewNode)this.tvnTemp.getNext();
        }
        this.atutvcParent.offscreenWidth(this.iExtraWidth + 1);
    }

    public void setHorzOffset(int n) {
        Point point = this.getLocation();
        Dimension dimension = this.getSize();
        this.iPopupOffset = -1 * n;
        this.setLocation(-1 * n, point.y);
        super.setSize(dimension.width + n, dimension.height);
        this.repaint();
    }

    protected void drawNodes(Graphics graphics) {
        this.tvnTemp = (TreeViewNode)this.lanCurrent;
        int n = this.getSize().height;
        int n2 = this.iTopBuffer;
        boolean bl = false;
        Rectangle rectangle = new Rectangle(1, 1, 1, 1);
        Point point = null;
        this.iNumNodesOnPage = 0;
        while (this.tvnTemp != null && n2 < n - this.tvnTemp.getHeight()) {
            point = this.tvnTemp.getLocation();
            rectangle.x = point.x;
            rectangle.y = point.y;
            rectangle.width = this.tvnTemp.getMaxWidth();
            rectangle.height = this.tvnTemp.getHeight();
            this.tvnTemp.setBackgroundPainting(bl);
            this.tvnTemp.draw(graphics, rectangle);
            this.tvnTemp.setLocation(point);
            n2 += this.tvnTemp.getHeight();
            ++this.iNumNodesOnPage;
            this.tvnTemp = (TreeViewNode)this.tvnTemp.getNext();
        }
    }

    public void addRootNode(addableToTreeView addableToTreeView2) {
        if (addableToTreeView2 == null) {
            System.out.println("Fatal Error: Null root node");
            return;
        }
        this.lanTop = null;
        TreeViewScheme treeViewScheme = (TreeViewScheme)addableToTreeView2.getScheme();
        TreeViewNode treeViewNode = this.createRootTreeViewNode(addableToTreeView2, treeViewScheme);
        treeViewNode.setExpanded(true);
        treeViewNode.committ();
        this.addNode(treeViewNode);
        treeViewNode.setSelected(false);
    }

    protected TreeViewNode createRootTreeViewNode(addableToTreeView addableToTreeView2, TreeViewScheme treeViewScheme) {
        return new TreeViewNode(0, this, addableToTreeView2, treeViewScheme, true, this.lCommittTime);
    }

    public Image getPlusImage() {
        return this.iPlus;
    }

    public Image getMinusImage() {
        return this.iMinus;
    }

    public int getInset() {
        return this.iInset;
    }

    public int numNodes() {
        return this.iNumNodes;
    }

    public void toggleTreeViewNode(TreeViewNode treeViewNode) {
        if (treeViewNode == null) {
            return;
        }
        if (!treeViewNode.hasChild()) {
            return;
        }
        if (!treeViewNode.getExpanded()) {
            this.addTreeToDisplayList(treeViewNode, this.createChildTreeNode(treeViewNode, this.lCommittTime));
            this.atutvcParent.numNodesChanged(this.iNumNodes);
            treeViewNode.setExpanded(true);
        } else {
            this.subTreeFromDisplayList(treeViewNode);
            this.atutvcParent.numNodesChanged(this.iNumNodes);
            treeViewNode.setExpanded(false);
        }
        this.bResetNodeLocation = true;
        this.saveOldNodes();
        this.repaint();
    }

    protected void subTreeFromDisplayList(TreeViewNode treeViewNode) {
        DrawableNode drawableNode = null;
        TreeViewNode treeViewNode2 = null;
        TreeViewNode treeViewNode3 = null;
        int n = 0;
        int n2 = 0;
        if (treeViewNode == null) {
            return;
        }
        n = treeViewNode.getDepth();
        treeViewNode3 = treeViewNode2 = (TreeViewNode)treeViewNode.getNext();
        while (treeViewNode2 != null) {
            --this.iNumNodes;
            n2 = treeViewNode2.getDepth();
            if (n2 <= n) {
                drawableNode = treeViewNode2;
                ++this.iNumNodes;
                break;
            }
            treeViewNode2 = (TreeViewNode)treeViewNode2.getNext();
        }
        if (treeViewNode3 != null && treeViewNode3 != treeViewNode2) {
            TreeViewNode treeViewNode4;
            if (drawableNode != null && (treeViewNode4 = (TreeViewNode)drawableNode.getPrev()) != null) {
                treeViewNode4.setNext(null);
            }
            this.removeTreeLinks(treeViewNode3);
        }
        treeViewNode.setNext(drawableNode);
        if (drawableNode != null) {
            drawableNode.setPrev(treeViewNode);
        }
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void setSize(int n, int n2) {
        this.bResetNodeLocation = true;
        this.saveOldNodes();
        super.setSize(n, n2);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.bResetNodeLocation = true;
        this.saveOldNodes();
        super.setBounds(n, n2, n3, n4);
    }

    protected void removeTreeLinks(TreeViewNode treeViewNode) {
        while (treeViewNode != null) {
            treeViewNode = (TreeViewNode)treeViewNode.killMe();
        }
    }

    public void moveToNodeX(int n) {
        this.tvnTemp = (TreeViewNode)this.lanCurrent;
        int n2 = 0;
        if (this.iCurrentNodePos == n) {
            return;
        }
        if (this.iCurrentNodePos > n) {
            n2 = this.iCurrentNodePos - n;
            while (n2-- > 0 && this.tvnTemp != null) {
                this.tvnTemp = (TreeViewNode)this.tvnTemp.getPrev();
                if (this.tvnTemp == null) continue;
                this.lanCurrent = this.tvnTemp;
                --this.iCurrentNodePos;
            }
        } else {
            n2 = n - this.iCurrentNodePos;
            while (n2-- > 0 && this.tvnTemp != null) {
                this.tvnTemp = (TreeViewNode)this.tvnTemp.getNext();
                if (this.tvnTemp == null) continue;
                ++this.iCurrentNodePos;
                this.lanCurrent = this.tvnTemp;
            }
        }
        this.atutvcParent.currentNodePos(this.iCurrentNodePos);
        this.bResetNodeLocation = true;
        this.saveOldNodes();
        this.repaint();
    }

    protected void saveOldNodes() {
        this.tvnOldTop = (TreeViewNode)this.lanSelected;
        this.tvnOldBottom = this.tvnBottom;
    }

    public TreeViewNode selectNextPage() {
        if ((TreeViewNode)this.lanSelected == this.tvnBottom) {
            this.moveToNextPage(true);
        } else {
            this.selectNode(this.tvnBottom);
        }
        this.repaint();
        return this.tvnBottom;
    }

    public TreeViewNode selectPrevPage() {
        if (this.lanSelected == this.lanCurrent) {
            this.moveToPrevPage(true);
        } else {
            this.selectNode((TreeViewNode)this.lanCurrent);
        }
        this.repaint();
        return (TreeViewNode)this.lanSelected;
    }

    public void empty() {
        this.removeTreeLinks((TreeViewNode)this.lanTop);
        this.resetVars();
    }

    protected void resetVars() {
        this.lanCurrent = null;
        this.tvnBottom = null;
        this.lanSelected = null;
        this.tvnPrev = null;
        this.tvnOldTop = null;
        this.tvnOldBottom = null;
        if (this.bMultiSelect) {
            if (this.vSelectedNodes != null) {
                this.unselectAllNodes();
                this.vSelectedNodes.removeAllElements();
            }
            this.vSelectedNodes = new Vector(10, 10);
        }
    }

    public void setNodeLineDrawing(boolean bl) {
        this.bDrawNodeLines = bl;
    }

    public void calibratePoint(Point point) {
    }

    public void setDropZone(TreeViewNode treeViewNode) {
        if (this.tvnDropZone != null) {
            this.tvnDropZone.setDropZone(false);
        }
        this.tvnDropZone = treeViewNode;
        if (treeViewNode != null) {
            treeViewNode.setDropZone(true);
        }
        this.repaint();
    }

    public void absoluteRepaint() {
        Graphics graphics = this.getGraphics();
        this.iOptimisedPaint = 0;
        if (graphics == null) {
            super.repaint();
            return;
        }
        this.update(graphics);
    }

    public void drawAsDraggableTarget(boolean bl) {
        try {
            this.bDrawAsDraggable = bl;
            return;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return;
        }
    }

    public void setMultiSelect(boolean bl) {
        try {
            this.bMultiSelect = bl;
            if (this.bMultiSelect) {
                this.vSelectedNodes = new Vector(10, 10);
                return;
            }
            if (this.vSelectedNodes != null) {
                this.vSelectedNodes.removeAllElements();
                this.vSelectedNodes = null;
                return;
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public Vector findSelectedTreeViewNodes() {
        if (this.vSelectedNodes.size() == 0) {
            Vector<DrawableNode> vector = new Vector<DrawableNode>(1);
            vector.addElement(this.lanSelected);
            return vector;
        }
        return this.vSelectedNodes;
    }

    protected void updateCommittTime() {
        this.lCommittTime = System.currentTimeMillis();
    }

    public void finalize() throws Throwable {
        this.empty();
        this.iPlus = null;
        this.iMinus = null;
        this.tvnBottom = null;
        this.atutvcParent = null;
        this.tvnPrev = null;
        this.tvnOldTop = null;
        this.tvnOldBottom = null;
        this.tvnDropZone = null;
        this.attvDesiredTop = null;
        this.pTemp = null;
        this.pTemp2 = null;
        this.dTemp = null;
        this.dTemp2 = null;
        this.tvnTemp = null;
        if (this.vSelectedNodes != null && this.vSelectedNodes.size() > 0) {
            this.vSelectedNodes.removeAllElements();
        }
        this.vSelectedNodes = null;
        super.finalize();
    }

    public void setFocus(boolean bl) {
        this.bFocus = bl;
    }

    public boolean hasFocus() {
        return this.bFocus;
    }

    public void focusLost() {
        ((TreeViewNode)this.lanSelected).setFocus(false);
        this.setFocus(false);
        this.repaint();
    }
}

