/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.treeView;

import com.ibm.eNetwork.onDemand.common.TraceLevels;
import com.ibm.eNetwork.onDemand.common.gui.common.Controler;
import com.ibm.eNetwork.onDemand.common.gui.common.ExtendedCanvas;
import com.ibm.eNetwork.onDemand.common.gui.jvcScrollbar.JVCScrollbar;
import com.ibm.eNetwork.onDemand.common.gui.treeView.DragManager;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeView;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewCanvas;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewEvent;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewEventListener;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewNode;
import com.ibm.eNetwork.onDemand.common.gui.treeView.ableToUseDragManager;
import com.ibm.eNetwork.onDemand.common.gui.treeView.addableToTreeView;
import com.ibm.eNetwork.onDemand.common.gui.treeView.treeViewDragManager;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;

public class TreeViewControler
extends Controler
implements MouseListener,
KeyListener,
FocusListener,
AdjustmentListener,
ableToUseDragManager,
MouseMotionListener,
TraceLevels {
    protected TreeViewCanvas tvc;
    protected JVCScrollbar sbHorz;
    protected JVCScrollbar sbVert;
    protected TreeView tv;
    protected boolean bRightMouseButtonClicked = false;
    protected int iKeyCounter;
    protected boolean bMultiSelect = false;
    protected DragManager dm;
    protected treeViewDragManager dragManager;
    protected boolean bMouseDragging = false;
    protected Cursor cOld;
    protected static Cursor cHand = Cursor.getPredefinedCursor(12);

    public TreeViewControler(TreeView treeView) {
        this.tv = treeView;
        this.dm = DragManager.getDragManager();
    }

    public void register(ExtendedCanvas extendedCanvas) {
        try {
            TreeViewCanvas treeViewCanvas = (TreeViewCanvas)extendedCanvas;
            this.tv.addFocusListener(this);
            treeViewCanvas.addMouseListener(this);
            treeViewCanvas.addKeyListener(this);
            treeViewCanvas.addFocusListener(this);
            treeViewCanvas.addMouseMotionListener(this);
            this.tvc = treeViewCanvas;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void unregister(ExtendedCanvas extendedCanvas) {
        try {
            TreeViewCanvas treeViewCanvas = (TreeViewCanvas)extendedCanvas;
            treeViewCanvas.removeMouseListener(this);
            treeViewCanvas.removeKeyListener(this);
            treeViewCanvas.removeFocusListener(this);
            treeViewCanvas.removeMouseMotionListener(this);
            this.tvc = null;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void registerScrollbars(JVCScrollbar jVCScrollbar, JVCScrollbar jVCScrollbar2) {
        try {
            jVCScrollbar.addAdjustmentListener(this);
            jVCScrollbar2.addAdjustmentListener(this);
            this.sbHorz = jVCScrollbar;
            this.sbVert = jVCScrollbar2;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void unregisterScrollbars(JVCScrollbar jVCScrollbar, JVCScrollbar jVCScrollbar2) {
        try {
            jVCScrollbar.removeAdjustmentListener(this);
            jVCScrollbar2.removeAdjustmentListener(this);
            this.sbHorz = null;
            this.sbVert = null;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        try {
            TreeViewNode treeViewNode = (TreeViewNode)this.tvc.findCurrent();
            int n = keyEvent.getKeyCode();
            boolean bl = true;
            switch (n) {
                case 10: {
                    this.createEvent(231, treeViewNode);
                    return;
                }
                case 39: {
                    bl = this.preToggleEvent(treeViewNode);
                    if (bl) {
                        this.tvc.toggleTreeViewNode(treeViewNode);
                        this.postToggleEvent(treeViewNode);
                        return;
                    }
                    break;
                }
                case 37: {
                    bl = this.preToggleEvent(treeViewNode);
                    if (bl) {
                        this.tvc.toggleTreeViewNode(treeViewNode);
                        bl = this.postToggleEvent(treeViewNode);
                        return;
                    }
                    break;
                }
                case 40: {
                    ++this.iKeyCounter;
                    bl = this.createEvent(232, (TreeViewNode)treeViewNode.getNext());
                    if (bl) {
                        this.tvc.selectNextNode();
                        this.createEvent(228, (TreeViewNode)treeViewNode.getNext());
                        return;
                    }
                    break;
                }
                case 38: {
                    ++this.iKeyCounter;
                    bl = this.createEvent(232, (TreeViewNode)treeViewNode.getPrev());
                    if (bl) {
                        this.tvc.selectPrevNode();
                        this.createEvent(228, (TreeViewNode)treeViewNode.getPrev());
                        return;
                    }
                    break;
                }
                case 33: {
                    treeViewNode = this.tvc.selectPrevPage();
                    this.createEvent(228, treeViewNode);
                    return;
                }
                case 34: {
                    treeViewNode = this.tvc.selectNextPage();
                    this.createEvent(228, treeViewNode);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {}
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.iKeyCounter > 2) {
            this.tvc.absoluteRepaint();
        }
        this.iKeyCounter = 0;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        try {
            this.bRightMouseButtonClicked = this.rightMouseClick(mouseEvent);
            this.tvc.requestFocus();
            Point point = mouseEvent.getPoint();
            this.tvc.calibratePoint(point);
            TreeViewNode treeViewNode = (TreeViewNode)this.tvc.findOnMouseUp(point.x, point.y);
            boolean bl = true;
            if (treeViewNode == null && this.bRightMouseButtonClicked) {
                PopupMenu popupMenu = this.tv.getPopupMenu();
                Point point2 = mouseEvent.getPoint();
                if (popupMenu == null) {
                    return;
                }
                this.tv.add(popupMenu);
                popupMenu.show(this.tv, point2.x, point2.y);
                return;
            }
            if (treeViewNode == null) {
                return;
            }
            if (treeViewNode.hitPlus(point.x)) {
                bl = this.preToggleEvent(treeViewNode);
                if (bl) {
                    this.tvc.toggleTreeViewNode(treeViewNode);
                    this.postToggleEvent(treeViewNode);
                    return;
                }
            } else {
                if (mouseEvent.getClickCount() > 1 && !this.bRightMouseButtonClicked) {
                    this.createEvent(231, treeViewNode);
                    return;
                }
                if (this.bMultiSelect && !treeViewNode.getSelected() && this.ctrlKeyPressed(mouseEvent)) {
                    bl = this.createEvent(232, treeViewNode);
                    if (bl) {
                        this.tvc.multiSelectNode(treeViewNode);
                        this.tvc.repaint();
                        this.createEvent(228, treeViewNode);
                        return;
                    }
                } else if (!this.bMultiSelect || treeViewNode.getSelected() || !this.shiftKeyPressed(mouseEvent)) {
                    if (!treeViewNode.getSelected()) {
                        bl = this.createEvent(232, treeViewNode);
                        if (bl) {
                            this.tvc.selectNode(treeViewNode);
                            this.tvc.repaint();
                            this.createEvent(228, treeViewNode);
                            return;
                        }
                    } else {
                        if (!this.bRightMouseButtonClicked && treeViewNode.getSelected() && this.ctrlKeyPressed(mouseEvent)) {
                            this.tvc.unselectNode(treeViewNode);
                            this.tvc.repaint();
                            return;
                        }
                        if (treeViewNode.getPopupMenu() != null && this.bRightMouseButtonClicked && !this.multipleNodesSelected()) {
                            PopupMenu popupMenu = treeViewNode.getPopupMenu();
                            Point point3 = mouseEvent.getPoint();
                            this.tv.add(popupMenu);
                            popupMenu.show(this.tv, point3.x, point3.y);
                            return;
                        }
                        if (this.tv.getMultiPopupMenu() != null && this.bRightMouseButtonClicked && this.multipleNodesSelected()) {
                            PopupMenu popupMenu = this.tv.getMultiPopupMenu();
                            Point point4 = mouseEvent.getPoint();
                            this.tv.add(popupMenu);
                            popupMenu.show(this.tv, point4.x, point4.y);
                        }
                    }
                }
            }
            return;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return;
        }
    }

    protected boolean multipleNodesSelected() {
        try {
            Vector vector = this.tvc.findSelectedTreeViewNodes();
            if (vector == null) {
                return false;
            }
            return vector.size() >= 2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean ctrlKeyPressed(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getModifiers();
            return (n & 2) == 2;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
    }

    protected boolean shiftKeyPressed(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getModifiers();
            return (n & 1) == 1;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
    }

    protected boolean rightMouseClick(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getModifiers();
            return n == 4;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        try {
            if (this.bAutoFocus) {
                this.tvc.requestFocus();
                return;
            }
        }
        catch (Exception exception) {}
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.bMouseDragging) {
            this.bMouseDragging = false;
            this.tvc.setCursor(this.cOld);
            this.tvc.invalidate();
            Point point = mouseEvent.getPoint();
            this.dm.stopDrag(this.tvc, point);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        try {
            Object object = focusEvent.getSource();
            if (object instanceof TreeViewCanvas) {
                TreeViewNode treeViewNode = (TreeViewNode)this.tvc.findOnGotFocus();
                treeViewNode.setFocus(true);
                this.tvc.setFocus(true);
                this.tvc.repaint();
                return;
            }
            this.tvc.requestFocus();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        try {
            Object object = focusEvent.getSource();
            if (object instanceof TreeViewCanvas) {
                TreeViewNode treeViewNode = (TreeViewNode)this.tvc.findOnGotFocus();
                treeViewNode.setFocus(false);
                this.tvc.setFocus(false);
                this.tvc.repaint();
                return;
            }
        }
        catch (Exception exception) {}
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        try {
            JVCScrollbar jVCScrollbar = (JVCScrollbar)adjustmentEvent.getAdjustable();
            if (jVCScrollbar == this.sbHorz) {
                this.horzScrollEvent(adjustmentEvent);
                return;
            }
            if (jVCScrollbar == this.sbVert) {
                this.vertScrollEvent(adjustmentEvent);
                return;
            }
        }
        catch (Exception exception) {}
    }

    protected boolean isMyEvent(AWTEvent aWTEvent) {
        try {
            if (aWTEvent instanceof TreeViewEvent) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    protected boolean sendEvent(AWTEvent aWTEvent) {
        try {
            Enumeration enumeration = this.hListeners.elements();
            TreeViewEvent treeViewEvent = (TreeViewEvent)aWTEvent;
            if (enumeration.hasMoreElements()) {
                TreeViewEventListener treeViewEventListener = (TreeViewEventListener)enumeration.nextElement();
                return treeViewEvent.sendEvent(treeViewEventListener);
            }
        }
        catch (Exception exception) {}
        return true;
    }

    protected void vertScrollEvent(AdjustmentEvent adjustmentEvent) {
        try {
            int n = adjustmentEvent.getAdjustmentType();
            switch (n) {
                case 1: {
                    this.tvc.requestFocus();
                    this.tvc.moveToNextNode();
                    return;
                }
                case 4: {
                    this.tvc.requestFocus();
                    this.tvc.moveToNextPage(true);
                    return;
                }
                case 2: {
                    this.tvc.requestFocus();
                    this.tvc.moveToPrevNode();
                    return;
                }
                case 3: {
                    this.tvc.requestFocus();
                    this.tvc.moveToPrevPage(true);
                    return;
                }
                case 5: {
                    this.tvc.requestFocus();
                    this.tvc.moveToNodeX(adjustmentEvent.getValue());
                    return;
                }
            }
            this.tvc.requestFocus();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void horzScrollEvent(AdjustmentEvent adjustmentEvent) {
        try {
            if (adjustmentEvent.getAdjustmentType() != 5) {
                this.tvc.setHorzOffset(adjustmentEvent.getValue());
            }
            this.tvc.requestFocus();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected boolean preToggleEvent(TreeViewNode treeViewNode) {
        try {
            if (!treeViewNode.hasChild()) {
                return false;
            }
            if (treeViewNode.getExpanded()) {
                return this.createEvent(234, treeViewNode);
            }
            return this.createEvent(233, treeViewNode);
        }
        catch (Exception exception) {
            return true;
        }
    }

    protected boolean postToggleEvent(TreeViewNode treeViewNode) {
        try {
            if (treeViewNode.getExpanded()) {
                return this.createEvent(229, treeViewNode);
            }
            return this.createEvent(230, treeViewNode);
        }
        catch (Exception exception) {
            return true;
        }
    }

    protected boolean createEvent(int n, TreeViewNode treeViewNode) {
        try {
            TreeViewEvent treeViewEvent = new TreeViewEvent(this.tv, treeViewNode, n);
            return this.postEvent(treeViewEvent);
        }
        catch (Exception exception) {
            return true;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.dragManager == null) {
            return;
        }
        if (!this.bMouseDragging) {
            this.bMouseDragging = true;
            TreeViewNode treeViewNode = (TreeViewNode)this.tvc.findCurrent();
            if (treeViewNode == null) {
                return;
            }
            Point point = mouseEvent.getPoint();
            Point point2 = treeViewNode.getLocation();
            int n = treeViewNode.getSize().height;
            if (point.y < point2.y + n && point.y > point2.y) {
                this.bMouseDragging = false;
                return;
            }
            this.cOld = this.tvc.getCursor();
            this.tvc.setCursor(cHand);
            this.tvc.invalidate();
            addableToTreeView addableToTreeView2 = treeViewNode.getData();
            this.dragManager.elementDragStarted(this.tv, treeViewNode.getData());
            this.dm.startDrag(this.tvc, addableToTreeView2);
        }
        this.dm.drag(this.tvc, mouseEvent.getPoint());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void setMultiSelect(boolean bl) {
        this.bMultiSelect = bl;
    }

    public void setDragManager(treeViewDragManager treeViewDragManager2) {
        this.dragManager = treeViewDragManager2;
        if (treeViewDragManager2 != null) {
            this.dm.registerView(this.tvc, this);
            return;
        }
        this.dm.unregisterView(this.tvc, this);
    }

    public void drawGhostAt(Point point) {
        TreeViewNode treeViewNode = (TreeViewNode)this.tvc.findOnMouseUp(point.x, point.y);
        this.tvc.setDropZone(treeViewNode);
    }

    public boolean droppedAt(Point point, addableToTreeView addableToTreeView2) {
        this.tvc.setDropZone(null);
        TreeViewNode treeViewNode = (TreeViewNode)this.tvc.findOnMouseUp(point.x, point.y);
        if (treeViewNode == null) {
            this.dragManager.elementDropped(this.tv, null);
        } else {
            this.dragManager.elementDropped(this.tv, treeViewNode.getData());
        }
        return true;
    }

    public void dropAccomplished(boolean bl, addableToTreeView addableToTreeView2) {
        this.dragManager.elementDragStoped(this.tv, addableToTreeView2, bl);
    }

    public void dispose() {
        this.tvc = null;
        this.sbHorz = null;
        this.sbVert = null;
        this.tv = null;
        this.dragManager = null;
        this.dm = null;
    }
}

