/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.treeView;

import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.LeftAlignedNode;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewNodeState;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewScheme;
import com.ibm.eNetwork.onDemand.common.gui.treeView.ableToUseTreeViewNode;
import com.ibm.eNetwork.onDemand.common.gui.treeView.addableToTreeView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.BitSet;

public class TreeViewNode
extends LeftAlignedNode {
    protected int iDepth = -1;
    protected boolean bLeafNode = false;
    protected boolean bDrawDropZone = false;
    protected ableToUseTreeViewNode atutvnParent;
    public static final int NORMAL_ICON = 0;
    public static final int SELECTED_ICON = 1;
    protected addableToTreeView attvNode;
    protected boolean bDrawLines = true;
    int iIndex;
    protected boolean bHasChild = false;
    protected boolean bChildSet = false;
    protected BitSet bitset;

    public TreeViewNode(int n, ableToUseTreeViewNode ableToUseTreeViewNode2, addableToTreeView addableToTreeView2, TreeViewScheme treeViewScheme, boolean bl, long l) {
        super(addableToTreeView2.getText().getText(n), treeViewScheme.getColors(n), treeViewScheme.getFonts(n), treeViewScheme.getImages(n));
        this.atutvnParent = ableToUseTreeViewNode2;
        this.attvNode = addableToTreeView2;
        this.iIndex = n;
        if (addableToTreeView2.getState() == null) {
            TreeViewNodeState treeViewNodeState = this.createTreeViewNodeState(l);
            addableToTreeView2.setState(treeViewNodeState);
        }
        this.bDrawLines = bl;
    }

    protected TreeViewNodeState createTreeViewNodeState(long l) {
        TreeViewNodeState treeViewNodeState = new TreeViewNodeState();
        treeViewNodeState.tvn = this;
        treeViewNodeState.lCommittTime = l;
        return treeViewNodeState;
    }

    public addableToTreeView getData() {
        return this.attvNode;
    }

    public void setLineDrawing(boolean bl) {
        this.bDrawLines = bl;
    }

    public void setLeafNode(boolean bl) {
        this.bLeafNode = bl;
    }

    public boolean getLeafNode() {
        return this.bLeafNode;
    }

    public void setDepth(int n) {
        this.iDepth = n;
    }

    public int getDepth() {
        return this.iDepth;
    }

    public boolean hasChild() {
        if (!this.bChildSet) {
            this.bChildSet = true;
            this.bHasChild = this.attvNode.getChildNode() != null;
        }
        return this.bHasChild;
    }

    public void resetNode() {
        this.bChildSet = false;
        this.bitset = null;
        this.bLeafNode = false;
    }

    public void setSelected(boolean bl) {
        try {
            super.setSelected(bl);
            TreeViewNodeState treeViewNodeState = (TreeViewNodeState)this.attvNode.getState();
            treeViewNodeState.bSelected = bl;
            this.setFocus(bl);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public boolean getSelected() {
        try {
            TreeViewNodeState treeViewNodeState = (TreeViewNodeState)this.attvNode.getState();
            return treeViewNodeState.bSelected;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void setDropZone(boolean bl) {
        this.bDrawDropZone = bl;
    }

    public void draw(Graphics graphics, Rectangle rectangle) {
        Image image = this.ifcImage.getImage(0);
        Image image2 = this.ifcImage.getImage(1);
        boolean bl = this.hasChild();
        TreeViewScheme treeViewScheme = (TreeViewScheme)this.attvNode.getScheme();
        ImagesForCanvas imagesForCanvas = treeViewScheme.getFolders();
        if (bl) {
            this.ifcImage.addImage(imagesForCanvas.getImage(1), 1);
            this.ifcImage.addImage(imagesForCanvas.getImage(0), 0);
        }
        if (this.getSelected()) {
            this.drawHighlight(graphics, rectangle, bl);
        }
        if (this.bDrawDropZone) {
            this.drawDropZone(graphics, rectangle, bl);
        }
        if (this.bDrawLines) {
            this.drawLines(graphics, rectangle);
        }
        if (bl) {
            this.drawPlus(graphics, rectangle);
        }
        super.draw(graphics, rectangle);
        if (bl) {
            if (image != null) {
                this.ifcImage.addImage(image, 0);
            } else {
                this.ifcImage.removeImage(0);
            }
            if (image2 != null) {
                this.ifcImage.addImage(image2, 1);
                return;
            }
            this.ifcImage.removeImage(1);
        }
    }

    public String toString() {
        try {
            String string = this.attvNode.getText().getText(this.iIndex);
            return string;
        }
        catch (Exception exception) {
            return "toString() failed";
        }
    }

    protected void drawPlus(Graphics graphics, Rectangle rectangle) {
        Image image = null;
        int n = 0;
        image = this.getExpanded() ? this.atutvnParent.getMinusImage() : this.atutvnParent.getPlusImage();
        n = (this.getHeight() - this.ifcImage.getImageHeight(image)) / 2;
        if (image != null) {
            graphics.drawImage(image, rectangle.x - this.ifcImage.getImageWidth(image) + this.atutvnParent.getInset() / 2, rectangle.y + n, null);
        }
    }

    public void drawHighlight(Graphics graphics, Rectangle rectangle, boolean bl) {
        int n = this.getHeight();
        int n2 = this.getWidth();
        int n3 = this.iHorzSpace;
        if (bl) {
            n3 += this.ifcImage.getImageWidth(0);
        }
        graphics.setColor(this.cfcColor.getColor(2));
        graphics.fillRect(rectangle.x + n3, rectangle.y, n2 - n3 - this.iHorzSpace - 1, n - 1);
        if (this.hasFocus()) {
            graphics.setColor(Color.black);
            graphics.drawRect(rectangle.x + n3, rectangle.y, n2 - n3 - this.iHorzSpace - 1, n - 1);
        }
    }

    public void drawDropZone(Graphics graphics, Rectangle rectangle, boolean bl) {
        int n = this.getHeight();
        int n2 = this.getWidth();
        int n3 = this.iHorzSpace;
        if (bl) {
            n3 += this.ifcImage.getImageWidth(0);
        }
        graphics.setColor(Color.green);
        graphics.fillRect(rectangle.x + n3, rectangle.y, n2 - n3 - this.iHorzSpace - 1, n - 1);
    }

    public TreeViewNode createNextTreeNode(long l) {
        addableToTreeView addableToTreeView2 = this.attvNode.getNextNode();
        return this.createNewNode(addableToTreeView2, l);
    }

    public TreeViewNode createBastardTreeNode(addableToTreeView addableToTreeView2, long l) {
        return this.createNewNode(addableToTreeView2, 0L);
    }

    public TreeViewNode createChildTreeNode(long l) {
        addableToTreeView addableToTreeView2 = this.attvNode.getChildNode();
        return this.createNewNode(addableToTreeView2, l);
    }

    protected TreeViewNode createNewNode(addableToTreeView addableToTreeView2, long l) {
        if (addableToTreeView2 == null) {
            return null;
        }
        TreeViewNode treeViewNode = null;
        TreeViewNodeState treeViewNodeState = (TreeViewNodeState)addableToTreeView2.getState();
        if (treeViewNodeState != null) {
            treeViewNode = treeViewNodeState.tvn;
        }
        if (treeViewNode == null) {
            TreeViewScheme treeViewScheme = (TreeViewScheme)addableToTreeView2.getScheme();
            TreeViewNode treeViewNode2 = new TreeViewNode(0, this.atutvnParent, addableToTreeView2, treeViewScheme, this.bDrawLines, l);
            treeViewNode2.committ();
            return treeViewNode2;
        }
        if (treeViewNodeState.lCommittTime < l) {
            treeViewNode.committ();
            treeViewNodeState.lCommittTime = l;
        }
        treeViewNode.resetNode();
        return treeViewNode;
    }

    public void setExpanded(boolean bl) {
        try {
            TreeViewNodeState treeViewNodeState = (TreeViewNodeState)this.attvNode.getState();
            treeViewNodeState.bExpanded = bl;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public boolean getExpanded() {
        try {
            TreeViewNodeState treeViewNodeState = (TreeViewNodeState)this.attvNode.getState();
            return treeViewNodeState.bExpanded;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void committ() {
        TreeViewScheme treeViewScheme = (TreeViewScheme)this.attvNode.getScheme();
        this.updateAttribs(treeViewScheme.getColors(this.iIndex), treeViewScheme.getFonts(this.iIndex), treeViewScheme.getImages(this.iIndex));
        this.sText = this.attvNode.getText().getText(this.iIndex);
        if (this.sText == null) {
            this.sText = "";
        }
        this.setPopupMenu(treeViewScheme.getPopupMenu(this.iIndex));
        super.committ();
    }

    protected void paintBackground(Graphics graphics, Rectangle rectangle) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this.bPaintBackground && !this.getSelected()) {
            n = rectangle.height;
            n2 = rectangle.width;
            n3 = this.iHorzSpace;
            graphics.setColor(this.cfcColor.getColor(0));
            graphics.fillRect(rectangle.x + n3, rectangle.y, n2 - n3 - this.iHorzSpace, n);
        }
    }

    protected void drawLines(Graphics graphics, Rectangle rectangle) {
        addableToTreeView addableToTreeView2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = this.getHeight();
        int n4 = this.atutvnParent.getInset();
        addableToTreeView2 = this.attvNode;
        graphics.setColor(this.cfcColor.getColor(1));
        this.createLineBitSet();
        n = this.iDepth;
        while (n > 0) {
            if (this.bitset.get(n)) {
                graphics.drawLine(rectangle.x - n4 * (this.iDepth - n + 1), rectangle.y, rectangle.x - n4 * (this.iDepth - n + 1), rectangle.y + n3);
            }
            --n;
        }
        if (this.iDepth != 1) {
            if (this.bLeafNode) {
                n2 = n3 / 2;
            }
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + n3 - n2);
        }
        n2 = n3 / 2;
        graphics.drawLine(rectangle.x, rectangle.y + n3 - n2, rectangle.x + this.iHorzSpace, rectangle.y + n3 - n2);
    }

    protected void createLineBitSet() {
        if (this.bitset != null) {
            return;
        }
        addableToTreeView addableToTreeView2 = this.attvNode;
        addableToTreeView addableToTreeView3 = null;
        int n = 0;
        this.bitset = new BitSet(this.iDepth);
        n = this.iDepth;
        while (n > 0) {
            if ((addableToTreeView2 = addableToTreeView2.getParentNode()) == null) break;
            addableToTreeView3 = addableToTreeView2.getNextNode();
            if (addableToTreeView3 != null) {
                this.bitset.set(n);
            }
            --n;
        }
    }

    public boolean hitPlus(int n) {
        try {
            Point point = null;
            point = this.getLocation();
            if (n < point.x + this.iHorzSpace / 2) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public addableToTreeView getAddableToTreeView() {
        return this.attvNode;
    }

    protected void calcSpaces() {
        super.calcSpaces();
        this.iVertSpace = 0;
    }

    public int getMaxWidth() {
        return this.getWidth();
    }
}

