/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.images;

import com.ibm.eNetwork.onDemand.common.images.ClientImageNames;
import com.ibm.eNetwork.onDemand.common.images.ImageLoader;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ClientImageLoader
extends ImageLoader
implements ClientImageNames {
    public static final boolean DEBUG = false;
    public static final boolean ASSERT = false;
    protected static Hashtable hashGlobal = new Hashtable();

    public ClientImageLoader(Component component) {
        super(component);
    }

    public Image getImage(String string) {
        return super.getImage(this.getClass(), string);
    }

    public Image getImageFromFilename(String string) {
        return super.getImage(string);
    }

    public Vector getImages(Vector vector) {
        return super.getImages(this.getClass(), vector);
    }

    public Vector getImagesFromFilenames(Vector vector) {
        return super.getImages(vector);
    }

    protected Object get(URL uRL) {
        Image image = null;
        if (uRL != null && (image = (Image)this.hashtable.get(uRL)) == null) {
            ImageCounter imageCounter = (ImageCounter)hashGlobal.get(uRL);
            if (imageCounter == null) {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                image = toolkit.getImage(uRL);
                if (image != null) {
                    imageCounter = new ImageCounter(image);
                    hashGlobal.put(uRL, imageCounter);
                }
            } else {
                image = imageCounter.getImage();
            }
            if (image != null) {
                imageCounter.increment();
                this.hashtable.put(uRL, image);
            }
        }
        return image;
    }

    public void flushImages() {
        Enumeration enumeration = this.hashtable.keys();
        while (enumeration.hasMoreElements()) {
            URL uRL = (URL)enumeration.nextElement();
            if (uRL == null) continue;
            Image image = this.removeImage(uRL);
            ImageCounter imageCounter = (ImageCounter)hashGlobal.get(uRL);
            if (imageCounter == null || imageCounter.decrement() > 0) continue;
            hashGlobal.remove(uRL);
        }
    }

    public class ImageCounter {
        int nCount;
        Image image;

        public ImageCounter(Image image) {
            ClientImageLoader.this = ClientImageLoader.this;
            this.image = image;
        }

        public synchronized void increment() {
            ++this.nCount;
        }

        public synchronized int decrement() {
            --this.nCount;
            return this.nCount;
        }

        public int getCount() {
            return this.nCount;
        }

        public Image getImage() {
            return this.image;
        }
    }
}

