/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.images;

import com.ibm.eNetwork.onDemand.common.ResourceLoader;
import com.ibm.eNetwork.onDemand.common.TraceLevels;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import netscape.security.PrivilegeManager;

public class ImageLoader
extends ResourceLoader
implements TraceLevels {
    protected Component component;

    public ImageLoader(Component component) {
        this.component = component;
    }

    protected Object get(URL uRL) {
        Image image = null;
        if (this.hashtable.containsKey(uRL)) {
            image = (Image)this.hashtable.get(uRL);
        } else {
            try {
                PrivilegeManager.enablePrivilege("UniversalConnect");
                PolicyEngine.assertPermission(PermissionID.NETIO);
                if (uRL.getProtocol().startsWith("file")) {
                    PrivilegeManager.enablePrivilege("UniversalFileRead");
                    PolicyEngine.assertPermission(PermissionID.FILEIO);
                }
            }
            catch (Exception exception) {}
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            image = toolkit.getImage(uRL);
            this.hashtable.put(uRL, image);
            try {
                PrivilegeManager.revertPrivilege("UniversalConnect");
                PolicyEngine.revertPermission(PermissionID.NETIO);
                if (uRL.getProtocol().startsWith("file")) {
                    PrivilegeManager.revertPrivilege("UniversalFileRead");
                    PolicyEngine.revertPermission(PermissionID.FILEIO);
                }
            }
            catch (Exception exception) {}
        }
        return image;
    }

    protected Object get(InputStream inputStream) {
        Image image = null;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 512);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        byte[] byArray = new byte[512];
        int n = 0;
        int n2 = 0;
        try {
            while ((n = bufferedInputStream.read(byArray)) != -1 && n2 < 4) {
                if (n == 0) {
                    ++n2;
                }
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        image = toolkit.createImage(byteArrayOutputStream.toByteArray());
        return image;
    }

    protected boolean trackImage(Image image) {
        try {
            MediaTracker mediaTracker = new MediaTracker(this.component);
            mediaTracker.addImage(image, 1);
            mediaTracker.waitForID(1);
            return !mediaTracker.isErrorID(1);
        }
        catch (Exception exception) {
            System.err.println("ImageLoader.trackImage: " + exception);
            return false;
        }
    }

    public Image getImage(String string) {
        return this.getImage(null, string);
    }

    public Image getImage(Class clazz, String string) {
        Image image = null;
        if (this.hashtable.containsKey(clazz + string)) {
            image = (Image)this.hashtable.get(clazz + string);
        } else {
            image = this.createImage(this.getResourceStream(clazz, string));
            if (image != null) {
                this.hashtable.put(clazz + string, image);
            }
        }
        return image;
    }

    public Vector getImages(Vector vector) {
        return this.getImages(null, vector);
    }

    public Vector getImages(Class clazz, Vector vector) {
        Object object;
        Vector<Object> vector2 = new Vector<Object>();
        if (vector.isEmpty()) {
            return null;
        }
        String string = "";
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (this.hashtable.containsKey(clazz + string)) {
                vector2.addElement((Image)this.hashtable.get(clazz + string));
                continue;
            }
            object = this.createImage(this.getResourceStream(clazz, string));
            if (object != null) {
                this.hashtable.put(clazz + string, object);
            }
            vector2.addElement(object);
        }
        object = new MediaTracker(this.component);
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            ((MediaTracker)object).addImage((Image)enumeration.nextElement(), 1);
        }
        try {
            ((MediaTracker)object).waitForID(1);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("ImageLoader.loadImages(): " + interruptedException);
            return vector2;
        }
        if (((MediaTracker)object).isErrorID(1)) {
            System.err.println("There was an error loading images from the vector: " + vector);
        }
        return vector2;
    }

    public Image getImage(URL uRL) {
        Image image = (Image)this.get(uRL);
        if (!this.trackImage(image)) {
            System.err.println("ImageLoader.get: there was an error loading file from URL " + uRL);
            this.removeImage(uRL);
            return null;
        }
        return image;
    }

    public Image createImage(InputStream inputStream) {
        Image image = null;
        boolean bl = true;
        if (inputStream != null) {
            image = (Image)this.get(inputStream);
            boolean bl2 = bl = !this.trackImage(image);
        }
        if (bl) {
            System.err.println("ImageLoader.get: there was an error loading file from input stream " + inputStream);
            return null;
        }
        return image;
    }

    public Image removeImage(String string) {
        return this.removeImage(null, string);
    }

    public Image removeImage(Class clazz, String string) {
        return (Image)this.removeFromBuffer(clazz + string);
    }

    public Image removeImage(URL uRL) {
        return (Image)this.removeFromBuffer(uRL);
    }
}

