/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.images;

import com.ibm.eNetwork.onDemand.common.images.ImageLoader;
import com.ibm.eNetwork.onDemand.common.images.eNoDImageNames;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.security.PrivilegeManager;

public class eNoDImageLoader
extends ImageLoader
implements eNoDImageNames {
    public static final boolean DEBUG = false;
    public static final boolean ASSERT = false;
    protected static Hashtable hashGlobal = new Hashtable();

    public eNoDImageLoader(Component component) {
        super(component);
    }

    public Image getImage(String string) {
        Image image = null;
        ImageCounter imageCounter = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.ibm.eNetwork.onDemand.common.images.eNoDImageLoader");
        }
        catch (Exception exception) {
            System.err.println("Error: eNoDImageLoader: getImage()");
        }
        if (hashGlobal.containsKey(clazz + string)) {
            imageCounter = (ImageCounter)hashGlobal.get(clazz + string);
            imageCounter.increment();
            image = imageCounter.getImage();
        } else {
            image = super.getImage(clazz, string);
            if (image != null) {
                imageCounter = new ImageCounter(image);
                imageCounter.increment();
                hashGlobal.put(clazz + string, imageCounter);
            }
        }
        return image;
    }

    public Image getImageFromFilename(String string) {
        Image image = null;
        ImageCounter imageCounter = null;
        Class clazz = null;
        if (hashGlobal.containsKey(clazz + string)) {
            imageCounter = (ImageCounter)hashGlobal.get(clazz + string);
            imageCounter.increment();
            image = imageCounter.getImage();
        } else {
            image = super.getImage(clazz, string);
            if (image != null) {
                imageCounter = new ImageCounter(image);
                imageCounter.increment();
                hashGlobal.put(clazz + string, imageCounter);
            }
        }
        return image;
    }

    public Vector getImages(Vector vector) {
        Object object;
        Vector<Object> vector2 = new Vector<Object>();
        Class<?> clazz = this.getClass();
        ImageCounter imageCounter = null;
        if (vector.isEmpty()) {
            return null;
        }
        String string = "";
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (hashGlobal.containsKey(clazz + string)) {
                imageCounter = (ImageCounter)hashGlobal.get(clazz + string);
                imageCounter.increment();
                vector2.addElement(imageCounter.getImage());
                continue;
            }
            object = this.getImage(clazz, string);
            if (object != null) {
                imageCounter = new ImageCounter((Image)object);
                imageCounter.increment();
                hashGlobal.put(clazz + string, imageCounter);
            }
            vector2.addElement(object);
        }
        object = new MediaTracker(this.component);
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            ((MediaTracker)object).addImage((Image)enumeration.nextElement(), 1);
        }
        try {
            ((MediaTracker)object).waitForID(1);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("ImageLoader.loadImages(): " + interruptedException);
            return vector2;
        }
        if (((MediaTracker)object).isErrorID(1)) {
            System.err.println("There was an error loading images from the vector: " + vector);
        }
        return vector2;
    }

    public Vector getImagesFromFilenames(Vector vector) {
        return super.getImages(vector);
    }

    protected Object get(URL uRL) {
        Image image = null;
        if (uRL != null && (image = (Image)this.hashtable.get(uRL)) == null) {
            ImageCounter imageCounter = (ImageCounter)hashGlobal.get(uRL);
            if (imageCounter == null) {
                try {
                    PrivilegeManager.enablePrivilege("UniversalConnect");
                    PolicyEngine.assertPermission(PermissionID.NETIO);
                    if (uRL.getProtocol().startsWith("file")) {
                        PrivilegeManager.enablePrivilege("UniversalFileRead");
                        PolicyEngine.assertPermission(PermissionID.FILEIO);
                    }
                }
                catch (Exception exception) {}
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                image = toolkit.getImage(uRL);
                try {
                    PrivilegeManager.revertPrivilege("UniversalConnect");
                    PolicyEngine.revertPermission(PermissionID.NETIO);
                    if (uRL.getProtocol().startsWith("file")) {
                        PrivilegeManager.revertPrivilege("UniversalFileRead");
                        PolicyEngine.revertPermission(PermissionID.FILEIO);
                    }
                }
                catch (Exception exception) {}
                if (image != null) {
                    imageCounter = new ImageCounter(image);
                    hashGlobal.put(uRL, imageCounter);
                }
            } else {
                image = imageCounter.getImage();
            }
            if (image != null) {
                imageCounter.increment();
                this.hashtable.put(uRL, image);
            }
        }
        return image;
    }

    public void flushImages() {
        Enumeration enumeration = this.hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (k == null) continue;
            Image image = (Image)this.hashtable.remove(k);
            ImageCounter imageCounter = (ImageCounter)hashGlobal.get(k);
            if (imageCounter == null || imageCounter.decrement() > 0) continue;
            hashGlobal.remove(k);
        }
    }

    public class ImageCounter {
        int nCount;
        Image image;

        public ImageCounter(Image image) {
            eNoDImageLoader.this = eNoDImageLoader.this;
            this.image = image;
        }

        public synchronized void increment() {
            ++this.nCount;
        }

        public synchronized int decrement() {
            --this.nCount;
            return this.nCount;
        }

        public int getCount() {
            return this.nCount;
        }

        public Image getImage() {
            return this.image;
        }
    }
}

