/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.nativecode;

import com.ibm.eNetwork.onDemand.common.nativecode.NTRegistryConstants;
import com.ibm.eNetwork.onDemand.common.nativecode.Registry;
import com.ibm.eNetwork.onDemand.common.nativecode.RegistryValue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import netscape.security.PrivilegeManager;

public class NTRegistry
implements NTRegistryConstants,
Registry {
    static final String cStmt1 = null;
    int current_hive = 1;

    public NTRegistry() {
    }

    public NTRegistry(int n) {
        this.current_hive = n;
    }

    native Vector getRegistryValue(RegistryValue var1);

    native void putRegistryValue(RegistryValue var1);

    native void deleteRegistry(RegistryValue var1);

    public int getCurrentHive() {
        return this.current_hive;
    }

    public void setCurrentHive(int n) {
        this.current_hive = n;
    }

    public Vector getValue(RegistryValue registryValue) {
        if (registryValue == null) {
            return null;
        }
        if (registryValue.Type == 5) {
            return this.getFile(registryValue);
        }
        return this.getRegistryValue(registryValue);
    }

    public void putValue(RegistryValue registryValue) {
        if (registryValue == null) {
            return;
        }
        if (registryValue.Type == 5) {
            this.putFile(registryValue);
            return;
        }
        this.putRegistryValue(registryValue);
    }

    public void delete(RegistryValue registryValue) {
        if (registryValue == null) {
            return;
        }
        if (registryValue.Type != 5) {
            this.deleteRegistry(registryValue);
        }
    }

    public void putValues(Vector vector) {
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            RegistryValue registryValue = (RegistryValue)enumeration.nextElement();
            if (registryValue == null || registryValue.Key == null || registryValue.Name == null) continue;
            if (registryValue.Type == 5) {
                this.putFile(registryValue);
                continue;
            }
            this.putValue(registryValue);
        }
    }

    public RegistryValue getOneValue(RegistryValue registryValue) {
        Vector vector;
        if (registryValue == null) {
            return null;
        }
        if (registryValue.Name == null) {
            registryValue.Name = "";
        }
        if ((vector = this.getValue(registryValue)) != null && vector.size() > 0) {
            return (RegistryValue)vector.firstElement();
        }
        return null;
    }

    public void putFile(RegistryValue registryValue) {
        if (registryValue == null) {
            return;
        }
        if (registryValue.Type != 5) {
            this.putValue(registryValue);
            return;
        }
        if (registryValue.Name != null) {
            FileOutputStream fileOutputStream;
            try {
                fileOutputStream = new FileOutputStream(registryValue.Name);
            }
            catch (IOException iOException) {
                this.Logit("Error opening file " + registryValue.Name + " for output");
                return;
            }
            if (fileOutputStream != null) {
                try {
                    DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
                    dataOutputStream.writeBytes((String)registryValue.Value);
                    fileOutputStream.close();
                    return;
                }
                catch (IOException iOException) {
                    this.Logit("Error writing file " + registryValue.Name);
                    return;
                }
            }
        }
    }

    public Vector getFile(RegistryValue registryValue) {
        FileInputStream fileInputStream;
        Vector vector = new Vector();
        if (registryValue == null) {
            return vector;
        }
        if (registryValue.Type != 5) {
            return this.getValue(registryValue);
        }
        try {
            fileInputStream = new FileInputStream(registryValue.Name);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File not found " + registryValue.Name);
            return vector;
        }
        if (fileInputStream != null) {
            StringBuffer stringBuffer;
            try {
                DataInputStream dataInputStream = new DataInputStream(fileInputStream);
                stringBuffer = new StringBuffer();
                while (dataInputStream.available() > 0) {
                    stringBuffer.append(dataInputStream.readLine());
                    stringBuffer.append("\n");
                }
            }
            catch (IOException iOException) {
                return null;
            }
            registryValue.Value = stringBuffer.toString();
            Vector<RegistryValue> vector2 = new Vector<RegistryValue>();
            vector2.addElement(registryValue);
            return vector2;
        }
        return vector;
    }

    private void Logit(String string) {
        System.out.println(string);
    }

    static {
        try {
            PrivilegeManager.enablePrivilege("UniversalLinkAccess");
        }
        catch (Exception exception) {}
        System.loadLibrary("JavaNTRegistry");
    }
}

