/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.nls;

import com.ibm.eNetwork.onDemand.common.TraceLevels;
import com.ibm.eNetwork.onDemand.common.nls.MessageTableInterface;
import java.util.Hashtable;
import java.util.Locale;

public class MessageTable
implements TraceLevels {
    private static final String s = null;
    private static Hashtable msgTable = null;
    private static String sMessagePackage = null;
    protected static String country = "us";
    protected static String variant = "";
    protected static String language = "en";
    protected static String localeString = "en_us";
    protected static Hashtable langToCountry = null;

    protected static void determineLocalString() {
        try {
            if (country.length() == 3) {
                country = country.substring(0, 2);
            }
            if (language.equals("zh")) {
                language = country.equals("TW") || country.equals("tw") ? "tw" : "cn";
            }
            if (country.equals("TU") || country.equals("tu")) {
                language = "tr";
                country = "TR";
            }
            if ((country.equals("ES") || country.equals("es")) && language.equals("en")) {
                language = "es";
            }
            localeString = String.valueOf(language) + "_" + country;
            return;
        }
        catch (Exception exception) {
            language = "en";
            country = "US";
            localeString = "en_US";
            return;
        }
    }

    public static void overrideLanguage(String string) {
        if (string != null && !string.equals("")) {
            String string2 = (String)langToCountry.get(language);
            if (string2 == null) {
                return;
            }
            language = string;
            country = string2;
            variant = "";
            MessageTable.determineLocalString();
        }
    }

    public MessageTable() {
        if (msgTable == null) {
            msgTable = new Hashtable();
        }
    }

    public static String getCountry() {
        return country;
    }

    public static String getLanguage() {
        return language;
    }

    public static String getVariant() {
        return variant;
    }

    public static String getLocaleString() {
        return localeString;
    }

    public Hashtable loadMessages(String string, Class clazz) {
        Hashtable hashtable = (Hashtable)msgTable.get(string);
        if (hashtable != null) {
            return hashtable;
        }
        sMessagePackage = clazz.getName();
        int n = sMessagePackage.lastIndexOf(".");
        sMessagePackage = sMessagePackage.substring(0, n);
        String string2 = String.valueOf(sMessagePackage) + "." + string + "_" + localeString;
        try {
            hashtable = this.loadCatalog(string2);
        }
        catch (Exception exception) {
            try {
                string2 = String.valueOf(sMessagePackage) + "." + string + "_" + language;
                hashtable = this.loadCatalog(string2);
            }
            catch (Exception exception2) {
                try {
                    System.err.println("Could not load message catalog " + string + "_" + language + "...");
                    string2 = String.valueOf(sMessagePackage) + "." + string + "_en_US";
                    hashtable = this.loadCatalog(string2);
                }
                catch (Exception exception3) {
                    try {
                        System.err.println("Loading default English catalog: " + string + "_en" + "...");
                        string2 = String.valueOf(sMessagePackage) + "." + string + "_en";
                        hashtable = this.loadCatalog(string2);
                    }
                    catch (Exception exception4) {
                        System.err.println("Could not load ANY message catalog!");
                    }
                }
            }
        }
        if (hashtable != null) {
            msgTable.put(string, hashtable);
        } else {
            hashtable = new Hashtable();
        }
        return hashtable;
    }

    protected Hashtable loadCatalog(String string) throws Exception {
        Class<?> clazz = Class.forName(string);
        MessageTableInterface messageTableInterface = (MessageTableInterface)clazz.newInstance();
        Object[][] objectArray = messageTableInterface.getContents();
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            hashtable.put(objectArray[n][0], objectArray[n][1]);
            ++n;
        }
        return hashtable;
    }

    static {
        langToCountry = new Hashtable();
        langToCountry.put("en", "US");
        langToCountry.put("sv", "SE");
        langToCountry.put("da", "DK");
        langToCountry.put("no", "NO");
        langToCountry.put("fi", "FI");
        langToCountry.put("ru", "RU");
        langToCountry.put("tr", "TR");
        langToCountry.put("nl", "NL");
        langToCountry.put("ja", "JP");
        langToCountry.put("ko", "KR");
        langToCountry.put("cn", "CN");
        langToCountry.put("tw", "TW");
        langToCountry.put("es", "ES");
        langToCountry.put("it", "IT");
        langToCountry.put("de", "DE");
        langToCountry.put("fr", "FR");
        langToCountry.put("pt", "BR");
        Locale locale = Locale.getDefault();
        country = locale.getCountry();
        variant = locale.getVariant();
        language = locale.getLanguage();
        MessageTable.determineLocalString();
    }
}

