/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.remoteFile.api;

import com.ibm.eNetwork.onDemand.common.Copyright;
import java.io.File;
import java.io.Serializable;

public class FTPFilename
implements Serializable {
    static final String cStmt1 = Copyright.COPYRIGHT_97_98;
    String sFilename;
    protected String sPath;
    protected boolean bDir = false;
    public static final String separator = File.separator;
    public static final char separatorChar = separator.charAt(0);
    protected static final int HASHCODE = 1456;

    public FTPFilename(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.sPath = string;
        this.sFilename = null;
        this.setDirectory(true);
    }

    public FTPFilename(String string, String string2) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string != null) {
            this.sPath = !string.endsWith(separator) ? String.valueOf(string) + separator : string;
        }
        if (string2 != null) {
            this.sFilename = string2;
            this.setDirectory(false);
            return;
        }
        this.setDirectory(true);
    }

    public FTPFilename(FTPFilename fTPFilename, String string) {
        this(fTPFilename.getPath(), string);
    }

    public void subFromPath() {
        if (!this.isDirectory()) {
            return;
        }
        this.sPath = this.getParent();
    }

    public void addToPath(String string) {
        if (!this.isDirectory()) {
            return;
        }
        this.sPath = String.valueOf(this.sPath) + separator + string;
    }

    public void setDirectory(boolean bl) {
        this.bDir = bl;
    }

    public boolean isDirectory() {
        return this.bDir;
    }

    public String getFilename() {
        return this.sFilename;
    }

    public String getPath() {
        return this.sPath;
    }

    public String getFullName() {
        if (this.sFilename != null) {
            return String.valueOf(this.sPath) + this.sFilename;
        }
        return this.sPath;
    }

    public String getParent() {
        try {
            int n = this.sPath.lastIndexOf(separatorChar);
            if (n <= 0) {
                return null;
            }
            return this.sPath.substring(0, n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int hashCode() {
        try {
            return this.sPath.hashCode() ^ 0x5B0;
        }
        catch (Exception exception) {
            return 1456;
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof FTPFilename) {
            return this.sPath.equals(((FTPFilename)object).sPath);
        }
        return false;
    }

    public String toString() {
        String string = this.getFilename();
        if (string != null) {
            return String.valueOf(this.getPath()) + string;
        }
        return this.getPath();
    }

    public static String convertToFTP(String string, char c) {
        return FTPFilename.convertSeparators(string, c, separatorChar);
    }

    public static String convertToSpecific(String string, char c) {
        return FTPFilename.convertSeparators(string, separatorChar, c);
    }

    protected static String convertSeparators(String string, char c, char c2) {
        try {
            return string.replace(c, c2);
        }
        catch (Exception exception) {
            return string;
        }
    }
}

