/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.remoteFile.gui;

import com.ibm.eNetwork.onDemand.common.Copyright;
import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewScheme;
import com.ibm.eNetwork.onDemand.common.images.ImageLoader;
import com.ibm.eNetwork.onDemand.common.remoteFile.api.DirectoryInfo;
import com.ibm.eNetwork.onDemand.common.remoteFile.api.FTPError;
import com.ibm.eNetwork.onDemand.common.remoteFile.api.FTPException;
import com.ibm.eNetwork.onDemand.common.remoteFile.api.FTPFilename;
import com.ibm.eNetwork.onDemand.common.remoteFile.api.FileInfo;
import com.ibm.eNetwork.onDemand.common.remoteFile.api.fileTransferProtocol;
import com.ibm.eNetwork.onDemand.common.remoteFile.gui.SingleViewComponents;
import com.ibm.eNetwork.onDemand.common.remoteFile.gui.Tree;
import com.ibm.eNetwork.onDemand.common.remoteFile.gui.TreeComponent;
import com.ibm.eNetwork.onDemand.common.remoteFile.gui.TreeNode;
import com.ibm.eNetwork.onDemand.common.remoteFile.gui.ableToUseFtpApiView;
import com.ibm.eNetwork.onDemand.common.remoteFile.mgr.RemoteCDDialog;
import com.ibm.eNetwork.onDemand.common.sort.QuickSort;
import java.awt.Frame;
import java.io.DataInputStream;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class FtpApiView
extends TreeComponent
implements FTPError {
    static final String cStmt1 = Copyright.COPYRIGHT_97_98;
    protected fileTransferProtocol ftp;
    protected ableToUseFtpApiView parent;
    protected boolean bRefresh = false;
    protected SingleViewComponents svc;
    protected int iEnableNum;
    protected QuickSort quickSort;

    public FtpApiView(fileTransferProtocol fileTransferProtocol2, ableToUseFtpApiView ableToUseFtpApiView2, SingleViewComponents singleViewComponents, ColorsForCanvas colorsForCanvas, FontsForCanvas fontsForCanvas, ImageLoader imageLoader, ResourceBundle resourceBundle) {
        super(colorsForCanvas, fontsForCanvas, imageLoader, resourceBundle);
        this.ftp = fileTransferProtocol2;
        this.parent = ableToUseFtpApiView2;
        this.svc = singleViewComponents;
        this.quickSort = new QuickSort();
        this.initTree(this.getProtocolName());
    }

    public void setFtp(fileTransferProtocol fileTransferProtocol2) {
        this.ftp = fileTransferProtocol2;
    }

    public fileTransferProtocol getFtp() {
        return this.ftp;
    }

    public void setOwner(ableToUseFtpApiView ableToUseFtpApiView2) {
        this.parent = ableToUseFtpApiView2;
    }

    public ableToUseFtpApiView getOwner() {
        return this.parent;
    }

    public void quit() {
        try {
            this.ftp.quit();
            return;
        }
        catch (Exception exception) {
            this.handleException(exception);
            return;
        }
    }

    public String getProtocolName() {
        try {
            return this.ftp.getProtocolName();
        }
        catch (Exception exception) {
            this.handleException(exception);
            return null;
        }
    }

    public void login(Frame frame, DataInputStream dataInputStream) {
        try {
            FTPFilename fTPFilename = this.ftp.pwd();
            this.cd(fTPFilename);
            this.updateTreeToMatchPath(fTPFilename.toString());
            this.clearWaitCursor();
            return;
        }
        catch (Exception exception) {
            this.handleException(exception);
            return;
        }
    }

    protected DirectoryInfo queryDirectory(String string) {
        try {
            FTPFilename fTPFilename = new FTPFilename(string);
            this.cd(fTPFilename);
            DirectoryInfo directoryInfo = this.ftp.dir(fTPFilename, null);
            return directoryInfo;
        }
        catch (Exception exception) {
            this.handleException(exception);
            return null;
        }
    }

    public boolean isRootDirectory(String string) {
        try {
            FTPFilename fTPFilename = new FTPFilename(string);
            String string2 = fTPFilename.getParent();
            return string2 == null;
        }
        catch (Exception exception) {
            this.handleException(exception);
            return false;
        }
    }

    public void cd(TreeNode treeNode) {
        String string = this.createCompletePath(treeNode);
        this.cd(string);
    }

    public boolean cd(String string) {
        try {
            FTPFilename fTPFilename = new FTPFilename(string);
            return this.cd(fTPFilename);
        }
        catch (Exception exception) {
            this.handleException(exception);
            return false;
        }
    }

    protected boolean cd(FTPFilename fTPFilename) {
        try {
            this.ftp.cd(fTPFilename);
            this.signalPathUpdate();
            return true;
        }
        catch (Exception exception) {
            this.handleException(exception);
            return false;
        }
    }

    public String createCompletePath(TreeNode treeNode) {
        try {
            if (treeNode == null) {
                return null;
            }
            TreeNode treeNode2 = (TreeNode)treeNode.getParentNode();
            String string = this.createCompletePath(treeNode2);
            if (string == null) {
                string = treeNode.toString();
                if (string.compareTo(this.sProtocolName) == 0) {
                    string = null;
                }
            } else {
                string = String.valueOf(string) + FTPFilename.separator + treeNode.toString();
            }
            return string;
        }
        catch (Exception exception) {
            this.handleException(exception);
            return null;
        }
    }

    public void createTree(TreeNode treeNode, DirectoryInfo directoryInfo) {
        try {
            TreeNode treeNode2;
            Enumeration enumeration = directoryInfo.elements();
            FileInfo fileInfo = null;
            FTPFilename fTPFilename = null;
            String string = null;
            String string2 = null;
            int n = 0;
            Tree tree = treeNode.getChild();
            TreeNode treeNode3 = null;
            String string3 = null;
            String string4 = null;
            if (tree == null || this.bRefresh) {
                this.bRefresh = false;
                tree = new Tree(treeNode);
            }
            if ((treeNode2 = treeNode.findTreeNode(" ")) != null) {
                treeNode2.removeSelf();
            }
            if (!this.isRootDirectory(this.createCompletePath(treeNode))) {
                this.addLinkToParentNode(tree);
            }
            Vector vector = this.getNames(treeNode);
            while (enumeration.hasMoreElements()) {
                fileInfo = (FileInfo)enumeration.nextElement();
                try {
                    fTPFilename = fileInfo.getFilename();
                    string2 = fTPFilename.getFilename();
                    if (string2 == null) {
                        string = fTPFilename.getPath();
                        n = string.lastIndexOf(FTPFilename.separator);
                        string2 = string.substring(n + 1);
                    }
                    if (string2 == null) break;
                    if (this.checkNameExists(vector, string2)) continue;
                    string3 = fileInfo.getLastModified();
                    string4 = this.convertLongToString(fileInfo.getFileSizeBytes());
                    if (fTPFilename.isDirectory()) {
                        treeNode3 = new TreeNode(string2, this.schemeFolders);
                        this.primeDir(treeNode3);
                    } else {
                        treeNode3 = new TreeNode(string2, this.schemeFiles);
                        treeNode3.addText(1, string4);
                        treeNode3.addText(2, string3);
                    }
                    tree.addNode(treeNode3);
                    treeNode3.setFileInfo(fileInfo);
                }
                catch (Exception exception) {
                    this.handleException(exception);
                }
            }
            this.quickSort.sort(tree.getVector());
            return;
        }
        catch (Exception exception) {
            this.handleException(exception);
            return;
        }
    }

    protected Vector getNames(TreeNode treeNode) {
        try {
            if (treeNode == null) {
                return null;
            }
            Tree tree = treeNode.getChild();
            if (tree == null) {
                return null;
            }
            Vector vector = tree.getVector();
            if (vector != null) {
                return (Vector)vector.clone();
            }
            return null;
        }
        catch (Exception exception) {
            this.handleException(exception);
            return null;
        }
    }

    protected boolean checkNameExists(Vector vector, String string) {
        try {
            if (vector == null || string == null) {
                return false;
            }
            String string2 = null;
            String string3 = string.toLowerCase();
            Object var5_6 = null;
            TreeNode treeNode = null;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                var5_6 = enumeration.nextElement();
                treeNode = var5_6;
                string2 = treeNode.toString();
                if (string3.compareTo(string2.toLowerCase()) != 0) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            this.handleException(exception);
            return false;
        }
    }

    protected void addLinkToParentNode(Tree tree) {
        try {
            TreeNode treeNode = null;
            treeNode = new TreeNode(TreeComponent.RFresources.getString("PARENT_DIR"), this.schemeParent);
            tree.addNodeAtFront(treeNode);
            return;
        }
        catch (Exception exception) {
            System.err.println(exception);
            this.handleException(exception);
            return;
        }
    }

    protected String convertLongToString(long l) {
        try {
            return String.valueOf(l);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void signalPathUpdate() {
        try {
            FTPFilename fTPFilename = this.ftp.pwd();
            this.parent.updatePath(fTPFilename.toString());
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public TreeNode getCurrentParent() {
        TreeNode treeNode = (TreeNode)this.tv.findSelectedTreeViewFolder();
        return treeNode;
    }

    protected void addDirectoryToTree(TreeNode treeNode, TreeNode treeNode2, boolean bl) {
        try {
            this.primeDir(treeNode2);
            Tree tree = treeNode.getChild();
            tree.addNode(treeNode2);
            if (bl) {
                this.tv.commit(1);
                return;
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    protected void addNodeToTree(TreeNode treeNode, TreeNode treeNode2, boolean bl) {
        try {
            Tree tree = treeNode.getChild();
            tree.addNode(treeNode2);
            if (bl) {
                this.tv.commit(1);
                return;
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public void addNodeToCurrentTree(TreeNode treeNode, boolean bl, boolean bl2) {
        try {
            TreeNode treeNode2 = (TreeNode)this.tv.findSelectedTreeViewFolder();
            TreeNode treeNode3 = treeNode2.findTreeNode(treeNode.toString());
            if (treeNode3 != null && !bl) {
                return;
            }
            if (treeNode3 != null) {
                treeNode3.removeSelf();
            }
            Tree tree = treeNode2.getChild();
            tree.addNode(treeNode);
            if (bl2) {
                this.tv.commit(1);
                return;
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public void setNodeTransferingState(TreeNode treeNode, boolean bl, boolean bl2) {
        try {
            TreeViewScheme treeViewScheme = null;
            treeViewScheme = bl ? this.schemeTransfering : this.schemeFiles;
            treeNode.setScheme(treeViewScheme);
            if (bl2) {
                this.tv.commit(1);
                return;
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public void showTreeViewNode(TreeNode treeNode) {
        try {
            this.tv.showTreeViewNode(treeNode);
            return;
        }
        catch (Exception exception) {
            this.handleException(exception);
            return;
        }
    }

    public void selectTreeViewNode(TreeNode treeNode) {
        try {
            this.tv.selectTreeViewNode(treeNode);
            return;
        }
        catch (Exception exception) {
            this.handleException(exception);
            return;
        }
    }

    public void queryDir(TreeNode treeNode, boolean bl, boolean bl2) {
        try {
            if (!treeNode.hasChild()) {
                return;
            }
            this.setWaitCursor();
            if (!bl && this.cachedDir(treeNode)) {
                this.cd(treeNode);
            } else {
                this.bRefresh = bl;
                String string = this.createCompletePath(treeNode);
                System.currentTimeMillis();
                DirectoryInfo directoryInfo = this.queryDirectory(string);
                this.createTree(treeNode, directoryInfo);
                treeNode.setScheme(this.schemeFoldersCached);
            }
            if (bl2) {
                this.tv.updateTreeViewFolder(treeNode);
            }
            this.signalPathUpdate();
            this.clearWaitCursor();
            return;
        }
        catch (Exception exception) {
            this.handleException(exception);
            return;
        }
    }

    public boolean cachedDir(TreeNode treeNode) {
        try {
            TreeNode treeNode2 = (TreeNode)treeNode.getChildNode();
            String string = treeNode2.toString();
            return string.compareTo(" ") != 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int handleException(Exception exception) {
        try {
            if (exception instanceof FTPException) {
                ((FTPException)exception).setFrame(this.parent.getParentFrame());
                return this.ftp.lastException((FTPException)exception);
            }
            System.err.println(exception);
            return 2;
        }
        catch (Exception exception2) {
            System.err.println("HandleExcpetion() Error: " + exception2);
            return 3;
        }
    }

    public void changeDirectory(Frame frame, TreeNode treeNode) {
        try {
            String string = this.createCompletePath(treeNode);
            String string2 = null;
            RemoteCDDialog remoteCDDialog = new RemoteCDDialog(frame, string, TreeComponent.RFresources);
            string2 = remoteCDDialog.getString();
            this.changeDirectory(string2);
            return;
        }
        catch (Exception exception) {
            System.err.println("HandleExcpetion: " + exception);
            return;
        }
    }

    public void changeDirectory(TreeNode treeNode) {
        try {
            if (treeNode == null) {
                return;
            }
            String string = this.createCompletePath(treeNode);
            this.changeDirectory(string);
            return;
        }
        catch (Exception exception) {
            System.err.println("HandleExcpetion: " + exception);
            return;
        }
    }

    public void changeDirectory(String string) {
        try {
            if (string == null) {
                return;
            }
            boolean bl = this.cd(string);
            if (bl) {
                this.updateTreeToMatchPath(string);
                return;
            }
        }
        catch (Exception exception) {
            System.err.println("HandleExcpetion: " + exception);
        }
    }

    protected void updateTreeToMatchPath(String string) {
        try {
            String string2 = FTPFilename.separator;
            String string3 = null;
            String string4 = string;
            int n = -1;
            int n2 = -1;
            Vector<String> vector = new Vector<String>(5, 5);
            do {
                if ((n = string4.indexOf(string2)) != -1) {
                    string3 = string4.substring(0, n);
                    vector.addElement(string3);
                    n2 = string4.length();
                    if (n + 1 < n2) {
                        string4 = string4.substring(n + 1);
                        continue;
                    }
                    string4 = null;
                    continue;
                }
                n2 = string4.length();
                if (n + 1 < n2) {
                    string3 = string4.substring(n + 1);
                }
                vector.addElement(string3);
                string4 = null;
            } while (string4 != null);
            TreeNode treeNode = this.addFakeTree(vector);
            this.queryDir(treeNode, false, true);
            return;
        }
        catch (Exception exception) {
            System.err.println("HandleExcpetion: " + exception);
            return;
        }
    }

    protected TreeNode addFakeTree(Vector vector) {
        try {
            TreeNode treeNode = null;
            TreeNode treeNode2 = null;
            TreeNode treeNode3 = (TreeNode)this.attvRoot;
            String string = null;
            int n = 0;
            int n2 = vector.size();
            do {
                treeNode = treeNode3;
            } while ((treeNode3 = treeNode3.findTreeNode((String)vector.elementAt(n++))) != null && n < n2);
            if (n == n2 && treeNode3 != null) {
                return treeNode3;
            }
            --n;
            while (n < n2) {
                string = (String)vector.elementAt(n++);
                treeNode2 = new TreeNode(string, this.schemeFolders);
                this.addDirectoryToTree(treeNode, treeNode2, false);
                treeNode = treeNode2;
            }
            return treeNode2;
        }
        catch (Exception exception) {
            System.err.println("HandleExcpetion: " + exception);
            return null;
        }
    }

    public String pwd() {
        try {
            System.out.println("CurPath:" + this.ftp.pwd().toString());
            return this.ftp.pwd().toString();
        }
        catch (Exception exception) {
            this.handleException(exception);
            return null;
        }
    }

    public FTPFilename path() {
        try {
            return this.ftp.pwd();
        }
        catch (Exception exception) {
            this.handleException(exception);
            return null;
        }
    }

    public void exit() {
        try {
            this.parent.exit();
            return;
        }
        catch (Exception exception) {
            this.handleException(exception);
            return;
        }
    }

    public void setWaitCursorAndMenus() {
        try {
            if (this.iEnableNum == 0) {
                this.svc.menuDirectory.setEnabled(false);
            }
            ++this.iEnableNum;
            this.setWaitCursor();
            return;
        }
        catch (Exception exception) {
            this.handleException(exception);
            return;
        }
    }

    public void clearWaitCursorAndMenus() {
        try {
            --this.iEnableNum;
            if (this.iEnableNum == 0) {
                this.svc.menuDirectory.setEnabled(true);
            }
            this.clearWaitCursor();
            return;
        }
        catch (Exception exception) {
            this.handleException(exception);
            return;
        }
    }

    protected void callCommitt(int n) {
        this.tv.commit(n);
    }

    public static boolean validateNode(TreeNode treeNode) {
        try {
            String string = treeNode.toString();
            if (string.compareTo(TreeComponent.RFresources.getString("PARENT_DIR")) == 0) {
                return false;
            }
            return string.compareTo(" ") != 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String convertToStandardFormat(String string) {
        try {
            return this.ftp.convertToStandardFormat(string);
        }
        catch (Exception exception) {
            this.handleException(exception);
            return string;
        }
    }

    public String convertFromStandardFormat(String string) {
        try {
            return this.ftp.convertFromStandardFormat(string);
        }
        catch (Exception exception) {
            this.handleException(exception);
            return string;
        }
    }

    public FileInfo getSubclassOfFileInfo(FTPFilename fTPFilename, long l) {
        try {
            return this.ftp.getSubclassOfFileInfo(fTPFilename, l);
        }
        catch (Exception exception) {
            this.handleException(exception);
            return null;
        }
    }

    public void cancel() {
        try {
            this.ftp.cancel();
            return;
        }
        catch (Exception exception) {
            this.handleException(exception);
            return;
        }
    }
}

