/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.remoteFile.mgr;

import com.ibm.eNetwork.onDemand.common.Copyright;
import com.ibm.eNetwork.onDemand.common.remoteFile.api.DirectoryInfo;
import com.ibm.eNetwork.onDemand.common.remoteFile.api.FTPFilename;
import com.ibm.eNetwork.onDemand.common.remoteFile.api.FileInfo;
import com.ibm.eNetwork.onDemand.common.remoteFile.file.FileException;
import com.ibm.eNetwork.onDemand.common.remoteFile.mgr.RemoteFileCS;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

class RemoteFileDirectoryInfo
extends DirectoryInfo {
    static final String cStmt1 = Copyright.COPYRIGHT_97_98;
    protected static SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yy hh:mmaaa");
    protected static TimeZone timeZone = TimeZone.getDefault();
    protected static Date date = new Date(1L);
    private static RemoteFileCS rmtFileCS;

    public RemoteFileDirectoryInfo(RemoteFileCS remoteFileCS) throws FileException {
        rmtFileCS = remoteFileCS;
        this.fillWithFiles(remoteFileCS);
    }

    protected void fillWithFiles(RemoteFileCS remoteFileCS) throws FileException {
        FileInfo[] fileInfoArray = remoteFileCS.getFileInfoItems();
        if (fileInfoArray != null) {
            int n = 0;
            while (n < fileInfoArray.length) {
                this.addFileInfo(fileInfoArray[n]);
                ++n;
            }
        }
    }

    public static void fillFileInfo(FileInfo fileInfo) throws FileException {
        try {
            FTPFilename fTPFilename = fileInfo.getFilename();
            rmtFileCS.setPath(fTPFilename.toString());
            long l = rmtFileCS.length();
            fileInfo.setFileSizeBytes(l);
            date.setTime(rmtFileCS.lastModified());
            sdf.setTimeZone(timeZone);
            fileInfo.setLastModified(sdf.format(date));
            fTPFilename.setDirectory(rmtFileCS.isDirectory());
            return;
        }
        catch (Exception exception) {
            throw new FileException(exception.getMessage());
        }
    }
}

