/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.remoteFile.mgr;

import com.ibm.eNetwork.onDemand.common.Copyright;
import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.images.ImageLoader;
import com.ibm.eNetwork.onDemand.common.remoteFile.api.fileTransferProtocol;
import com.ibm.eNetwork.onDemand.common.remoteFile.gui.SingleView;
import com.ibm.eNetwork.onDemand.common.remoteFile.gui.SingleViewComponents;
import com.ibm.eNetwork.onDemand.common.remoteFile.gui.SingleViewStrings;
import com.ibm.eNetwork.onDemand.common.remoteFile.gui.ableToUseFtpApiView;
import com.ibm.eNetwork.onDemand.common.remoteFile.mgr.ButtonPanel;
import com.ibm.eNetwork.onDemand.common.remoteFile.mgr.RFErrorMsg;
import com.ibm.eNetwork.onDemand.common.remoteFile.mgr.RemoteSessionMgr;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;

public class RemoteFileFrame
extends Frame
implements WindowListener,
ableToUseFtpApiView,
SingleViewStrings,
FocusListener,
ActionListener,
KeyListener {
    static final String cStmt1 = Copyright.COPYRIGHT_97_98;
    protected ImagesForCanvas ifcImage;
    protected FontsForCanvas ffcFont = new FontsForCanvas(new Font("sansserif", 0, 12), new Font("sansserif", 0, 12));
    protected ColorsForCanvas cfcColor = new ColorsForCanvas(SystemColor.control, Color.black, Color.yellow);
    protected static final int WIDTH = 600;
    protected static final int HEIGHT = 300;
    protected fileTransferProtocol ftp;
    protected SingleView sv;
    protected String sProtocolName;
    protected RemoteSessionMgr sm;
    protected Thread thread;
    protected static ImageLoader iLoader = null;
    private String selectedFile = "";
    private static final int NUM_BUTTONS = 2;
    private final int OK_BUTTON = 0;
    private final int CANCEL_BUTTON = 1;
    private Button[] buttons;
    private String[] buttonLabels;
    private ButtonPanel buttonPanel;
    private String title;
    private TextField txtFileName;
    private Label lblFileName;
    private Panel pnlFileName;
    private GridBagLayout gridBag;
    private GridBagConstraints constraints;
    private GridBagLayout gridBagPanel;
    private GridBagConstraints constraintsPanel;
    private ResourceBundle RFresources;
    private SingleViewComponents svc;
    private int rfOptions;

    public RemoteFileFrame(fileTransferProtocol fileTransferProtocol2, RemoteSessionMgr remoteSessionMgr, Applet applet, ResourceBundle resourceBundle, int n) {
        this.init(fileTransferProtocol2, remoteSessionMgr, applet, resourceBundle, n);
        this.initComponents(this.sProtocolName);
    }

    public RemoteFileFrame(fileTransferProtocol fileTransferProtocol2, RemoteSessionMgr remoteSessionMgr, Applet applet, ResourceBundle resourceBundle, int n, String string) {
        this.init(fileTransferProtocol2, remoteSessionMgr, applet, resourceBundle, n);
        this.initComponents(string);
    }

    private void init(fileTransferProtocol fileTransferProtocol2, RemoteSessionMgr remoteSessionMgr, Applet applet, ResourceBundle resourceBundle, int n) {
        this.RFresources = resourceBundle;
        this.rfOptions = n;
        this.initImageLoader(applet);
        this.svc = new SingleViewComponents(this.RFresources);
        this.ftp = fileTransferProtocol2;
        this.sm = remoteSessionMgr;
        this.sv = new SingleView(this, fileTransferProtocol2, this.svc, this.cfcColor, this.ffcFont, iLoader, this.RFresources);
        this.sProtocolName = this.sv.getProtocolName();
    }

    public ImageLoader getImageLoader() {
        return iLoader;
    }

    public void start() {
        try {
            this.show();
            this.sv.start();
            return;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return;
        }
    }

    public void updatePath(String string) {
        try {
            this.setTitle(String.valueOf(this.title) + " - " + string);
            return;
        }
        catch (Exception exception) {
            this.sv.handleException(exception);
            return;
        }
    }

    public Frame getParentFrame() {
        return this;
    }

    public SingleView getSingleView() {
        return this.sv;
    }

    public void exit() {
        try {
            this.sm.stop();
            return;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return;
        }
    }

    public void stop() {
        try {
            this.sv.quit();
            return;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return;
        }
    }

    public void UpdateSelectedFile(String string) {
        this.selectedFile = string;
        if (this.txtFileName != null) {
            ((TextComponent)this.txtFileName).setText(string);
        }
    }

    protected void initImageLoader(Applet applet) {
        if (iLoader != null) {
            return;
        }
        if (applet == null) {
            iLoader = new ImageLoader(this);
            return;
        }
        iLoader = new ImageLoader(applet);
    }

    private void initComponents(String string) {
        this.title = string;
        this.setTitle(string);
        ((Component)this).setBackground(Color.lightGray);
        this.setMenuBar(this.svc.menuBarMain);
        this.initButtonPanel();
        this.gridBag = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.gridBagPanel = new GridBagLayout();
        this.constraintsPanel = new GridBagConstraints();
        this.addWindowListener(this);
        this.addFocusListener(this);
        if ((this.rfOptions & RemoteSessionMgr.RF_HIDETEXTBOX) != RemoteSessionMgr.RF_HIDETEXTBOX) {
            this.lblFileName = new Label(this.RFresources.getString("FILENAME_LABEL"));
            this.txtFileName = new TextField();
            this.pnlFileName = new Panel();
            this.addComponentsToGrid();
            return;
        }
        this.addComponentsToGrid_noFileName();
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    private void addComponentsToGrid() {
        this.setLayout(this.gridBag);
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.weighty = 0.7;
        this.add(this.sv, this.gridBag, this.constraints, 0, 0, 0, 1);
        this.constraints.weighty = 0.2;
        this.constraints.anchor = 17;
        this.constraintsPanel.fill = 1;
        this.constraintsPanel.anchor = 17;
        this.constraintsPanel.weightx = 1.0;
        this.constraintsPanel.weighty = 0.0;
        this.pnlFileName.setLayout(this.gridBagPanel);
        this.constrain(this.lblFileName, this.gridBagPanel, this.constraintsPanel, 0, 0, 0, 1);
        this.pnlFileName.add(this.lblFileName);
        this.constrain(this.txtFileName, this.gridBagPanel, this.constraintsPanel, 0, 1, 0, 0);
        this.pnlFileName.add(this.txtFileName);
        this.add(this.pnlFileName, this.gridBag, this.constraints, 0, 1, 0, 1);
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.constraints.weighty = 0.1;
        this.add(this.buttonPanel, this.gridBag, this.constraints, 0, 2, 0, 0);
    }

    private void addComponentsToGrid_noFileName() {
        this.setLayout(this.gridBag);
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.weighty = 0.9;
        this.add(this.sv, this.gridBag, this.constraints, 0, 0, 0, 1);
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.constraints.weighty = 0.1;
        this.add(this.buttonPanel, this.gridBag, this.constraints, 0, 2, 0, 0);
    }

    private void initButtonPanel() {
        this.buttonLabels = new String[2];
        this.buttonLabels[0] = this.RFresources.getString("BUTTON_PANEL_OK");
        this.buttonLabels[1] = this.RFresources.getString("BUTTON_PANEL_CANCEL");
        int n = this.buttonLabels.length;
        this.buttons = new Button[n];
        int n2 = 0;
        while (n2 < this.buttonLabels.length) {
            this.buttons[n2] = new Button(this.buttonLabels[n2]);
            this.buttons[n2].addActionListener(this);
            this.buttons[n2].addKeyListener(this);
            ++n2;
        }
        this.buttonPanel = new ButtonPanel(this, this.buttons);
    }

    public void fileSelected(String string) {
        if (this.checkFileOK()) {
            this.sm.UpdateSelectedFile(this.selectedFile);
        }
    }

    private void handleButton(Button button) {
        if (button == this.buttons[0] && this.checkFileOK()) {
            this.sm.UpdateSelectedFile(this.selectedFile);
        }
        if (button == this.buttons[1]) {
            this.sm.UserCanceledMgr();
        }
    }

    private boolean checkFileOK() {
        boolean bl = false;
        if ((this.rfOptions & RemoteSessionMgr.RF_HIDETEXTBOX) != RemoteSessionMgr.RF_HIDETEXTBOX) {
            boolean bl2;
            String string = this.txtFileName.getText();
            if (string.indexOf(",") != -1) {
                RFErrorMsg.DisplayError(this, this.RFresources.getString("RFERROR_COMMAS"), this.RFresources);
                return false;
            }
            boolean bl3 = this.ftp.fileExists(string);
            if ((this.rfOptions & RemoteSessionMgr.RF_MUSTEXIST) == RemoteSessionMgr.RF_MUSTEXIST) {
                if (bl3) {
                    bl = true;
                } else {
                    RFErrorMsg.DisplayError(this, this.RFresources.getString("RFERROR_MUSTEXIST"), this.RFresources);
                }
            } else if ((this.rfOptions & RemoteSessionMgr.RF_MAKENEW) == RemoteSessionMgr.RF_MAKENEW) {
                if (!bl3) {
                    bl = true;
                } else {
                    RFErrorMsg.DisplayError(this, this.RFresources.getString("RFERROR_MAKENEW"), this.RFresources);
                }
            } else if ((this.rfOptions & RemoteSessionMgr.RF_WARNEXISTS) == RemoteSessionMgr.RF_WARNEXISTS) {
                if (bl3) {
                    bl2 = this.ftp.isDirectory(string);
                    if ((this.rfOptions & RemoteSessionMgr.RF_FILEONLY) == RemoteSessionMgr.RF_FILEONLY && !bl2) {
                        RFErrorMsg.DisplayError(this, this.RFresources.getString("RFERROR_WARNFILEEXISTS"), this.RFresources);
                    }
                }
                bl = true;
            } else {
                bl = true;
            }
            if (bl && bl3) {
                bl2 = this.ftp.isDirectory(string);
                if ((this.rfOptions & RemoteSessionMgr.RF_DIRECTORYONLY) == RemoteSessionMgr.RF_DIRECTORYONLY) {
                    if (!bl2) {
                        bl = false;
                        RFErrorMsg.DisplayError(this, this.RFresources.getString("RFERROR_DIRECTORYONLY"), this.RFresources);
                    }
                } else if ((this.rfOptions & RemoteSessionMgr.RF_FILEONLY) == RemoteSessionMgr.RF_FILEONLY && bl2) {
                    bl = false;
                    RFErrorMsg.DisplayError(this, this.RFresources.getString("RFERROR_FILEONLY"), this.RFresources);
                }
            }
            if (bl) {
                this.selectedFile = string;
            }
        } else {
            boolean bl4 = this.ftp.isDirectory(this.selectedFile);
            if ((this.rfOptions & RemoteSessionMgr.RF_DIRECTORYONLY) == RemoteSessionMgr.RF_DIRECTORYONLY) {
                if (bl4) {
                    bl = true;
                } else {
                    RFErrorMsg.DisplayError(this, this.RFresources.getString("RFERROR_DIRECTORYONLY"), this.RFresources);
                }
            } else if ((this.rfOptions & RemoteSessionMgr.RF_FILEONLY) == RemoteSessionMgr.RF_FILEONLY) {
                if (!bl4) {
                    bl = true;
                } else {
                    RFErrorMsg.DisplayError(this, this.RFresources.getString("RFERROR_FILEONLY"), this.RFresources);
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.sm.UserCanceledMgr();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        try {
            if (focusEvent.getSource() instanceof RemoteFileFrame) {
                this.sv.requestFocus();
                return;
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

