/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.remoteFile.mgr;

import com.ibm.eNetwork.onDemand.common.Copyright;
import com.ibm.eNetwork.onDemand.common.remoteFile.api.DirectoryInfo;
import com.ibm.eNetwork.onDemand.common.remoteFile.api.FTPException;
import com.ibm.eNetwork.onDemand.common.remoteFile.api.FTPFilename;
import com.ibm.eNetwork.onDemand.common.remoteFile.api.FileInfo;
import com.ibm.eNetwork.onDemand.common.remoteFile.api.fileTransferProtocol;
import com.ibm.eNetwork.onDemand.common.remoteFile.file.FileException;
import com.ibm.eNetwork.onDemand.common.remoteFile.mgr.RFErrorMsg;
import com.ibm.eNetwork.onDemand.common.remoteFile.mgr.RemoteFileCS;
import com.ibm.eNetwork.onDemand.common.remoteFile.mgr.RemoteFileDirectoryInfo;
import java.applet.Applet;
import java.util.Properties;
import java.util.ResourceBundle;

class RemoteFileProtocol
implements fileTransferProtocol {
    static final String cStmt1 = Copyright.COPYRIGHT_97_98;
    protected RemoteFileCS fCurrent;
    protected static final int BUFFER_SIZE = 262144;
    protected boolean bIsDriveBased = false;
    protected Applet applet;
    protected boolean bCancel = false;
    private ResourceBundle RFresources;

    public RemoteFileProtocol(RemoteFileCS remoteFileCS, ResourceBundle resourceBundle) {
        this.RFresources = resourceBundle;
        this.fCurrent = remoteFileCS;
        try {
            Properties properties = System.getProperties();
            String string = properties.getProperty("os.name");
            if (string != null) {
                String string2 = string.toLowerCase();
                if (string2.indexOf("os/2") != -1 || string2.indexOf("windows") != -1) {
                    this.bIsDriveBased = true;
                }
                return;
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public FTPFilename cd(FTPFilename fTPFilename) throws FTPException {
        try {
            String string = this.massageDirectory(fTPFilename.getPath());
            this.fCurrent.setPath(string);
            if (!this.fCurrent.isDirectory()) {
                throw new FileException(this.RFresources.getString("FILE_INVALID_PATH"));
            }
            FTPFilename fTPFilename2 = new FTPFilename(fTPFilename.getPath());
            return fTPFilename2;
        }
        catch (Exception exception) {
            throw new FileException(exception, this.RFresources.getString("FILE_INVALID_PATH"));
        }
    }

    public FTPFilename pwd() throws FTPException {
        try {
            FTPFilename fTPFilename = new FTPFilename(this.inverseMassageDirectory(this.fCurrent.getPath()));
            return fTPFilename;
        }
        catch (Exception exception) {
            throw new FileException(exception, this.RFresources.getString("FILE_INVALID_PATH"));
        }
    }

    public DirectoryInfo dir(FTPFilename fTPFilename, String string) throws FTPException {
        try {
            if (!fTPFilename.isDirectory()) {
                throw new FTPException(this.RFresources.getString("FILE_INVALID_PATH"));
            }
            this.fCurrent.setPath(this.massageDirectory(fTPFilename.getPath()));
            if (!this.fCurrent.isDirectory()) {
                throw new FTPException(this.RFresources.getString("FILE_INVALID_PATH"));
            }
            RemoteFileDirectoryInfo remoteFileDirectoryInfo = new RemoteFileDirectoryInfo(this.fCurrent);
            return remoteFileDirectoryInfo;
        }
        catch (Exception exception) {
            throw new FileException(exception.getMessage());
        }
    }

    public void cancel() throws FTPException {
        this.bCancel = true;
    }

    public void quit() throws FTPException {
    }

    public int lastException(FTPException fTPException) {
        try {
            if (fTPException instanceof FileException) {
                FileException fileException = (FileException)fTPException;
                RFErrorMsg.DisplayError(fileException.getFrame(), fileException.getErrorString(), this.RFresources);
            }
            return 2;
        }
        catch (Exception exception) {
            System.err.println("lastException " + exception);
            return 2;
        }
    }

    public String getProtocolName() {
        return RemoteFileProtocol._getProtocolName(this.RFresources);
    }

    public static String _getProtocolName(ResourceBundle resourceBundle) {
        return resourceBundle.getString("REMOTE_FILE_PROTOCOL");
    }

    public String massageDirectory(String string) {
        try {
            if (!this.bIsDriveBased) {
                return string;
            }
            String string2 = string;
            int n = string2.indexOf(58);
            if (n != -1) {
                int n2 = string2.indexOf(FTPFilename.separator);
                if (n2 == -1 || n + 1 != n2) {
                    string2 = String.valueOf(string2.substring(0, n + 1)) + FTPFilename.separator + string2.substring(n + 1);
                    n2 = n + 1;
                }
                int n3 = string2.indexOf(".");
                if (n + 1 == n2 && n2 + 1 != n3) {
                    string2 = String.valueOf(string2.substring(0, n2)) + FTPFilename.separator + "." + string2.substring(n2);
                }
            }
            return string2;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return string;
        }
    }

    public String inverseMassageDirectory(String string) {
        try {
            if (!this.bIsDriveBased) {
                return string;
            }
            String string2 = string;
            int n = string2.indexOf(58);
            if (n != -1) {
                int n2 = string2.indexOf(FTPFilename.separator);
                if (n2 == -1 || n + 1 != n2) {
                    return string2;
                }
                int n3 = string2.indexOf(".");
                if (n + 1 == n2 && n2 + 1 == n3) {
                    string2 = n3 + 1 < string2.length() ? String.valueOf(string2.substring(0, n2)) + string2.substring(n3 + 1) : string2.substring(0, n2);
                }
            }
            return string2;
        }
        catch (Exception exception) {
            System.err.println("inverseMassage:" + exception);
            return string;
        }
    }

    public boolean isDriveBased() {
        return this.bIsDriveBased;
    }

    public boolean validatePath(String string) {
        try {
            this.fCurrent.setPath(this.massageDirectory(string));
            return this.fCurrent.isDirectory();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String convertToStandardFormat(String string) {
        return string;
    }

    public String convertFromStandardFormat(String string) {
        return string;
    }

    public FileInfo getSubclassOfFileInfo(FTPFilename fTPFilename, long l) {
        return new FileInfo(fTPFilename, l);
    }

    public boolean fileExists(String string) {
        if (!string.equals("")) {
            this.fCurrent.setPath(this.massageDirectory(string));
            if (this.fCurrent.isFile()) {
                return true;
            }
            if (this.fCurrent.isDirectory()) {
                return true;
            }
        }
        return false;
    }

    public boolean isDirectory(String string) {
        if (!string.equals("")) {
            this.fCurrent.setPath(this.massageDirectory(string));
            return this.fCurrent.isDirectory();
        }
        return false;
    }
}

