/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.security;

import com.ibm.eNetwork.onDemand.common.security.AuthenticationException;
import com.ibm.eNetwork.onDemand.common.security.NeedCredentialsException;
import com.ibm.eNetwork.onDemand.common.security.SecureData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.Remote;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;

public class AuthenticatedData
implements SecureData,
Serializable {
    private byte[] parambytes;
    private Vector refs = new Vector();
    private String username;
    private byte[] credentials;
    private transient String method;
    private transient String objectID;
    private transient MessageDigest digest;
    private transient ByteArrayOutputStream parameters;
    private transient ObjectOutputStream serialize;
    private transient ObjectInputStream deserialize;

    public AuthenticatedData(String string, String string2) {
        this.method = string;
        this.objectID = string2;
    }

    public AuthenticatedData(String string) {
        this.method = "";
        this.objectID = string;
    }

    private final void createOutputStream() throws IOException {
        if (this.serialize == null) {
            this.parameters = new ByteArrayOutputStream();
            this.serialize = new ObjectOutputStream(this.parameters);
        }
    }

    private final void createInputStream() throws IOException {
        if (this.deserialize == null) {
            this.deserialize = new ObjectInputStream(new ByteArrayInputStream(this.parambytes));
        }
    }

    public final void setUsername(String string) {
        this.username = string;
    }

    public final String getUsername() {
        return this.username;
    }

    public final void setPassword(String string) {
        try {
            this.digest = MessageDigest.getInstance("MD5");
            this.digest.update(string.getBytes());
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("Exception instantiating MD5 digest: " + noSuchAlgorithmException.getMessage());
            return;
        }
    }

    public final void setPasswordDigest(MessageDigest messageDigest) {
        this.digest = messageDigest;
    }

    public final void addParameter(Object object) {
        try {
            this.createOutputStream();
            if (object instanceof Remote) {
                this.refs.addElement(object);
                return;
            }
            this.serialize.writeObject(object);
            return;
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException.getMessage());
            return;
        }
    }

    public final void addParameter(boolean bl) {
        try {
            this.createOutputStream();
            this.serialize.writeBoolean(bl);
            return;
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException.getMessage());
            return;
        }
    }

    public final void addParameter(byte by) {
        try {
            this.createOutputStream();
            this.serialize.writeByte(by);
            return;
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException.getMessage());
            return;
        }
    }

    public final void addParameter(char c) {
        try {
            this.createOutputStream();
            this.serialize.writeChar(c);
            return;
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException.getMessage());
            return;
        }
    }

    public final void addParameter(double d) {
        try {
            this.createOutputStream();
            this.serialize.writeDouble(d);
            return;
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException.getMessage());
            return;
        }
    }

    public final void addParameter(float f) {
        try {
            this.createOutputStream();
            this.serialize.writeFloat(f);
            return;
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException.getMessage());
            return;
        }
    }

    public final void addParameter(int n) {
        try {
            this.createOutputStream();
            this.serialize.writeInt(n);
            return;
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException.getMessage());
            return;
        }
    }

    public final void addParameter(long l) {
        try {
            this.createOutputStream();
            this.serialize.writeLong(l);
            return;
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException.getMessage());
            return;
        }
    }

    public final void addParameter(short s) {
        try {
            this.createOutputStream();
            this.serialize.writeShort(s);
            return;
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException.getMessage());
            return;
        }
    }

    public final Object getObject() throws IOException, ClassNotFoundException {
        this.createInputStream();
        return this.deserialize.readObject();
    }

    public final Object getRef() {
        Object e = this.refs.firstElement();
        this.refs.removeElementAt(0);
        return e;
    }

    public final boolean getBoolean() throws IOException {
        this.createInputStream();
        return this.deserialize.readBoolean();
    }

    public final byte getByte() throws IOException {
        this.createInputStream();
        return this.deserialize.readByte();
    }

    public final char getChar() throws IOException {
        this.createInputStream();
        return this.deserialize.readChar();
    }

    public final double getDouble() throws IOException {
        this.createInputStream();
        return this.deserialize.readDouble();
    }

    public final float getFloat() throws IOException {
        this.createInputStream();
        return this.deserialize.readFloat();
    }

    public final int getInt() throws IOException {
        this.createInputStream();
        return this.deserialize.readInt();
    }

    public final long getLong() throws IOException {
        this.createInputStream();
        return this.deserialize.readLong();
    }

    public final short getShort() throws IOException {
        this.createInputStream();
        return this.deserialize.readShort();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.digest == null || this.username == null) {
            throw new NotSerializableException("Credentials required to serialize AuthenticatedData object");
        }
        this.createOutputStream();
        this.serialize.flush();
        this.parambytes = this.parameters.toByteArray();
        this.digest.update(this.parambytes);
        String string = String.valueOf(this.method) + this.objectID + this.username;
        this.digest.update(string.getBytes());
        this.credentials = this.digest.digest();
        objectOutputStream.defaultWriteObject();
    }

    public final void verify(AuthenticatedData authenticatedData) throws AuthenticationException, NeedCredentialsException {
        if (this.digest == null || authenticatedData.username == null) {
            throw new NeedCredentialsException();
        }
        this.digest.update(authenticatedData.parambytes);
        String string = String.valueOf(this.method) + this.objectID + authenticatedData.username;
        this.digest.update(string.getBytes());
        this.credentials = this.digest.digest();
        if (!MessageDigest.isEqual(this.credentials, authenticatedData.credentials)) {
            throw new AuthenticationException("Invalid credentials");
        }
    }
}

