/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.security;

import com.ibm.eNetwork.onDemand.common.security.InvalidPasswordException;
import com.ibm.eNetwork.onDemand.common.security.NeedCredentialsException;
import com.ibm.eNetwork.onDemand.common.security.SecureData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class EncryptedData
implements SecureData,
Serializable {
    private byte[] ciphertext;
    private byte[] correlator;
    private byte[] reference;
    private transient byte[] key;
    private transient ByteArrayOutputStream plaintextout;
    private transient ObjectOutputStream serialize;
    private transient ObjectInputStream deserialize;

    public EncryptedData() {
        try {
            this.plaintextout = new ByteArrayOutputStream();
            this.serialize = new ObjectOutputStream(this.plaintextout);
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException.getMessage());
        }
        this.correlator = new byte[16];
        Random random = new Random();
        random.nextBytes(this.correlator);
    }

    public final void addData(Object object) {
        try {
            this.serialize.writeObject(object);
            return;
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException.getMessage());
            return;
        }
    }

    public final void setUsername(String string) {
    }

    public final void setPassword(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes());
            messageDigest.update(this.correlator);
            this.key = messageDigest.digest();
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("Exception instantiating MD5 digest: " + noSuchAlgorithmException.getMessage());
            return;
        }
    }

    public final void setPasswordDigest(MessageDigest messageDigest) {
        messageDigest.update(this.correlator);
        this.key = messageDigest.digest();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.serialize.flush();
        byte[] byArray = this.plaintextout.toByteArray();
        try {
            this.reference = this.encrypt(this.correlator);
            this.ciphertext = this.encrypt(byArray);
        }
        catch (NeedCredentialsException needCredentialsException) {
            throw new NotSerializableException("Credentials required to serialize EncryptedData object");
        }
        objectOutputStream.defaultWriteObject();
    }

    public final void validate() throws InvalidPasswordException, NeedCredentialsException {
        byte[] byArray = this.decrypt(this.reference);
        if (!this.equal(byArray, this.correlator)) {
            throw new InvalidPasswordException();
        }
        try {
            this.deserialize = new ObjectInputStream(new ByteArrayInputStream(this.decrypt(this.ciphertext)));
            return;
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException.getMessage());
            return;
        }
    }

    public final Object getData() throws IOException, ClassNotFoundException {
        return this.deserialize.readObject();
    }

    private final boolean equal(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private final byte[] encrypt(byte[] byArray) throws NeedCredentialsException {
        return this.crypt(byArray);
    }

    private final byte[] decrypt(byte[] byArray) throws NeedCredentialsException {
        return this.crypt(byArray);
    }

    private final byte[] crypt(byte[] byArray) throws NeedCredentialsException {
        if (this.key == null) {
            throw new NeedCredentialsException();
        }
        byte[] byArray2 = new byte[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            byArray2[n] = (byte)(byArray[n] ^ this.key[n / this.key.length]);
            ++n;
        }
        return byArray2;
    }
}

