/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.sort;

import com.ibm.eNetwork.onDemand.common.sort.Comparable;
import com.ibm.eNetwork.onDemand.common.sort.SortAlgorithm;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Vector;

public class QuickSort
extends SortAlgorithm {
    private static final int CUTOFF_VALUE = 20;

    private final int partition(Vector vector, int n, int n2, Object object, boolean bl) throws Exception {
        int n3 = (n + n2) / 2;
        if (bl) {
            if (this.compare(vector, n, n3, object) > 0) {
                this.swap(vector, n, n3);
            }
            if (this.compare(vector, n, n2, object) > 0) {
                this.swap(vector, n, n2);
            }
            if (this.compare(vector, n3, n2, object) > 0) {
                this.swap(vector, n3, n2);
            }
        } else {
            if (this.compare(vector, n, n3, object) < 0) {
                this.swap(vector, n, n3);
            }
            if (this.compare(vector, n, n2, object) < 0) {
                this.swap(vector, n, n2);
            }
            if (this.compare(vector, n3, n2, object) < 0) {
                this.swap(vector, n3, n2);
            }
        }
        int n4 = n2 - 1;
        this.swap(vector, n3, n4);
        int n5 = n;
        Comparable comparable = (Comparable)vector.elementAt(n4);
        do {
            if (bl) {
                while (this.compare(vector, ++n5, comparable, object) < 0) {
                }
                while (this.compare(vector, --n4, comparable, object) > 0) {
                }
            } else {
                while (this.compare(vector, ++n5, comparable, object) > 0) {
                }
                while (this.compare(vector, --n4, comparable, object) < 0) {
                }
            }
            this.swap(vector, n5, n4);
        } while (n5 < n4);
        this.swap(vector, n4, n5);
        this.swap(vector, n5, n2 - 1);
        return n5;
    }

    private final int compare(Vector vector, int n, int n2, Object object) throws Exception {
        return ((Comparable)vector.elementAt(n)).compareTo((Comparable)vector.elementAt(n2), object);
    }

    private final int compare(Vector vector, int n, Comparable comparable, Object object) throws Exception {
        return ((Comparable)vector.elementAt(n)).compareTo(comparable, object);
    }

    private final int compare(Comparable comparable, Comparable comparable2, Object object) throws Exception {
        return comparable.compareTo(comparable2, object);
    }

    private void quickSort(Vector vector, int n, int n2, Object object, boolean bl) throws Exception {
        int[] nArray = new int[Math.max(Math.abs(n2 - n) * 2 + 20, 50)];
        int n3 = 2;
        do {
            if (n2 > n) {
                if (n2 - n > 20) {
                    int n4 = this.partition(vector, n, n2, object, bl);
                    if (n4 - n > n2 - n4) {
                        nArray[n3++] = n;
                        nArray[n3++] = n4 - 1;
                        n = n4 + 1;
                        continue;
                    }
                    nArray[n3++] = n4 + 1;
                    nArray[n3++] = n2;
                    n2 = n4 - 1;
                    continue;
                }
                this.insSort(vector, n, n2, object, bl);
                n2 = nArray[--n3];
                n = nArray[--n3];
                continue;
            }
            n2 = nArray[--n3];
            n = nArray[--n3];
        } while (n3 > 0 && !this.stopRequested);
    }

    private final void insSort(Vector vector, int n, int n2, Object object, boolean bl) throws Exception {
        int n3 = n + 1;
        while (n3 <= n2) {
            int n4;
            int n5;
            Comparable comparable = (Comparable)vector.elementAt(n3);
            if (bl) {
                n5 = n3;
                n4 = n5 - 1;
                while (n5 > 0 && this.compare(vector, n4, comparable, object) > 0) {
                    vector.setElementAt(vector.elementAt(n4), n5);
                    --n5;
                    --n4;
                }
            } else {
                n5 = n3;
                n4 = n5 - 1;
                while (n5 > 0 && this.compare(vector, n4, comparable, object) < 0) {
                    vector.setElementAt(vector.elementAt(n4), n5);
                    --n5;
                    --n4;
                }
            }
            vector.setElementAt(comparable, n5);
            ++n3;
        }
    }

    private final void swap(Vector vector, int n, int n2) {
        Object e = vector.elementAt(n);
        vector.setElementAt(vector.elementAt(n2), n);
        vector.setElementAt(e, n2);
    }

    public void sort(Vector vector) throws Exception {
        this.sort(vector, (Object)null);
    }

    public void sort(Vector vector, Object object) throws Exception {
        this.sort(vector, object, true);
    }

    public void sort(Vector vector, Object object, boolean bl) throws Exception {
        if (vector.size() < 2) {
            return;
        }
        this.quickSort(vector, 0, vector.size() - 1, object, bl);
    }

    public void sort(Vector vector, Collator collator) throws Exception {
        this.sort(vector, collator, true);
    }

    public void sort(Vector vector, Collator collator, boolean bl) throws Exception {
        if (vector.size() < 2) {
            return;
        }
        Vector<ComparableString> vector2 = new Vector<ComparableString>(vector.size());
        String string = "";
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            vector2.addElement(new ComparableString(string, collator.getCollationKey(string)));
        }
        this.quickSort(vector2, 0, vector2.size() - 1, null, bl);
        vector.removeAllElements();
        Enumeration enumeration2 = vector2.elements();
        while (enumeration2.hasMoreElements()) {
            string = ((ComparableString)enumeration2.nextElement()).getString();
            vector.addElement(string);
        }
    }

    public void insert(Vector vector, Comparable comparable) throws Exception {
        this.insert(vector, comparable, null);
    }

    public void insert(Vector vector, Comparable comparable, Object object) throws Exception {
        this.insert(vector, comparable, object, true);
    }

    public void insert(Vector vector, Comparable comparable, Object object, boolean bl) throws Exception {
        if (vector.size() == 0) {
            vector.addElement(comparable);
            return;
        }
        this.ins(vector, comparable, 0, vector.size() - 1, object, bl);
    }

    private void ins(Vector vector, Comparable comparable, int n, int n2, Object object, boolean bl) {
        if (n > n2) {
            vector.insertElementAt(comparable, n);
            return;
        }
        int n3 = (n + n2) / 2;
        int n4 = comparable.compareTo((Comparable)vector.elementAt(n3), object);
        if (n4 > 0) {
            if (bl) {
                this.ins(vector, comparable, n3 + 1, n2, object, bl);
                return;
            }
            this.ins(vector, comparable, n, n3 - 1, object, bl);
            return;
        }
        if (n4 < 0) {
            if (bl) {
                this.ins(vector, comparable, n, n3 - 1, object, bl);
                return;
            }
            this.ins(vector, comparable, n3 + 1, n2, object, bl);
            return;
        }
        vector.insertElementAt(comparable, n3);
    }

    private class ComparableString
    implements Comparable {
        private String str;
        private CollationKey key;

        public ComparableString(String string, CollationKey collationKey) {
            QuickSort.this = QuickSort.this;
            this.str = string;
            this.key = collationKey;
        }

        public String getString() {
            return this.str;
        }

        public int compareTo(Comparable comparable, Object object) {
            int n = this.key.compareTo(((ComparableString)comparable).key);
            return n;
        }
    }
}

