/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.config;

import com.ibm.eNetwork.onDemand.config.gui.ClntGuiContext;
import com.ibm.eNetwork.onDemand.config.gui.NodeTree;
import com.ibm.eNetwork.onDemand.config.node.NodeMgr;
import com.ibm.eNetwork.onDemand.config.util.Debug;
import com.ibm.eNetwork.onDemand.config.util.DummyLog;
import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.ButtonGroup;
import com.sun.java.swing.JApplet;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JRadioButton;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.UIManager;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ConfigApplet
extends JApplet {
    private static final String DEFAULT_NODEMGR = "com.ibm.eNetwork.onDemand.config.agents.AgentsNodeMgr";
    private Debug debug = new Debug("ConfigApplet", true);
    private String serverName;
    private int serverPort = 80;
    public static boolean chooseLAF;
    static String metal;
    static String metalClassName;
    static String windows;
    static String windowsClassName;
    static String motif;
    static String motifClassName;
    JRadioButton metalButton;
    JRadioButton windowsButton;
    JRadioButton motifButton;
    NodeTree tree;

    public void init() {
        String string = null;
        try {
            string = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel((String)string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        NodeMgr nodeMgr = NodeMgr.getNodeMgr((Applet)((Object)this));
        nodeMgr.setGuiContext(new ClntGuiContext((Applet)((Object)this)));
        nodeMgr.setLog(new DummyLog());
        try {
            this.tree = new NodeTree(nodeMgr, nodeMgr.getRoot((Applet)((Object)this)));
        }
        catch (Exception exception) {
            this.debug.print("Could not create tree.  Exception: " + exception);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", (Component)((Object)this.tree));
        if (chooseLAF) {
            JPanel jPanel = new JPanel((LayoutManager)new FlowLayout());
            this.metalButton = new JRadioButton(metal);
            this.metalButton.setActionCommand(metalClassName);
            this.windowsButton = new JRadioButton(windows);
            this.windowsButton.setActionCommand(windowsClassName);
            this.motifButton = new JRadioButton(motif);
            this.motifButton.setActionCommand(motifClassName);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)this.metalButton);
            buttonGroup.add((AbstractButton)this.windowsButton);
            buttonGroup.add((AbstractButton)this.motifButton);
            RadioListener radioListener = new RadioListener();
            this.metalButton.addActionListener((ActionListener)radioListener);
            this.windowsButton.addActionListener((ActionListener)radioListener);
            this.motifButton.addActionListener((ActionListener)radioListener);
            jPanel.add((Component)this.metalButton);
            jPanel.add((Component)this.windowsButton);
            jPanel.add((Component)this.motifButton);
            this.getContentPane().add("South", (Component)jPanel);
            this.updateState();
        }
        this.debug.print("end of init");
    }

    public void updateState() {
        String string = UIManager.getLookAndFeel().getClass().getName();
        if (string.indexOf(metal) >= 0) {
            this.metalButton.setSelected(true);
            return;
        }
        if (string.indexOf(windows) >= 0) {
            this.windowsButton.setSelected(true);
            return;
        }
        if (string.indexOf(motif) >= 0) {
            this.motifButton.setSelected(true);
            return;
        }
        System.err.println("SimpleExample if using an unknown L&F: " + string);
    }

    static {
        metal = "Metal";
        metalClassName = "com.sun.java.swing.plaf.metal.MetalLookAndFeel";
        windows = "Windows";
        windowsClassName = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        motif = "Motif";
        motifClassName = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    }

    class RadioListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            try {
                UIManager.setLookAndFeel((String)string);
                SwingUtilities.updateComponentTreeUI((Component)((Object)ConfigApplet.this));
                return;
            }
            catch (Exception exception) {
                JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
                jRadioButton.setEnabled(false);
                ConfigApplet.this.updateState();
                System.err.println("Could not load LookAndFeel: " + string);
                return;
            }
        }

        RadioListener() {
            ConfigApplet.this = ConfigApplet.this;
        }
    }
}

