/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.config;

import com.ibm.eNetwork.onDemand.config.gui.ClntGuiContext;
import com.ibm.eNetwork.onDemand.config.node.Node;
import com.ibm.eNetwork.onDemand.config.node.NodeList;
import com.ibm.eNetwork.onDemand.config.node.NodeMgr;
import com.ibm.eNetwork.onDemand.config.util.Debug;
import com.ibm.eNetwork.onDemand.config.util.DummyLog;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Label;
import java.awt.List;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;

public class Prototype
extends Applet
implements ActionListener {
    private Debug debug = new Debug("Prototype", true);
    private List treeGUI = new List(10, false);
    private Node currentNode;
    private String serverName;
    private int serverPort = 80;
    private TextField nodeNowShowing = new TextField("WKN                      ");
    private Button downButton = new Button("Show Node");
    private Button upButton = new Button("Go up one level");

    public void init() {
        this.add(this.treeGUI);
        this.add(this.downButton);
        this.add(this.upButton);
        this.add(new Label("Now showing: "));
        this.add(this.nodeNowShowing);
        this.downButton.addActionListener(this);
        this.upButton.addActionListener(this);
        NodeMgr nodeMgr = NodeMgr.getNodeMgr(this);
        nodeMgr.setGuiContext(new ClntGuiContext());
        nodeMgr.setLog(new DummyLog());
        String string = this.getParameter("rootLocation");
        URL uRL = null;
        try {
            uRL = new URL(this.getDocumentBase(), string);
        }
        catch (Exception exception) {}
        this.currentNode = nodeMgr.getRoot(this);
        this.showCurrentNode();
    }

    private void showCurrentNode() {
        if (this.currentNode != null) {
            ((TextComponent)this.nodeNowShowing).setText(this.currentNode.getLabel());
            this.debug.print("Expanding children for '" + this.currentNode.getLabel() + "'");
            NodeList nodeList = this.currentNode.getChildren(0, 0);
            int n = nodeList.size();
            this.treeGUI.setVisible(false);
            this.treeGUI.removeAll();
            if (n > 0) {
                int n2 = 0;
                while (n2 < n) {
                    Node node = (Node)nodeList.elementAt(n2);
                    this.treeGUI.add(node.getLabel());
                    ++n2;
                }
            } else {
                this.debug.print("No children exist for this node.");
            }
            this.treeGUI.setVisible(true);
        }
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.downButton) {
            int n = this.treeGUI.getSelectedIndex();
            if (n != -1) {
                this.debug.print("Finding '" + n + "'");
                Node node = this.currentNode.getChildAt(n);
                if (node != null) {
                    this.debug.print("Found.");
                    this.currentNode = node;
                    this.showCurrentNode();
                    return;
                }
                this.debug.print("Selected node was not found.");
                return;
            }
            this.debug.print("No child selected for expansion");
            return;
        }
        if (object == this.upButton) {
            Node node = this.currentNode.getParent();
            if (node != null) {
                this.debug.print("Showing parent node");
                this.currentNode = node;
                this.showCurrentNode();
                return;
            }
            this.debug.print("You are at the top level.");
        }
    }
}

