/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.config.agents;

import com.ibm.eNetwork.onDemand.common.BaseDirectory;
import com.ibm.eNetwork.onDemand.config.agents.EnodHostList;
import com.ibm.eNetwork.onDemand.config.agents.Host;
import com.ibm.eNetwork.onDemand.config.agents.HostList;
import com.ibm.eNetwork.onDemand.config.agents.ServerRootNode;
import com.ibm.eNetwork.onDemand.config.agents.ServiceRootNode;
import com.ibm.eNetwork.onDemand.config.nls.MsgTranslator;
import com.ibm.eNetwork.onDemand.config.nls.ServerSideMsgTranslator;
import com.ibm.eNetwork.onDemand.config.node.Node;
import com.ibm.eNetwork.onDemand.config.node.NodeMgr;
import com.ibm.eNetwork.onDemand.config.util.Log;
import com.ibm.eNetwork.onDemand.config.util.LogStub;
import java.awt.datatransfer.Clipboard;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class AgentsNodeMgr
extends NodeMgr {
    private static final String copyright = null;
    public static final String BASE_MI_CLASS = "com.ibm.eNetwork.onDemand.config.node.BaseMenuItem";
    public static final String WKN = "/Agents.WKN";
    static Node rootNode;
    private static boolean serviceView;
    private static Node service_View;
    private static Node server_View;
    private static final String SERVERPROFILE = "ConfigurationManagement.properites";
    private static boolean PROFILE_MGMT_ENABLED;
    private static boolean LOGGING_ENABLED;
    private static final boolean MULTIPLE_SERVERS_ENABLED = false;
    public static final String SERVERPROFILE_PROPERTY = "server Profile";
    public static final String NCOD_MESSAGE_CATALOG = "NCoD";
    private boolean serverProfileIsPersistent = false;
    private Log log = new LogStub();
    private MsgTranslator msgTranslator;
    private Properties serverProfile;
    private HostList hostList;
    private Host localHost;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    public static final String UNIQUE_NAME_SEPARATOR = "\u00a7";
    private static AgentsNodeMgr this_instance;

    public static AgentsNodeMgr getAgentsNodeMgr() {
        if (this_instance == null) {
            this_instance = (AgentsNodeMgr)NodeMgr.getNodeMgr("com.ibm.eNetwork.onDemand.config.agents.AgentsNodeMgr");
        }
        return this_instance;
    }

    public AgentsNodeMgr() {
        this.setClipboard(new Clipboard("IBM eNetwork On-Demand Clipboard"));
        this.createLog();
        this.createMsgTranslator();
    }

    public void setServiceView(boolean bl) {
        if (serviceView != bl) {
            serviceView = bl;
            this.setupRoot();
        }
    }

    public boolean getServiceView() {
        return serviceView;
    }

    private void setupRoot() {
        if (!serviceView) {
            if (server_View == null) {
                server_View = new ServerRootNode();
                server_View.setNodeMgr(this);
            }
            rootNode = server_View;
            return;
        }
        if (service_View == null) {
            service_View = new ServiceRootNode();
            service_View.setNodeMgr(this);
            return;
        }
        rootNode = service_View;
    }

    public Node getRoot(String string) {
        if (string != null && string.equalsIgnoreCase("service")) {
            serviceView = true;
        }
        this.loadServerProfile();
        this.createHostList();
        this.setupRoot();
        return rootNode;
    }

    public Node getNode(String string) {
        return null;
    }

    public HostList getHostList() {
        return this.hostList;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public Properties getSystemProperties() {
        return this.serverProfile;
    }

    public Host getLocalHost() {
        return this.localHost;
    }

    public void saveSystemProperties() {
        this.saveServerProfile();
    }

    private void createLog() {
        this.setLog(new LogStub());
    }

    private void createMsgTranslator() {
        this.setMsgTranslator(new ServerSideMsgTranslator(null, NCOD_MESSAGE_CATALOG));
    }

    private synchronized void loadServerProfile() {
        Properties properties = null;
        BaseDirectory baseDirectory = new BaseDirectory();
        boolean bl = false;
        if (this.serverProfile != null) {
            return;
        }
        if (!bl) {
            FileInputStream fileInputStream = null;
            this.serverProfileIsPersistent = false;
            properties = new Properties();
            this.log.traceMessage("Attempting to load from file 'ConfigurationManagement.properites'", 1);
            try {
                fileInputStream = new FileInputStream(String.valueOf(BaseDirectory.getConfigBaseDirectory()) + SERVERPROFILE);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
            if (fileInputStream != null) {
                String string = "open connection";
                try {
                    string = "load properties from file";
                    properties.load(fileInputStream);
                    string = "close properties file";
                    ((InputStream)fileInputStream).close();
                    this.log.traceMessage("ServerProfile loaded from file 'ConfigurationManagement.properites'", 1);
                }
                catch (IOException iOException) {
                    this.log.exception(iOException);
                    this.log.traceMessage("Exception occurred during phase: " + string, 1);
                }
            }
        }
        this.serverProfile = properties;
        this.pcs.firePropertyChange(SERVERPROFILE_PROPERTY, null, this.serverProfile);
    }

    public synchronized void saveServerProfile() {
        boolean bl = false;
        System.out.println("saving server profile");
        BaseDirectory baseDirectory = new BaseDirectory();
        if (!bl) {
            FileOutputStream fileOutputStream = null;
            this.log.traceMessage("Attempting to save to file 'ConfigurationManagement.properites'", 1);
            try {
                fileOutputStream = new FileOutputStream(String.valueOf(BaseDirectory.getConfigBaseDirectory()) + SERVERPROFILE);
            }
            catch (IOException iOException) {
                this.log.traceMessage("Could not open output server profile.");
                this.log.exception(iOException);
            }
            if (fileOutputStream != null) {
                this.serverProfile.save(fileOutputStream, "config.framework Profile");
                try {
                    fileOutputStream.close();
                    this.log.traceMessage("ServerProfile saved to file 'ConfigurationManagement.properites'", 1);
                    return;
                }
                catch (IOException iOException) {
                    this.log.exception(iOException);
                    return;
                }
            }
        }
    }

    private void createHostList() {
        this.hostList = new EnodHostList(this);
    }

    static {
        service_View = null;
        server_View = null;
        LOGGING_ENABLED = true;
    }
}

