/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.config.agents;

import com.ibm.eNetwork.onDemand.common.Copyright;
import com.ibm.eNetwork.onDemand.common.dataStructures.Comparator;
import com.ibm.eNetwork.onDemand.common.dataStructures.DefaultComparator;
import com.ibm.eNetwork.onDemand.common.nativecode.ServiceHandler;
import com.ibm.eNetwork.onDemand.common.nativecode.ServiceStatus;
import com.ibm.eNetwork.onDemand.config.agents.AgentsNodeMgr;
import com.ibm.eNetwork.onDemand.config.agents.ClipBoardObject;
import com.ibm.eNetwork.onDemand.config.agents.Daemon;
import com.ibm.eNetwork.onDemand.config.agents.Host;
import com.ibm.eNetwork.onDemand.config.agents.NodeParameterSet;
import com.ibm.eNetwork.onDemand.config.agents.ParameterSet;
import com.ibm.eNetwork.onDemand.config.nls.MsgTranslator;
import com.ibm.eNetwork.onDemand.config.node.BaseNode;
import com.ibm.eNetwork.onDemand.config.node.Node;
import com.ibm.eNetwork.onDemand.config.node.NodeMenuItemDescriptor;
import com.ibm.eNetwork.onDemand.config.node.NodeMenuItemDescriptorList;
import com.ibm.eNetwork.onDemand.config.node.NodeMgr;
import com.ibm.eNetwork.onDemand.config.util.Debug;
import com.ibm.eNetwork.onDemand.config.util.Log;
import com.ibm.eNetwork.onDemand.config.util.ObjectStringer;
import com.ibm.eNetwork.onDemand.config.util.VectorX;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class BaseDaemon
extends BaseNode
implements Daemon,
ServiceStatus,
PropertyChangeListener {
    private static final String copyright = Copyright.COPYRIGHT_98;
    private Host currentHost;
    AgentsNodeMgr anm = AgentsNodeMgr.getAgentsNodeMgr();
    Log log = this.anm.getLog();
    MsgTranslator mt = this.anm.getMsgTranslator();
    private String DisplayableName = "BaseDaemon";
    protected ParameterSet CurrentParameterSet;
    protected ParameterSet ActiveParameterSet;
    public String DAEMON_ID = "BaseDaemon";
    static String UNKNOWN_HOST_ID = "UnknownHost";
    static String HOST_DAEMON_DELIMITER = "..";
    private boolean dbg = false;
    static final int FIELDNAME = 0;
    static final int OLDFIELDVAL = 1;
    static final int NEWFIELDVAL = 2;
    ServiceHandler ServiceHandler;
    private int CurrentStatus = 10;
    private boolean TraceStatus;
    static final int START_ID = 301;
    static final int STOP_ID = 302;
    static final int PAUSE_ID = 303;
    static final int RESUME_ID = 304;
    static final int HELP_ID = 305;
    static final int PASTE_ID = 306;
    static final int getCurrentStatusOid = 310;
    static final int restartDaemonOid = 311;
    static final int activateParameterSetOid = 312;
    static final int addParameterSetOid = 313;
    static final int doesParameterSetNameExistOid = 314;
    public static final String IMAGES_DIR = "/com/ibm/eNetwork/onDemand/config/images";
    private Debug debug = new Debug("BaseDaemon");
    public static String PASTE_MI_CLASS = "com.ibm.eNetwork.onDemand.config.agents.PasteMenuItem";
    public static String HELP_MI_CLASS = "com.ibm.eNetwork.onDemand.config.agents.HelpMenuItem";
    public static String OPEN_MI_CLASS = "com.ibm.eNetwork.onDemand.config.agents.OpenMenuItem";
    public static String BASE_MI_CLASS = "com.ibm.eNetwork.onDemand.config.node.BaseMenuItem";
    private Vector parameterSetList = new Vector();
    int activePSIdx = -1;

    public NodeMenuItemDescriptorList getMenuItems() {
        NodeMenuItemDescriptor nodeMenuItemDescriptor;
        String string;
        Serializable serializable;
        int n;
        NodeMenuItemDescriptorList nodeMenuItemDescriptorList = new NodeMenuItemDescriptorList();
        if (this.getParameterSet() == null) {
            NodeMenuItemDescriptor nodeMenuItemDescriptor2 = new NodeMenuItemDescriptor(this.mt.get("Open", "OPEN_MENU_ITEM"), OPEN_MI_CLASS, true, true);
            if (this.getView() != null) {
                nodeMenuItemDescriptor2.setCargo(this.getView());
            } else {
                nodeMenuItemDescriptor2.setCargo((Serializable)((Object)this.getHtmlFile()));
            }
            nodeMenuItemDescriptorList.addElement(nodeMenuItemDescriptor2);
        }
        if ((n = this.getCurrentStatus()) == 1) {
            serializable = new NodeMenuItemDescriptor(this.mt.get("Start Service", "STARTSVC_MENU_ITEM"), BASE_MI_CLASS, true);
            ((NodeMenuItemDescriptor)serializable).setCargo(new Integer(301));
            nodeMenuItemDescriptorList.addElement(serializable);
        }
        if (n == 3) {
            serializable = new NodeMenuItemDescriptor(this.mt.get("Stop Service", "STOPSVC_MENU_ITEM"), BASE_MI_CLASS, true);
            ((NodeMenuItemDescriptor)serializable).setCargo(new Integer(302));
            nodeMenuItemDescriptorList.addElement(serializable);
            serializable = new NodeMenuItemDescriptor(this.mt.get("Pause Service", "PAUSESVC_MENU_ITEM"), BASE_MI_CLASS, true);
            ((NodeMenuItemDescriptor)serializable).setCargo(new Integer(303));
            nodeMenuItemDescriptorList.addElement(serializable);
        }
        if (n == 7) {
            serializable = new NodeMenuItemDescriptor(this.mt.get("Resume Service", "RESUMESVC_MENU_ITEM"), BASE_MI_CLASS, true);
            ((NodeMenuItemDescriptor)serializable).setCargo(new Integer(304));
            nodeMenuItemDescriptorList.addElement(serializable);
        }
        if ((serializable = this.getParameterSet()) != null) {
            string = serializable.getClass().getName();
            nodeMenuItemDescriptor = new NodeMenuItemDescriptor(this.mt.get("Paste", "PASTE_MENU_ITEM"), PASTE_MI_CLASS, true);
            nodeMenuItemDescriptor.setCargo((Serializable)((Object)string));
            nodeMenuItemDescriptorList.addElement(nodeMenuItemDescriptor);
        }
        if (this.getHelpProperties() != null && (string = (String)((Hashtable)this.getHelpProperties()).get("Contents")) != null) {
            nodeMenuItemDescriptor = new NodeMenuItemDescriptor(this.mt.get("Help", "HELP_MENU_ITEM"), HELP_MI_CLASS, true);
            nodeMenuItemDescriptor.setCargo((Serializable)((Object)string));
            nodeMenuItemDescriptorList.addElement(nodeMenuItemDescriptor);
        }
        return nodeMenuItemDescriptorList;
    }

    public NodeMenuItemDescriptorList getMenuItemDescriptors() {
        if (super.getMenuItemDescriptors() != null) {
            return super.getMenuItemDescriptors();
        }
        this.setMenuItemDescriptors(this.getMenuItems());
        return super.getMenuItemDescriptors();
    }

    public String getNewIcon() {
        int n = this.getCurrentStatus();
        String string = "servicUn.gif";
        System.out.println("BaseDaemon, " + this.getUniqueName() + ", Status = " + n);
        if (n == 10) {
            string = "servicUn.gif";
        } else if (n == 3) {
            string = "serviceU.gif";
        } else if (n == 7) {
            string = "serviceP.gif";
        } else if (n == 1) {
            string = "serviceD.gif";
        }
        return "/com/ibm/eNetwork/onDemand/config/images/" + string;
    }

    public String getLabel() {
        return this.DisplayableName;
    }

    public String getUniqueName() {
        if (this.currentHost != null) {
            return String.valueOf(this.currentHost.getUniqueName()) + "\u00a7" + this.getClass().getName();
        }
        return this.getClass().getName();
    }

    public void setLabel(String string) {
        this.DisplayableName = string;
    }

    public BaseDaemon() {
        this.setComparator(new DaemonComparator());
    }

    public void setNodeMgr(NodeMgr nodeMgr) {
        super.setNodeMgr(nodeMgr);
        if (nodeMgr != null) {
            if (nodeMgr.getMsgTranslator() != null) {
                this.mt = nodeMgr.getMsgTranslator();
            }
            if (nodeMgr.getLog() != null) {
                this.log = nodeMgr.getLog();
            }
        }
    }

    public ServiceHandler getServiceHandler() {
        return this.ServiceHandler;
    }

    public void setServiceHandler(ServiceHandler serviceHandler) {
        this.ServiceHandler = serviceHandler;
    }

    public String getIcon() {
        if (super.getIcon() != null) {
            return super.getIcon();
        }
        this.setIcon(this.getNewIcon());
        return super.getIcon();
    }

    public void refreshStatus() {
        new statusThread().start();
    }

    public Node getParent() {
        return this.getHost();
    }

    public Host getHost() {
        return this.currentHost;
    }

    public String getHostUniqueName() {
        if (this.currentHost instanceof Node) {
            return this.currentHost.getUniqueName();
        }
        return null;
    }

    private String getHostName() {
        if (this.currentHost != null) {
            return this.currentHost.getLabel();
        }
        return "";
    }

    public void setHost(Host host) {
        this.currentHost = host;
        this.debug.print("setHost. Setting node to :" + this.currentHost.getClass().getName());
        this.initParameterSets();
        this.refreshStatus();
        this.setIcon(this.getNewIcon());
        this.setMenuItemDescriptors(this.getMenuItems());
    }

    public void startDaemon() {
        if (this.ServiceHandler != null) {
            this.log.traceMessage(String.valueOf(this.getUniqueName()) + " being started");
            this.log.info("CFW8001I", this.getLabel(), this.getHostName());
            this.ServiceHandler.start();
        }
        this.refreshStatus();
    }

    public void stopDaemon() {
        if (this.ServiceHandler != null) {
            this.log.traceMessage(String.valueOf(this.getUniqueName()) + " being stopped");
            this.log.info("CFW8002I", this.getLabel(), this.getHostName());
            this.ServiceHandler.stop();
        }
        this.refreshStatus();
    }

    public void pauseDaemon() {
        if (this.ServiceHandler != null) {
            this.log.traceMessage(String.valueOf(this.getUniqueName()) + " being paused");
            this.log.info("CFW8003I", this.getLabel(), this.getHostName());
            this.ServiceHandler.pause();
        }
        this.refreshStatus();
    }

    public void resumeDaemon() {
        if (this.ServiceHandler != null) {
            this.log.traceMessage(String.valueOf(this.getUniqueName()) + " being resumed");
            this.log.info("CFW8004I", this.getLabel(), this.getHostName());
            this.ServiceHandler.resume();
        }
        this.refreshStatus();
    }

    public void restartDaemon() {
        this.stopDaemon();
        this.startDaemon();
    }

    public boolean canUpdateWhileActive() {
        return false;
    }

    public int getCurrentStatus() {
        return this.CurrentStatus;
    }

    public void setCurrentStatus(int n) {
        this.CurrentStatus = n;
        this.setMenuItemDescriptors(this.getMenuItems());
        this.setIcon(this.getNewIcon());
    }

    public ParameterSet getParameterSet() {
        return this.CurrentParameterSet;
    }

    public void setParameterSet(ParameterSet parameterSet) {
        if (this.currentHost != null) {
            this.debugmsg("setParameterSet currentHost=" + this.currentHost.getClass().getName());
            ParameterSet parameterSet2 = parameterSet;
            ParameterSet parameterSet3 = this.getParameterSet();
            if (parameterSet2 != null && parameterSet3 != null) {
                Enumeration enumeration = VectorX.getChangedFields(parameterSet2, parameterSet3);
                if (enumeration != null) {
                    if (enumeration.hasMoreElements()) {
                        this.currentHost.auditTrail(this.getUniqueName());
                        this.debugmsg("Enumerating changed fields.");
                        while (enumeration.hasMoreElements()) {
                            String[] stringArray = (String[])enumeration.nextElement();
                            this.debugmsg("Caliing audit trail with parms: " + this.getUniqueName() + "," + stringArray[0] + "," + stringArray[1] + "," + stringArray[2]);
                            this.currentHost.auditTrail(this.getUniqueName(), stringArray[0], stringArray[1], stringArray[2]);
                        }
                    } else {
                        this.debugmsg("No field changes detected.");
                    }
                }
                try {
                    parameterSet3 = (ParameterSet)parameterSet2.clone();
                    return;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    return;
                }
            }
            this.debugmsg("!" + (parameterSet2 == null ? "newps" : (parameterSet3 == null ? "oldps" : "fieldEnum")) + " was null");
            return;
        }
        this.debugmsg("Called 'engage' with " + (this.currentHost == null ? "currentHost==null" : "PS unchanged."));
    }

    public URL getDefaultView() {
        if (this.getHost() == null) {
            return null;
        }
        Host host = this.getHost();
        try {
            URL uRL = new URL("http", host.getInetAddr().getHostAddress(), host.getPort(), "/" + this.getHtmlFile());
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public URL getView() {
        return null;
    }

    public String getHtmlFile() {
        return "logo.html";
    }

    public Properties getHelpProperties() {
        Properties properties = new Properties();
        return properties;
    }

    public boolean isValid(ParameterSet parameterSet) {
        return true;
    }

    public boolean isValidatable() {
        return this.getParameterSet() != null;
    }

    public boolean inDaemonList() {
        return true;
    }

    public Object performOperation(int n, Object object) {
        switch (n) {
            case 1: {
                if (object.equals(new Integer(301))) {
                    this.startDaemon();
                }
                if (object.equals(new Integer(302))) {
                    this.stopDaemon();
                }
                if (object.equals(new Integer(303))) {
                    this.pauseDaemon();
                }
                if (!object.equals(new Integer(304))) break;
                this.resumeDaemon();
                break;
            }
            case 306: {
                ClipBoardObject clipBoardObject = (ClipBoardObject)object;
                NodeParameterSet nodeParameterSet = (NodeParameterSet)this.getNodeByUniqueName(clipBoardObject.NodeName);
                if (nodeParameterSet == null) break;
                try {
                    ParameterSet parameterSet = (ParameterSet)nodeParameterSet.getParameterSet().clone();
                    parameterSet.setLabel(clipBoardObject.Label);
                    this.addParameterSet(parameterSet);
                    return new Boolean(true);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    break;
                }
            }
            case 101: {
                return this.getView();
            }
            case 102: {
                return this.getHelpProperties();
            }
            case 103: {
                return this.getParameterSet();
            }
            case 104: {
                this.setParameterSet((ParameterSet)object);
                return null;
            }
            case 105: {
                return new Boolean(this.isValid((ParameterSet)object));
            }
            case 106: {
                return new Boolean(this.isValidatable());
            }
            case 107: {
                return new Boolean(this.inDaemonList());
            }
            case 108: {
                return new Boolean(this.canUpdateWhileActive());
            }
            case 109: {
                return this.getHostUniqueName();
            }
            case 310: {
                return new Integer(this.getCurrentStatus());
            }
            case 311: {
                this.restartDaemon();
                break;
            }
            case 313: {
                this.addParameterSet((ParameterSet)object);
                break;
            }
            case 312: {
                this.activateParameterSet((ParameterSet)object);
                break;
            }
            case 314: {
                return new Boolean(this.doesParameterSetNameExist((String)object));
            }
            default: {
                return null;
            }
        }
        return null;
    }

    public void startTrace() {
        this.setTraceStatus(true);
    }

    public void stopTrace() {
        this.setTraceStatus(false);
    }

    public boolean getTraceStatus() {
        return this.TraceStatus;
    }

    public void setTraceStatus(boolean bl) {
        this.TraceStatus = bl;
    }

    private void debugmsg(String string) {
        if (this.dbg) {
            System.out.println("[BASEDAEMON]: " + string);
        }
    }

    private void initParameterSets() {
        boolean bl = false;
        this.parameterSetList = new Vector();
        this.activePSIdx = -1;
        Properties properties = this.anm.getSystemProperties();
        if (properties == null) {
            this.anm.addPropertyChangeListener(this);
            return;
        }
        String string = UNKNOWN_HOST_ID;
        if (this.getHost().getInetAddr() != null) {
            string = this.getHost().getInetAddr().getHostAddress();
        }
        String string2 = properties.getProperty(String.valueOf(string) + HOST_DAEMON_DELIMITER + this.getClass().getName());
        ParameterSet parameterSet = this.getParameterSet();
        if (parameterSet != null) {
            parameterSet.setLabel(this.mt.get("Current Configuration", "CURR_CONFIG_NAME"));
            parameterSet.setActive(true);
        }
        if (string2 != null && !string2.equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
            while (stringTokenizer.hasMoreElements()) {
                String string3 = (String)stringTokenizer.nextElement();
                Object object = ObjectStringer.getObject(string3);
                if (!(object instanceof ParameterSet)) continue;
                ParameterSet parameterSet2 = (ParameterSet)object;
                parameterSet2.setSaveable(true);
                this.parameterSetList.addElement(parameterSet2);
                this.debug.print("found a parameter set :" + parameterSet2.getLabel());
                String string4 = parameterSet2.getLabel();
                parameterSet2.setLabel(parameterSet.getLabel());
                if (parameterSet.equals(parameterSet2) && this.activePSIdx == -1) {
                    System.out.println("Found Active PS" + parameterSet2);
                    parameterSet = parameterSet2;
                    bl = true;
                    parameterSet2.setActive(true);
                    this.activePSIdx = this.parameterSetList.indexOf(parameterSet2);
                    if (this.isValid(parameterSet2)) {
                        parameterSet2.setValid(true);
                    } else {
                        parameterSet2.setValid(false);
                    }
                } else {
                    parameterSet2.setActive(false);
                    if (this.isValid(parameterSet2)) {
                        parameterSet2.setValid(true);
                    } else {
                        parameterSet2.setValid(true);
                    }
                }
                parameterSet2.setLabel(string4);
                this.add(new NodeParameterSet(this.getHost(), this, parameterSet2));
            }
        }
        if (parameterSet != null && (this.parameterSetList.size() == 0 || this.activePSIdx == -1)) {
            this.add(new NodeParameterSet(this.getHost(), this, parameterSet));
            this.parameterSetList.addElement(parameterSet);
            if (this.isValid(parameterSet)) {
                parameterSet.setValid(true);
            } else {
                parameterSet.setValid(false);
            }
            this.activePSIdx = this.parameterSetList.indexOf(parameterSet);
            parameterSet.setSaveable(false);
        }
    }

    public void addParameterSet(ParameterSet parameterSet) {
        if (this.isValid(parameterSet)) {
            parameterSet.setValid(true);
        } else {
            parameterSet.setValid(false);
        }
        boolean bl = true;
        while (bl) {
            boolean bl2 = false;
            Enumeration enumeration = this.parameterSetList.elements();
            while (enumeration.hasMoreElements()) {
                ParameterSet parameterSet2 = (ParameterSet)enumeration.nextElement();
                if (parameterSet == parameterSet2) {
                    String string = ObjectStringer.putObject(parameterSet);
                    parameterSet = (ParameterSet)ObjectStringer.getObject(string);
                }
                if (!parameterSet2.getLabel().equalsIgnoreCase(parameterSet.getLabel())) continue;
                parameterSet.setLabel(String.valueOf(parameterSet.getLabel()) + "*");
                bl2 = true;
                break;
            }
            if (bl2) continue;
            bl = false;
        }
        parameterSet.setActive(false);
        parameterSet.setSaveable(true);
        super.add(new NodeParameterSet(this.getHost(), this, parameterSet));
        this.parameterSetList.addElement(parameterSet);
        this.saveParameterSets();
    }

    public boolean isParameterSetActive(ParameterSet parameterSet) {
        int n = this.parameterSetList.indexOf(parameterSet);
        return n == this.activePSIdx;
    }

    public void deleteParameterSet(NodeParameterSet nodeParameterSet) {
        ParameterSet parameterSet = nodeParameterSet.getParameterSet();
        if (!this.isParameterSetActive(parameterSet)) {
            super.remove(nodeParameterSet);
            this.parameterSetList.removeElement(parameterSet);
        }
    }

    private NodeParameterSet findNodeParameterSet(ParameterSet parameterSet) {
        Enumeration enumeration = this.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            NodeParameterSet nodeParameterSet;
            Object e = enumeration.nextElement();
            if (!(e instanceof NodeParameterSet) || (nodeParameterSet = (NodeParameterSet)e).getParameterSet() != parameterSet) continue;
            return nodeParameterSet;
        }
        return null;
    }

    public void activateParameterSet(ParameterSet parameterSet) {
        int n = this.parameterSetList.indexOf(parameterSet);
        if (n == -1) {
            this.addParameterSet(parameterSet);
            n = this.parameterSetList.indexOf(parameterSet);
        }
        ParameterSet parameterSet2 = (ParameterSet)this.parameterSetList.elementAt(this.activePSIdx);
        NodeParameterSet nodeParameterSet = this.findNodeParameterSet(parameterSet2);
        NodeParameterSet nodeParameterSet2 = this.findNodeParameterSet(parameterSet);
        parameterSet2.setActive(false);
        if (nodeParameterSet != null) {
            nodeParameterSet.setActive(false);
        }
        this.activePSIdx = n;
        parameterSet.setActive(true);
        if (nodeParameterSet2 != null) {
            nodeParameterSet2.setActive(true);
        }
        if (this.isValid(parameterSet)) {
            parameterSet.setValid(true);
        } else {
            parameterSet.setValid(false);
        }
        this.setParameterSet(parameterSet);
        this.setChildren(this.getChildren());
    }

    public boolean doesParameterSetNameExist(String string) {
        boolean bl = false;
        Enumeration enumeration = this.parameterSetList.elements();
        while (enumeration.hasMoreElements()) {
            ParameterSet parameterSet = (ParameterSet)enumeration.nextElement();
            if (!parameterSet.getLabel().equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void saveParameterSets() {
        this.writeParameterSets();
        this.anm.saveSystemProperties();
    }

    public void writeParameterSets() {
        Object object;
        Properties properties = this.anm.getSystemProperties();
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.parameterSetList.elements();
        while (enumeration.hasMoreElements()) {
            object = (ParameterSet)enumeration.nextElement();
            if (((ParameterSet)object).getSaveable()) {
                stringBuffer.append(String.valueOf(ObjectStringer.putObject((Serializable)object)) + ":");
                continue;
            }
            System.out.println(String.valueOf(((ParameterSet)object).getLabel()) + " was not Saveable");
        }
        object = UNKNOWN_HOST_ID;
        if (this.getHost().getInetAddr() != null) {
            object = this.getHost().getInetAddr().getHostAddress();
        }
        ((Hashtable)properties).put(String.valueOf(object) + HOST_DAEMON_DELIMITER + this.getClass().getName(), stringBuffer.toString());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.anm && propertyChangeEvent.getPropertyName().equals("server Profile")) {
            this.initParameterSets();
            this.anm.removePropertyChangeListener(this);
        }
    }

    class statusThread
    extends Thread {
        public statusThread() {
            BaseDaemon.this = BaseDaemon.this;
            this.setName("BaseDaemon.status");
        }

        public void run() {
            if (BaseDaemon.this.ServiceHandler != null) {
                int n = 1;
                while (n < 3) {
                    BaseDaemon.this.log.traceMessage("Querying status. i=" + n, 3);
                    BaseDaemon.this.setCurrentStatus(BaseDaemon.this.ServiceHandler.query());
                    try {
                        BaseDaemon.this.log.traceMessage("Sleeping(2000)", 3);
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        BaseDaemon.this.log.traceMessage("Sleep interrupted", 3);
                    }
                    ++n;
                }
            }
        }
    }

    public class DaemonComparator
    implements Comparator {
        Comparator defaultComparator = new DefaultComparator();

        public int compare(Object object, Object object2) {
            int n = -1;
            int n2 = 1;
            if (object instanceof NodeParameterSet) {
                if (object2 instanceof NodeParameterSet) {
                    if (((NodeParameterSet)object).getParameterSet().getActive()) {
                        return n;
                    }
                    if (((NodeParameterSet)object2).getParameterSet().getActive()) {
                        return n2;
                    }
                    return this.defaultComparator.compare(object, object2);
                }
                return n;
            }
            if (object2 instanceof NodeParameterSet) {
                return n2;
            }
            return this.defaultComparator.compare(object, object2);
        }

        public DaemonComparator() {
            BaseDaemon.this = BaseDaemon.this;
        }
    }
}

