/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.config.agents;

import com.ibm.eNetwork.onDemand.common.Copyright;
import com.ibm.eNetwork.onDemand.config.agents.Daemon;
import com.ibm.eNetwork.onDemand.config.agents.DaemonThread;
import com.ibm.eNetwork.onDemand.config.agents.Detector;
import com.ibm.eNetwork.onDemand.config.nls.MsgTranslator;
import com.ibm.eNetwork.onDemand.config.util.Debug;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Properties;
import java.util.Vector;

public class BaseDetector
implements Detector,
PropertyChangeListener {
    Vector startedDaemons;
    Vector loadedDaemons;
    private static final String cStmt1 = Copyright.COPYRIGHT_98;
    public static final String THREADDAEMON_ADDED = "ThreadDaemonAdded";
    public static final String THREADLIST_COMPLETE = "ThreadDaemonListComplete";
    Debug debug = new Debug("BaseDetector");
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    MsgTranslator mt;

    public BaseDetector() {
        this.startedDaemons = new Vector();
        this.loadedDaemons = new Vector();
        this.pcs.addPropertyChangeListener(this);
    }

    public void setProperties(Properties properties) {
    }

    public int getNumberOfDaemons() {
        return this.loadedDaemons.size() + this.startedDaemons.size();
    }

    private Daemon startDaemon(String string) {
        if (string == null) {
            return null;
        }
        try {
            return (Daemon)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.pcs.firePropertyChange("LogAMessage", classNotFoundException.getMessage(), "CFW2001E");
        }
        catch (Exception exception) {
            this.pcs.firePropertyChange("LogAMessage", exception.getMessage(), "CFW2003E");
        }
        return null;
    }

    public Daemon getDaemon(String string) {
        Daemon daemon;
        int n = 0;
        while (n < this.startedDaemons.size()) {
            daemon = (Daemon)this.startedDaemons.elementAt(n);
            if (string.equals(daemon.getClass().getName())) {
                return daemon;
            }
            ++n;
        }
        if (this.loadedDaemons.contains(string) && (daemon = this.startDaemon(string)) != null) {
            this.startedDaemons.addElement(daemon);
            this.loadedDaemons.removeElement(string);
            return daemon;
        }
        return null;
    }

    public void getDaemons() {
        DaemonThread daemonThread = new DaemonThread(this.loadedDaemons, this.pcs);
        daemonThread.start();
    }

    public boolean isDaemonInstalled(String string) {
        if (this.loadedDaemons.contains(string)) {
            return true;
        }
        int n = 0;
        while (n < this.startedDaemons.size()) {
            Daemon daemon = (Daemon)this.startedDaemons.elementAt(n);
            if (string.equals(daemon.getClass().getName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(THREADDAEMON_ADDED)) {
            Daemon daemon = (Daemon)propertyChangeEvent.getNewValue();
            this.startedDaemons.addElement(daemon);
            this.loadedDaemons.removeElement(daemon.getClass().getName());
            this.pcs.firePropertyChange("New_Daemon", null, daemon);
        }
        if (propertyChangeEvent.getPropertyName().equals(THREADLIST_COMPLETE)) {
            this.pcs.firePropertyChange("DaemonListComplete", new Integer(1), new Integer(0));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void setMsgTranslator(MsgTranslator msgTranslator) {
        this.mt = msgTranslator;
    }

    public MsgTranslator getMsgTranslator() {
        return this.mt;
    }
}

