/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.config.agents;

import com.ibm.eNetwork.onDemand.common.BaseDirectory;
import com.ibm.eNetwork.onDemand.config.agents.AgentsNodeMgr;
import com.ibm.eNetwork.onDemand.config.agents.Daemon;
import com.ibm.eNetwork.onDemand.config.agents.DaemonList;
import com.ibm.eNetwork.onDemand.config.agents.Host;
import com.ibm.eNetwork.onDemand.config.agents.ParameterSet;
import com.ibm.eNetwork.onDemand.config.nls.MsgTranslator;
import com.ibm.eNetwork.onDemand.config.node.BaseNode;
import com.ibm.eNetwork.onDemand.config.node.NodeMgr;
import com.ibm.eNetwork.onDemand.config.util.Debug;
import com.ibm.eNetwork.onDemand.config.util.Log;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BaseHost
extends BaseNode
implements Host,
PropertyChangeListener {
    private static final String copyright = null;
    Log log;
    boolean dbg = false;
    AgentsNodeMgr anm = AgentsNodeMgr.getAgentsNodeMgr();
    MsgTranslator mt;
    private boolean auditTrailEnabled;
    private static String DO_NOT_TRACE = "Ixnay on the acetray";
    DaemonList dl;
    Debug debug = new Debug("BaseHost");
    Thread DaemonListMonitor;
    BaseDirectory basedir = new BaseDirectory();
    Hashtable daemonList = new Hashtable();
    private String hostname = "unknownHost";
    private boolean nodeIsLocked = false;
    private int lastRC;
    private String username;
    private String password;
    private InetAddress addr;
    private int port;
    private boolean Local = false;
    private boolean daemonListCreated = false;

    public BaseHost(NodeMgr nodeMgr, Daemon daemon) {
        Serializable serializable;
        this.setNodeMgr(nodeMgr);
        this.log = nodeMgr.getLog();
        this.mt = nodeMgr.getMsgTranslator();
        this.dl = new DaemonList(this.log, this.mt);
        try {
            serializable = InetAddress.getLocalHost();
            this.setName(((InetAddress)serializable).getHostName());
        }
        catch (UnknownHostException unknownHostException) {}
        this.dl.addPropertyChangeListener(this);
        if (daemon == null) {
            serializable = this.getDaemonList();
            Enumeration enumeration = ((Vector)serializable).elements();
            while (enumeration.hasMoreElements()) {
                this.addDaemon((Daemon)enumeration.nextElement());
            }
            return;
        }
        this.addDaemon(daemon);
    }

    public BaseHost(NodeMgr nodeMgr) {
        this(nodeMgr, null);
    }

    public BaseHost(Daemon daemon) {
        this(null, daemon);
    }

    public BaseHost() {
        this(null, null);
    }

    public void setNodeMgr(NodeMgr nodeMgr) {
        super.setNodeMgr(nodeMgr);
        if (nodeMgr != null) {
            this.mt = nodeMgr.getMsgTranslator();
        }
    }

    public String getLabel() {
        return this.getName();
    }

    public String getUniqueName() {
        return this.getInetAddr().getHostAddress();
    }

    public Daemon getDaemon(String string) {
        if (this.daemonList != null && this.daemonList.get(string) != null) {
            DaemonListElement daemonListElement = (DaemonListElement)this.daemonList.get(string);
            return daemonListElement.daemon;
        }
        if (!this.daemonListCreated) {
            this.getDaemonListRightNow();
            return this.getDaemon(string);
        }
        return null;
    }

    public Vector getDaemonListRightNow() {
        this.getDaemonList();
        while (this.dl.getInProcess()) {
            try {
                Thread.sleep(1000L);
                this.debug.print("Waiting for DeamonList");
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        return this.getDaemonList();
    }

    public synchronized Vector getDaemonList() {
        int n;
        Vector<Daemon> vector = new Vector<Daemon>();
        if (!this.daemonListCreated) {
            this.daemonListCreated = true;
            this.dl.getDaemonList();
        }
        if ((n = this.getNumberOfDaemons()) > 0) {
            Enumeration enumeration = this.daemonList.elements();
            vector = new Vector();
            int n2 = 0;
            while (n2 < n) {
                DaemonListElement daemonListElement = (DaemonListElement)enumeration.nextElement();
                if (daemonListElement.daemon.inDaemonList()) {
                    vector.addElement(daemonListElement.daemon);
                }
                ++n2;
            }
        }
        return vector;
    }

    public int getNumberOfDaemons() {
        if (!this.daemonListCreated) {
            this.daemonListCreated = true;
            this.dl.getDaemonList();
        }
        int n = this.daemonList.size();
        return n;
    }

    public boolean addDaemon(Daemon daemon) {
        boolean bl = true;
        if (daemon.inDaemonList()) {
            super.add(daemon);
        }
        daemon.setNodeMgr(this.getNodeMgr());
        daemon.setHost(this);
        return bl;
    }

    public synchronized boolean removeDaemon(Daemon daemon) {
        boolean bl = true;
        if (daemon.inDaemonList()) {
            super.remove(daemon);
        }
        return bl;
    }

    public String getName() {
        return this.hostname;
    }

    public void setName(String string) {
        this.log.traceMessage("setName(" + string + ")");
        this.hostname = string;
    }

    public String getInstalledDirectory() {
        try {
            return BaseDirectory.getConfigBaseDirectory();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean isDaemonInstalled(String string) {
        return true;
    }

    public boolean isFileValid(String string) {
        boolean bl = true;
        File file = new File(string);
        bl = file.exists() && file.isFile();
        return bl;
    }

    public boolean isDirectoryValid(String string) {
        boolean bl = true;
        File file = new File(string);
        bl = file.exists() && file.isDirectory();
        return bl;
    }

    public InetAddress getInetAddr() {
        try {
            this.addr = InetAddress.getByName(this.getName());
        }
        catch (UnknownHostException unknownHostException) {
            this.addr = null;
        }
        return this.addr;
    }

    public int getPort() {
        return -1;
    }

    public boolean isLocal() {
        return true;
    }

    public String getInstalledDirectory(String string) {
        return "";
    }

    public void refresh() {
        new refreshThread().start();
    }

    public boolean isParameterSetActive(Daemon daemon, ParameterSet parameterSet) {
        DaemonListElement daemonListElement = (DaemonListElement)this.daemonList.get(daemon.getClass().getName());
        if (daemonListElement.activePSIdx == -1) {
            return false;
        }
        ParameterSet parameterSet2 = (ParameterSet)daemonListElement.parameterSetList.elementAt(daemonListElement.activePSIdx);
        return parameterSet2.equals(parameterSet);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.debug.print("propertyChange " + propertyChangeEvent.getPropertyName() + propertyChangeEvent.getNewValue());
        if (propertyChangeEvent.getSource() == this.dl) {
            Object object;
            if (propertyChangeEvent.getPropertyName() == "DaemonAdded" && (object = propertyChangeEvent.getNewValue()) instanceof Daemon) {
                this.addDaemon((Daemon)object);
            }
            if (propertyChangeEvent.getPropertyName() == "DaemonListComplete" && this.DaemonListMonitor != null) {
                this.DaemonListMonitor.resume();
            }
        }
    }

    public void auditTrail(String string) {
        if (this.dbg) {
            System.out.println("BaseHost Making audit trail call 1");
        }
        this.auditTrail(string, "", "", "");
    }

    public void auditTrail(String string, String string2, String string3, String string4) {
        String string5;
        if (this.dbg) {
            System.err.println("NTServerNode: In localAuditTrail");
        }
        if (!this.auditTrailEnabled) {
            return;
        }
        String string6 = ": ";
        String string7 = ".";
        String string8 = "CFW8011I";
        String string9 = "CFW8012I";
        String string10 = "CFW8012I";
        if (string2.length() == 0) {
            string2 = null;
        }
        if (string3.length() == 0) {
            string3 = null;
        }
        if (string4.length() == 0) {
            string4 = null;
        }
        if (string4 == null) {
            string2 = null;
        }
        if (string == null || string.length() == 0) {
            return;
        }
        if (string2 != null) {
            if (!(string2 = this.translate(string2, true)).equals(DO_NOT_TRACE)) {
                string4 = this.translate(string4, false);
                String string11 = "Parameter " + string + string7 + string2 + " changed from " + string3 + " to " + string4;
                if ((string3 = this.translate(string3, false)) != null) {
                    string5 = String.valueOf(string10) + string6;
                    if (this.mt != null) {
                        if (this.dbg) {
                            System.err.println("NTServerNode: Getting message 3.");
                        }
                        String[] stringArray = new String[]{String.valueOf(string) + string7 + string2, string3, string4};
                        string5 = String.valueOf(string5) + this.mt.get(string11, string10, stringArray);
                    } else {
                        string5 = String.valueOf(string5) + string11;
                    }
                } else {
                    string5 = String.valueOf(string9) + string6;
                    if (this.mt != null) {
                        if (this.dbg) {
                            System.err.println("NTServerNode: Getting message 2.");
                        }
                        String[] stringArray = new String[]{String.valueOf(string) + string7 + string2, string3, string4};
                        string5 = String.valueOf(string5) + this.mt.get(string11, string9, stringArray);
                    } else {
                        string5 = String.valueOf(string5) + string11;
                    }
                }
            } else {
                string5 = null;
                if (this.dbg) {
                    System.err.println("Parm " + string2 + " not parsed -- not in catalog.");
                }
            }
        } else {
            String string12 = "The active parameter set for service " + string + " has been changed.";
            string5 = String.valueOf(string8) + string6;
            if (this.mt != null) {
                if (this.dbg) {
                    System.err.println("NTServerNode: Getting message 1.");
                }
                String[] stringArray = new String[]{string};
                string5 = String.valueOf(string5) + this.mt.get(string12, string8, stringArray);
            } else {
                string5 = String.valueOf(string5) + string12;
            }
        }
        if (string5 != null) {
            this.logMessage(string5);
        }
    }

    private String translate(String string, boolean bl) {
        String string2 = null;
        if (string != null && string.length() > 0) {
            if (string.equals("NULL_OBJECT")) {
                String string3 = string;
                string2 = this.mt.get("Null object", string3);
            } else if (string.equals("OBJECTS_DIFFER")) {
                String string4 = string;
                string2 = this.mt.get("Objects differ", string4);
            } else if (string.equals("NULL")) {
                String string5 = string;
                string2 = this.mt.get("Null", string5);
            } else if (string.equals("INACCESSIBLE")) {
                String string6 = string;
                string2 = this.mt.get("Inaccessible", string6);
            } else if (string.startsWith("SIZE_EQUALS")) {
                String string7 = string.substring("SIZE_EQUALS".length());
                String string8 = "SIZE_EQUALS";
                string2 = String.valueOf(this.mt.get("Size = ", string8)) + string7;
            } else if (bl) {
                String string9 = "PSFIELD_" + string;
                string2 = this.mt.get(DO_NOT_TRACE, string9);
            } else {
                string2 = string;
            }
        }
        if (string2 == null) {
            return this.mt.get("Null", "NULL");
        }
        return string2;
    }

    private void logMessage(String string) {
        if (this.dbg) {
            System.err.println("NTServerNode: Logging message" + string);
        }
        System.err.println(string);
    }

    public void setAuditTrailEnabled(boolean bl) {
        this.auditTrailEnabled = bl;
    }

    public boolean getAuditTrailEnabled() {
        return this.auditTrailEnabled;
    }

    public String normalizePathName(String string) {
        String string2;
        if (string != null) {
            string2 = string.trim().replace('/', '\\').toLowerCase();
            if (string2.endsWith("\\")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        } else {
            string2 = "";
        }
        return string2;
    }

    public Object performOperation(int n, Object object) {
        if (n == 102) {
            return this.getName();
        }
        if (n == 103) {
            return new Integer(this.getPort());
        }
        if (n == 104) {
            return this.getInstalledDirectory((String)object);
        }
        if (n == 105) {
            return new Boolean(this.isDaemonInstalled((String)object));
        }
        if (n == 106) {
            return new Boolean(this.isFileValid((String)object));
        }
        if (n == 107) {
            return new Boolean(this.isDirectoryValid((String)object));
        }
        if (n == 109) {
            return this.normalizePathName((String)object);
        }
        return null;
    }

    class refreshThread
    extends Thread {
        public refreshThread() {
            BaseHost.this = BaseHost.this;
            this.setName("BaseHost.refresh");
        }

        public void run() {
            BaseHost.this.daemonList = new Hashtable();
            if (BaseHost.this.dl != null) {
                BaseHost.this.dl.removePropertyChangeListener(BaseHost.this);
            }
            BaseHost.this.dl = new DaemonList(BaseHost.this.log, BaseHost.this.mt);
            BaseHost.this.dl.addPropertyChangeListener(BaseHost.this);
            BaseHost.this.dl.getDaemonList();
        }
    }

    class DaemonListElement {
        public Daemon daemon;
        public Vector parameterSetList;
        public int activePSIdx = -1;

        DaemonListElement() {
            BaseHost.this = BaseHost.this;
        }
    }
}

