/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.config.agents;

import com.ibm.eNetwork.onDemand.common.BaseDirectory;
import com.ibm.eNetwork.onDemand.config.agents.Daemon;
import com.ibm.eNetwork.onDemand.config.agents.Detector;
import com.ibm.eNetwork.onDemand.config.nls.MsgTranslator;
import com.ibm.eNetwork.onDemand.config.util.Debug;
import com.ibm.eNetwork.onDemand.config.util.Log;
import com.ibm.eNetwork.onDemand.config.util.LogStub;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.Vector;

public class DaemonList
implements PropertyChangeListener {
    private static final String cStmt1 = null;
    public static final String DAEMON_ADDED = "DaemonAdded";
    public static final String NEW_DAEMON = "New_Daemon";
    public static final String LOG_MESSAGE = "LogAMessage";
    public static final String LIST_COMPLETE = "DaemonListComplete";
    private static final String PROPERTY_FILENAME = "config.properties";
    private Vector detectorList = new Vector();
    private Vector dupDetectorList;
    private Vector startedDaemons = new Vector();
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean stillWorking = false;
    private Log log = new LogStub();
    Debug debug = new Debug("DaemonList", true);
    BaseDirectory basedir = new BaseDirectory();
    MsgTranslator mt;

    public DaemonList(Log log, MsgTranslator msgTranslator) {
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        int n2 = 0;
        this.mt = msgTranslator;
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        FileInputStream fileInputStream = null;
        FileInputStream fileInputStream2 = null;
        this.debug.print("Entry to DaemonList");
        if (log != null) {
            this.log = log;
        }
        this.pcs.addPropertyChangeListener(this);
        try {
            string = BaseDirectory.getConfigBaseDirectory();
            string3 = BaseDirectory.getOSName();
            fileInputStream = new FileInputStream(new File(String.valueOf(string) + PROPERTY_FILENAME));
        }
        catch (Exception exception) {
            this.debug.print("Could not open " + string + PROPERTY_FILENAME);
            this.log.error("CFW2005E", String.valueOf(string) + PROPERTY_FILENAME);
        }
        if (fileInputStream != null) {
            try {
                String string4;
                Detector detector;
                String string5;
                properties.load(fileInputStream);
                string2 = properties.getProperty("DaemonDetector." + string3 + ".num");
                this.debug.print("number of " + string3 + " detectors = " + string2);
                if (string2 != null) {
                    n = Integer.parseInt(string2);
                }
                string2 = properties.getProperty("DaemonDetector.num");
                this.debug.print("number of OS independent detectors = " + string2);
                if (string2 != null) {
                    n2 = Integer.parseInt(string2);
                }
                int n3 = 1;
                while (n3 <= n) {
                    string5 = properties.getProperty("DaemonDetector." + string3 + "." + n3);
                    if (string5 != null) {
                        detector = (Detector)Class.forName(string5).newInstance();
                        this.debug.print("Detected class:" + detector);
                        string4 = properties.getProperty("DaemonDetector." + string3 + ".propertyFile." + n3);
                        this.debug.print("properties = " + string4);
                        if (string4 != null) {
                            fileInputStream2 = new FileInputStream(new File(String.valueOf(string) + string4));
                            if (fileInputStream2 != null) {
                                properties2.load(fileInputStream2);
                                detector.setProperties(properties2);
                            } else {
                                detector.setProperties(properties);
                            }
                        } else {
                            detector.setProperties(properties);
                        }
                        detector.setMsgTranslator(msgTranslator);
                        detector.addPropertyChangeListener(this);
                        this.detectorList.addElement(detector);
                    }
                    ++n3;
                }
                int n4 = 1;
                while (n4 <= n2) {
                    string5 = properties.getProperty("DaemonDetector." + n4);
                    if (string5 != null) {
                        detector = (Detector)Class.forName(string5).newInstance();
                        this.debug.print("Detected class:" + detector);
                        string4 = properties.getProperty("DaemonDetector.propertyFile." + n4);
                        this.debug.print("properties = " + string4);
                        if (string4 != null) {
                            fileInputStream2 = new FileInputStream(new File(String.valueOf(string) + string4));
                            this.debug.print("filePropStream = " + fileInputStream2);
                            if (fileInputStream2 != null) {
                                properties2.load(fileInputStream2);
                                detector.setProperties(properties2);
                            } else {
                                detector.setProperties(properties);
                            }
                        } else {
                            detector.setProperties(properties);
                        }
                        detector.setMsgTranslator(msgTranslator);
                        detector.addPropertyChangeListener(this);
                        this.detectorList.addElement(detector);
                    }
                    ++n4;
                }
                this.dupDetectorList = (Vector)this.detectorList.clone();
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.log.error("CFW2001E", classNotFoundException.getMessage());
                return;
            }
            catch (NumberFormatException numberFormatException) {
                this.log.error("CFW2002E", "DaemonDetector");
                return;
            }
            catch (Exception exception) {
                this.log.exception(exception);
                return;
            }
        }
    }

    private Daemon startDaemon(String string) {
        if (string == null) {
            return null;
        }
        try {
            Daemon daemon = (Daemon)Class.forName(string).newInstance();
            this.pcs.firePropertyChange(DAEMON_ADDED, null, daemon);
            return daemon;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log.error("CFW2001E", classNotFoundException.getMessage());
        }
        catch (Exception exception) {
            this.log.exception(exception);
        }
        return null;
    }

    public Daemon getDaemon(String string) {
        Daemon daemon;
        int n = 0;
        while (n < this.startedDaemons.size()) {
            daemon = (Daemon)this.startedDaemons.elementAt(n);
            if (string.equals(daemon.getClass().getName())) {
                return daemon;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.detectorList.size()) {
            Detector detector = (Detector)this.detectorList.elementAt(n2);
            if (detector.isDaemonInstalled(string)) {
                daemon = detector.getDaemon(string);
                this.startedDaemons.addElement(daemon);
                return daemon;
            }
            ++n2;
        }
        return null;
    }

    public boolean getInProcess() {
        this.debug.print("Got " + this.stillWorking);
        return this.stillWorking;
    }

    public void getDaemonList() {
        this.stillWorking = true;
        int n = 0;
        while (n < this.detectorList.size()) {
            Detector detector = (Detector)this.detectorList.elementAt(n);
            detector.getDaemons();
            ++n;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(LOG_MESSAGE)) {
            this.log.error((String)propertyChangeEvent.getNewValue(), (String)propertyChangeEvent.getOldValue());
        }
        if (propertyChangeEvent.getPropertyName().equals(NEW_DAEMON)) {
            Daemon daemon = (Daemon)propertyChangeEvent.getNewValue();
            this.startedDaemons.addElement(daemon);
            this.pcs.firePropertyChange(DAEMON_ADDED, null, daemon);
        }
        if (propertyChangeEvent.getPropertyName().equals(LIST_COMPLETE) && this.dupDetectorList != null) {
            if (this.dupDetectorList.contains(propertyChangeEvent.getSource())) {
                this.dupDetectorList.removeElement(propertyChangeEvent.getSource());
            }
            if (this.dupDetectorList.size() == 0) {
                this.stillWorking = false;
            }
        }
    }
}

