/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.config.agents;

import com.ibm.eNetwork.onDemand.config.agents.AgentsNodeMgr;
import com.ibm.eNetwork.onDemand.config.agents.BaseHost;
import com.ibm.eNetwork.onDemand.config.agents.Host;
import com.ibm.eNetwork.onDemand.config.agents.HostList;
import com.ibm.eNetwork.onDemand.config.node.NodeMgr;
import com.ibm.eNetwork.onDemand.config.util.Log;
import java.applet.Applet;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class EnodHostList
implements HostList,
PropertyChangeListener {
    private static final String copyright = null;
    private String PropSeparator = "/";
    protected Log log;
    private Properties hostProps;
    protected Vector hostList;
    protected int localHostIdx = -1;
    private boolean hostListIsLocked = false;
    private static String DEFAULT_HOST = "Unknown";
    public static final int DEFAULT_PORT = 80;
    private static String DEFAULT_CLASS = "com.ibm.eNetwork.onDemand.config.agents.BaseHost";
    private String localHostName;
    private Applet frame_applet;
    private Host localHost;
    String HostPropertyKeyPrefix = "HostListEntry" + this.PropSeparator;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    AgentsNodeMgr anm = AgentsNodeMgr.getAgentsNodeMgr();

    public EnodHostList() {
        this(null);
    }

    public EnodHostList(NodeMgr nodeMgr) {
        this.log = this.anm.getLog();
        this.localHost = new BaseHost(nodeMgr);
        this.hostProps = this.anm.getSystemProperties();
        if (this.hostProps == null) {
            this.anm.addPropertyChangeListener(this);
        }
        this.rebuild();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void addElement(Host host) {
        String string = host.getClass().getName();
        String string2 = String.valueOf(host.getPort());
        String string3 = String.valueOf(host.getName()) + this.PropSeparator + string2 + this.PropSeparator + string;
        String string4 = String.valueOf(this.HostPropertyKeyPrefix) + host.getName();
        this.hostList.addElement(host);
        if (this.hostProps != null) {
            ((Hashtable)this.hostProps).put(string4, string3);
            this.anm.saveServerProfile();
        }
        this.pcs.firePropertyChange("HostAdded", null, host);
    }

    public void removeElement(Host host) {
        String string = String.valueOf(this.HostPropertyKeyPrefix) + host.getName();
        this.hostList.removeElement(host);
        if (this.hostProps != null) {
            ((Hashtable)this.hostProps).remove(string);
            this.anm.saveServerProfile();
            this.pcs.firePropertyChange("HostRemoved", null, host);
        }
    }

    public void rebuild() {
        this.hostList = new Vector();
        if (this.localHost != null) {
            this.hostList.addElement(this.localHost);
        }
        if (this.hostProps == null) {
            return;
        }
        Enumeration<?> enumeration = this.hostProps.propertyNames();
        int n = this.HostPropertyKeyPrefix.length();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string == null || string.length() < n || !string.substring(0, n).equals(this.HostPropertyKeyPrefix)) continue;
            this.hostProps.getProperty(string);
        }
    }

    public Host getLocalHost() {
        return this.localHost;
    }

    public Vector getHostVector() {
        Vector vector = (Vector)this.hostList.clone();
        return vector;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.anm && propertyChangeEvent.getPropertyName().equals("server Profile")) {
            this.hostProps = this.anm.getSystemProperties();
            this.rebuild();
            this.anm.removePropertyChangeListener(this);
        }
    }
}

