/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.config.agents.NFS;

import com.ibm.eNetwork.onDemand.common.Copyright;
import com.ibm.eNetwork.onDemand.common.nativecode.NTRegistry;
import com.ibm.eNetwork.onDemand.common.nativecode.NTServiceHandler;
import com.ibm.eNetwork.onDemand.common.nativecode.RegistryValue;
import com.ibm.eNetwork.onDemand.config.agents.NFS.NFSDirectory;
import com.ibm.eNetwork.onDemand.config.agents.NFS.NFSParameterSet;
import com.ibm.eNetwork.onDemand.config.agents.NFS.NFSUser;
import com.ibm.eNetwork.onDemand.config.agents.NFS.NFSUserUtil;
import com.ibm.eNetwork.onDemand.config.agents.NTBaseDaemon;
import com.ibm.eNetwork.onDemand.config.agents.NTRegistryUser;
import com.ibm.eNetwork.onDemand.config.agents.ParameterSet;
import com.ibm.eNetwork.onDemand.config.nls.MsgTranslator;
import com.ibm.eNetwork.onDemand.config.node.NodeMgr;
import com.ibm.eNetwork.onDemand.config.util.VectorX;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class NFSDaemon
extends NTBaseDaemon
implements NTRegistryUser {
    private static final String cStmt1 = Copyright.COPYRIGHT_97_98;
    NFSParameterSet cps;
    MsgTranslator mt;
    int m_TraceOption;
    private static String COLON_STR = ":";
    private static String LTS_STR = "<";
    private static String GTS_STR = ">";
    private static String STAR_STR = "*";
    private static String VBAR_STR = "|";
    private static String QUEST_STR = "?";
    private NTServiceHandler pcnfsdServiceDaemon;
    public final Boolean DEFAULT_ENABLE_NT_SECURITY = new Boolean(true);
    public final Boolean DEFAULT_ENABLE_AUTO_ADD_USER = new Boolean(true);
    public final Integer DEFAULT_ACCESS_TIMEOUT = new Integer(3600);
    public final Integer DEFAULT_VALID_TIMEOUT = new Integer(600);
    public final Boolean DEFAULT_ENABLE_TRACE = new Boolean(false);
    public final Integer DEFAULT_TRACE_OPTION = new Integer(0);
    static NFSUserUtil nuu = new NFSUserUtil();
    static NTRegistry ntr = new NTRegistry();
    static final int no_state = 0;
    static final int alias_state = 1;
    static final int rohost_state = 2;
    static final int rwhost_state = 3;
    static final String dquote = "\"";
    static final String Quote = "\"";
    static final String ListDelimiter = ",";
    static final String PARM_KEY = "System\\CurrentControlSet\\Services\\NFSD\\Parameters";
    static final String USER_KEY = "SOFTWARE\\IBM\\eNetwork On-Demand Server\\CurrentVersion\\UserConfig";
    static final String PCNFSD_KEY = "System\\CurrentControlSet\\Services\\PCNFSD\\Parameters";
    static final String TRACE_KEY = "System\\CurrentControlSet\\Services\\NFSD\\Trace";
    static final String SECURITY_NAME = "NFSNTPermissions";
    static final String LOGGING_NAME = "NFSLogLevel";
    static final String AUTO_ADD_NAME = "UserAutoAdd";
    static final String VALIDATE_TIMEOUT_NAME = "UserValidateTMO";
    static final String ACCESS_TIMEOUT_NAME = "UserAccessTMO";
    static final String WEBNFS_INDEX_FILE = "WebNFS_IndexFile";
    static final String RUNNING_AS_SERVICE_NAME = "RunAsSystem";
    static final String TRACE_NAME = "Trace";
    static final String TRACE_OPTIONS_NAME = "TraceOptions";
    static final String TRACE_FILENAME_NAME = "TraceFilePath";
    static VectorX old_user_list = new VectorX();
    String ETC_PATH;
    String DefaultTraceFilename;

    public NFSDaemon() {
        super("NFSD");
        RegistryValue registryValue = new RegistryValue();
        registryValue.Key = "SOFTWARE\\IBM\\eNetwork On-Demand Server\\CurrentVersion";
        registryValue.Name = "ETC";
        registryValue.Type = 4;
        registryValue.Value = null;
        registryValue = ntr.getOneValue(registryValue);
        if (registryValue != null) {
            this.ETC_PATH = this.AliasHash((String)registryValue.Value);
        }
        this.pcnfsdServiceDaemon = new NTServiceHandler("PCNFSD");
    }

    public void setNodeMgr(NodeMgr nodeMgr) {
        super.setNodeMgr(nodeMgr);
        this.mt = nodeMgr.getMsgTranslator();
        this.setLabel(this.mt.get("NFS", "NFS_NAME"));
    }

    private void setPublicDirectory(String string) {
    }

    public void startDaemon() {
        this.pcnfsdServiceDaemon.start();
        super.startDaemon();
    }

    public void stopDaemon() {
        this.pcnfsdServiceDaemon.stop();
        super.stopDaemon();
    }

    public void pauseDaemon() {
        this.pcnfsdServiceDaemon.pause();
        super.pauseDaemon();
    }

    public void resumeDaemon() {
        this.pcnfsdServiceDaemon.resume();
        super.resumeDaemon();
    }

    public int getCurrentStatus() {
        int n;
        int n2 = this.pcnfsdServiceDaemon.query();
        if (n2 == (n = super.getCurrentStatus())) {
            return n;
        }
        if (n == 3) {
            return 1;
        }
        return n;
    }

    public String getHtmlFile() {
        return "nfsd.html";
    }

    public Properties getHelpProperties() {
        Properties properties = new Properties();
        ((Hashtable)properties).put("Contents", "nfsx.htm");
        ((Hashtable)properties).put("Window_Help", "");
        ((Hashtable)properties).put("How_Do_I", "nfsh.htm");
        ((Hashtable)properties).put("Before_You_Start", "nfsb.htm");
        ((Hashtable)properties).put("Window_nfs_settings", "nfs.htm#Service_tab");
        ((Hashtable)properties).put("Window_nfs_dirs", "nfs.htm#Directories_tab");
        ((Hashtable)properties).put("Window_add_dir", "nfs.htm#Directories_tab");
        ((Hashtable)properties).put("Window_edit_dir", "nfs.htm#Directories_tab");
        ((Hashtable)properties).put("Window_hosts", "nfs.htm#NFSD_Allowing_only_specified_hosts");
        ((Hashtable)properties).put("Window_nfs_user", "nfs.htm#Users_tab");
        ((Hashtable)properties).put("Window_nfs_trace", "nfs.htm#Trace_tab");
        return properties;
    }

    public boolean isValid(ParameterSet parameterSet) {
        if (!(parameterSet instanceof NFSParameterSet)) {
            return false;
        }
        NFSParameterSet nFSParameterSet = (NFSParameterSet)parameterSet;
        boolean bl = true;
        int[] nArray = this.isExportDirectoryValid(nFSParameterSet.DirectoryList);
        if (nFSParameterSet.DirectoryList.size() == 0) {
            bl = false;
        }
        if (nArray != null && nArray.length > 0) {
            bl = false;
        }
        if (nFSParameterSet.WebNFSPublicDirectory != null && nFSParameterSet.WebNFSPublicDirectory.length() > 0 && !this.isExportDirectoryValid(nFSParameterSet.WebNFSPublicDirectory)) {
            bl = false;
        }
        if (!this.isnfsPWDValid(nFSParameterSet).booleanValue()) {
            bl = false;
        }
        if (!this.isnfsPWDconfirmValid(nFSParameterSet).booleanValue()) {
            bl = false;
        }
        if (!this.istraceFilenameValid(nFSParameterSet).booleanValue()) {
            bl = false;
        }
        return bl;
    }

    public int getUniqueId() {
        int n = 101;
        while (true) {
            boolean bl = true;
            Enumeration enumeration = this.cps.UserList.elements();
            while (enumeration.hasMoreElements()) {
                if (((NFSUser)enumeration.nextElement()).uid != n) continue;
                bl = false;
                break;
            }
            if (bl) break;
            ++n;
        }
        return n;
    }

    public boolean isIdUnique(int n) {
        Enumeration enumeration = this.cps.UserList.elements();
        while (enumeration.hasMoreElements()) {
            if (((NFSUser)enumeration.nextElement()).uid != n) continue;
            return false;
        }
        return true;
    }

    public Boolean isnfsPWDValid(NFSParameterSet nFSParameterSet) {
        return new Boolean(true);
    }

    public Boolean isnfsPWDconfirmValid(NFSParameterSet nFSParameterSet) {
        if (nFSParameterSet.NFSPasswordConfirm.equals(nFSParameterSet.NFSPassword)) {
            return new Boolean(true);
        }
        return new Boolean(false);
    }

    public Boolean istraceFilenameValid(NFSParameterSet nFSParameterSet) {
        boolean bl = true;
        if (this.getHost() != null) {
            String string = nFSParameterSet.TraceFilename;
            String string2 = string.replace('/', '\\');
            if (string.indexOf("\\") != -1) {
                string2 = string.substring(0, string.lastIndexOf("\\"));
                String string3 = string.substring(string.lastIndexOf("\\") + 1);
                if (string3.trim().equals("")) {
                    return new Boolean(false);
                }
                if (string2.endsWith(":")) {
                    string2 = String.valueOf(string2) + "\\";
                }
                bl = this.getHost().isDirectoryValid(string2);
            } else {
                return new Boolean(false);
            }
        }
        return new Boolean(bl);
    }

    public boolean isDirectorySyntaxCorrect(NFSDirectory nFSDirectory) {
        boolean bl = true;
        String string = nFSDirectory.m_Name;
        if (string == null) {
            bl = false;
        } else {
            string = string.trim();
            int n = string.length();
            int n2 = string.indexOf(COLON_STR);
            if (n == 0 || n2 != -1 && n2 != 1 || string.indexOf(STAR_STR) >= 0 || string.indexOf(QUEST_STR) >= 0 || string.indexOf(VBAR_STR) >= 0 || string.indexOf(LTS_STR) >= 0 || string.indexOf(GTS_STR) >= 0) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isExportDirectoryValid(String string) {
        String[] stringArray = new String[]{string};
        int[] nArray = this.isExportDirectoryValid(stringArray);
        return nArray == null || nArray.length == 0 || nArray[0] != 0;
    }

    public int[] isExportDirectoryValid(String[] stringArray) {
        Object object;
        VectorX vectorX = new VectorX();
        int n = 0;
        while (n < stringArray.length) {
            object = new File(stringArray[n]);
            if (!(((File)object).exists() && ((File)object).isDirectory() && stringArray[n].length() >= 3 && nuu.isDriveExportable(stringArray[n].substring(0, 3)))) {
                vectorX.addElement(new Integer(n));
            }
            ++n;
        }
        object = new int[vectorX.size()];
        int n2 = 0;
        while (n2 < vectorX.size()) {
            object[n2] = (Integer)vectorX.elementAt(n2);
            ++n2;
        }
        return object;
    }

    public int[] isExportDirectoryValid(VectorX vectorX) {
        String[] stringArray = new String[vectorX.size()];
        int n = 0;
        while (n < vectorX.size()) {
            stringArray[n] = ((NFSDirectory)vectorX.elementAt((int)n)).m_Name;
            ++n;
        }
        return this.isExportDirectoryValid(stringArray);
    }

    public ParameterSet getParameterSet() {
        NFSParameterSet nFSParameterSet = new NFSParameterSet();
        nFSParameterSet.EnableNTSecurity = this.load_Boolean_value(PARM_KEY, SECURITY_NAME, nFSParameterSet.EnableNTSecurity);
        nFSParameterSet.LoggingLevel = this.load_Int_value(PARM_KEY, LOGGING_NAME, nFSParameterSet.LoggingLevel);
        String[] stringArray = nuu.getNFSUserData();
        nFSParameterSet.NFSUserID = stringArray[0];
        nFSParameterSet.NFSPasswordConfirm = nFSParameterSet.NFSPassword = stringArray[1];
        nFSParameterSet.WebNFSIndexFile = this.AliasHash(this.load_String_value(PARM_KEY, WEBNFS_INDEX_FILE, nFSParameterSet.WebNFSIndexFile));
        nFSParameterSet.RunningAsService = this.load_Boolean_value(PARM_KEY, RUNNING_AS_SERVICE_NAME, nFSParameterSet.RunningAsService);
        nFSParameterSet.DirectoryList = this.read_exports_file(nFSParameterSet);
        nFSParameterSet.EnableAutoAddUser = this.load_Boolean_value(PCNFSD_KEY, AUTO_ADD_NAME, nFSParameterSet.EnableAutoAddUser);
        nFSParameterSet.ValidTimeout = this.load_Int_value(USER_KEY, VALIDATE_TIMEOUT_NAME, nFSParameterSet.ValidTimeout);
        nFSParameterSet.AccessTimeout = this.load_Int_value(USER_KEY, ACCESS_TIMEOUT_NAME, nFSParameterSet.AccessTimeout);
        nFSParameterSet.UserList = (VectorX)this.getNFSUserList(null);
        nFSParameterSet.EnableTrace = this.load_Boolean_value(TRACE_KEY, TRACE_NAME, nFSParameterSet.EnableTrace);
        nFSParameterSet.TraceOption = this.load_Int_value(TRACE_KEY, TRACE_OPTIONS_NAME, nFSParameterSet.TraceOption);
        nFSParameterSet.TraceFilename = this.AliasHash(this.load_String_value(TRACE_KEY, TRACE_FILENAME_NAME, nFSParameterSet.TraceFilename));
        return nFSParameterSet;
    }

    public void setParameterSet(ParameterSet parameterSet) {
        if (!(parameterSet instanceof NFSParameterSet)) {
            return;
        }
        NFSParameterSet nFSParameterSet = (NFSParameterSet)parameterSet;
        this.save_Boolean_value(PARM_KEY, SECURITY_NAME, nFSParameterSet.EnableNTSecurity);
        this.save_Int_value(PARM_KEY, LOGGING_NAME, nFSParameterSet.LoggingLevel);
        this.save_String_value(PARM_KEY, WEBNFS_INDEX_FILE, this.AliasHash(nFSParameterSet.WebNFSIndexFile));
        this.setPublicDirectory(nFSParameterSet.WebNFSPublicDirectory);
        nuu.setNFSUserData(nFSParameterSet.NFSUserID, nFSParameterSet.NFSPassword);
        this.write_exports_file(nFSParameterSet);
        this.save_Boolean_value(PCNFSD_KEY, AUTO_ADD_NAME, nFSParameterSet.EnableAutoAddUser);
        this.save_Int_value(USER_KEY, VALIDATE_TIMEOUT_NAME, nFSParameterSet.ValidTimeout);
        this.save_Int_value(USER_KEY, ACCESS_TIMEOUT_NAME, nFSParameterSet.AccessTimeout);
        this.setNFSUserList(nFSParameterSet.UserList);
        this.save_Boolean_value(TRACE_KEY, TRACE_NAME, nFSParameterSet.EnableTrace);
        this.save_Int_value(TRACE_KEY, TRACE_OPTIONS_NAME, nFSParameterSet.TraceOption);
        this.save_String_value(TRACE_KEY, TRACE_FILENAME_NAME, this.AliasHash(nFSParameterSet.TraceFilename));
    }

    Object getOsUserList(Object object) {
        String[] stringArray = nuu.list_users();
        return stringArray;
    }

    Object getNFSUserList(Object object) {
        NFSUser[] nFSUserArray = nuu.getAllNFSUsers();
        old_user_list.removeAllElements();
        int n = 0;
        while (n < nFSUserArray.length) {
            old_user_list.addElement(nFSUserArray[n]);
            ++n;
        }
        return old_user_list.clone();
    }

    Object setNFSUserList(Object object) {
        NFSUser nFSUser;
        Object object2;
        Object object3;
        Enumeration enumeration;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Hashtable hashtable2 = new Hashtable();
        if (!(object instanceof VectorX)) {
            return null;
        }
        VectorX vectorX = (VectorX)object;
        Enumeration enumeration2 = vectorX.elements();
        while (enumeration2.hasMoreElements()) {
            enumeration = (NFSUser)enumeration2.nextElement();
            hashtable2.put(((NFSUser)((Object)enumeration)).UserName, enumeration);
        }
        if (old_user_list != null) {
            enumeration = old_user_list.elements();
            while (enumeration.hasMoreElements()) {
                object3 = (NFSUser)enumeration.nextElement();
                hashtable.put(((NFSUser)object3).UserName, object3);
            }
        }
        enumeration = old_user_list.elements();
        while (enumeration.hasMoreElements()) {
            object3 = (NFSUser)enumeration.nextElement();
            if (hashtable2.containsKey(((NFSUser)object3).UserName)) continue;
            this.deleteNFSUser(object3);
        }
        object3 = vectorX.elements();
        while (object3.hasMoreElements()) {
            object2 = (NFSUser)object3.nextElement();
            if (!hashtable.containsKey(((NFSUser)object2).UserName) || (nFSUser = (NFSUser)hashtable.get(((NFSUser)object2).UserName)) == null || nFSUser.uid == ((NFSUser)object2).uid) continue;
            this.changeNFSUser(object2);
        }
        object2 = vectorX.elements();
        while (object2.hasMoreElements()) {
            nFSUser = (NFSUser)object2.nextElement();
            if (hashtable.containsKey(nFSUser.UserName)) continue;
            this.addNFSUser(nFSUser);
        }
        old_user_list = (VectorX)vectorX.clone();
        return null;
    }

    Object addNFSUser(Object object) {
        if (object instanceof NFSUser) {
            nuu.addNFSUser((NFSUser)object);
        }
        return null;
    }

    Object deleteNFSUser(Object object) {
        if (object instanceof NFSUser) {
            nuu.removeNFSUser((NFSUser)object);
        }
        return null;
    }

    Object changeNFSUser(Object object) {
        if (object instanceof NFSUser) {
            nuu.replaceNFSUser((NFSUser)object);
        }
        return null;
    }

    Object getExportable(Object object) {
        Object object2;
        if (!(object instanceof String[])) {
            return null;
        }
        String[] stringArray = (String[])object;
        VectorX vectorX = new VectorX();
        int n = 0;
        while (n < stringArray.length) {
            object2 = new File(stringArray[n]);
            if (!(((File)object2).exists() && ((File)object2).isDirectory() && stringArray[n].length() >= 3 && nuu.isDriveExportable(stringArray[n].substring(0, 3)))) {
                vectorX.addElement(new Integer(n));
            }
            ++n;
        }
        object2 = new int[vectorX.size()];
        int n2 = 0;
        while (n2 < vectorX.size()) {
            object2[n2] = (Integer)vectorX.elementAt(n2);
            ++n2;
        }
        return object2;
    }

    private String AliasHash(String string) {
        String string2;
        if (string != null) {
            string2 = string.toLowerCase();
            if ((string2 = string2.replace('/', '\\')).endsWith("\\")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        } else {
            string2 = null;
        }
        return string2;
    }

    private VectorX read_exports_file(NFSParameterSet nFSParameterSet) {
        RegistryValue registryValue = new RegistryValue();
        VectorX vectorX = new VectorX();
        Hashtable hashtable = new Hashtable();
        new Vector();
        registryValue.Key = PARM_KEY;
        registryValue.Name = String.valueOf(this.ETC_PATH) + "\\EXPORTS";
        registryValue.Type = 5;
        registryValue.Value = null;
        registryValue = ntr.getOneValue(registryValue);
        if (registryValue != null) {
            Object object;
            StringTokenizer stringTokenizer = new StringTokenizer((String)registryValue.Value, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (((String)object).length() == 0 || ((String)object).startsWith("#")) continue;
                this.load_data((String)object, hashtable, nFSParameterSet);
            }
            object = hashtable.elements();
            while (object.hasMoreElements()) {
                NFSDirectory nFSDirectory = (NFSDirectory)object.nextElement();
                vectorX.addElement(nFSDirectory);
            }
        }
        return vectorX;
    }

    private void load_data(String string, Hashtable hashtable, NFSParameterSet nFSParameterSet) {
        int n;
        NFSDirectory nFSDirectory = new NFSDirectory();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t\n\r ");
        int n2 = string.indexOf("\"", 1);
        nFSDirectory.m_Name = string.substring(1, n2);
        String string2 = new String(nFSDirectory.m_Name);
        stringTokenizer = new StringTokenizer(string.substring(n2 + 1), "\t\n\r ");
        boolean bl = false;
        if (hashtable.containsKey(nFSDirectory.m_Name)) {
            nFSDirectory = (NFSDirectory)hashtable.get(nFSDirectory.m_Name);
            hashtable.remove(nFSDirectory.m_Name);
            bl = true;
        }
        int n3 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.substring(0, 1).equals("#")) {
                n = string.indexOf("#");
                nFSDirectory.Comment = string.substring(n + 1).trim();
                break;
            }
            if (string3.equalsIgnoreCase("-nontsec")) {
                nFSDirectory.NoNTSecurity = new Boolean(true);
                continue;
            }
            if (string3.equalsIgnoreCase("-alias")) {
                n3 = 1;
                continue;
            }
            if (string3.equalsIgnoreCase("-ro")) {
                n3 = 2;
                bl2 = true;
                continue;
            }
            if (string3.equalsIgnoreCase("-rw")) {
                n3 = 3;
                bl3 = true;
                continue;
            }
            if (string3.equalsIgnoreCase("public")) {
                nFSParameterSet.WebNFSPublicDirectory = string2;
                return;
            }
            switch (n3) {
                case 2: {
                    nFSDirectory.read_only_hosts.addElement(string3);
                    break;
                }
                case 3: {
                    nFSDirectory.read_write_hosts.addElement(string3);
                    break;
                }
                case 1: {
                    StringBuffer stringBuffer = new StringBuffer(nFSDirectory.m_Alias);
                    StringTokenizer stringTokenizer2 = new StringTokenizer(nFSDirectory.m_Alias);
                    if (string3.startsWith("\"") && string3.endsWith("\"")) {
                        string3 = string3.substring(1, string3.length() - 1);
                    }
                    if (stringBuffer.length() == 0) {
                        stringBuffer.append(string3);
                    } else {
                        boolean bl4 = false;
                        while (stringTokenizer2.hasMoreTokens()) {
                            if (!stringTokenizer2.nextToken().equals(string3)) continue;
                            bl4 = true;
                        }
                        if (!bl4) {
                            stringBuffer.append(" ");
                            stringBuffer.append(string3);
                        }
                    }
                    nFSDirectory.m_Alias = stringBuffer.toString();
                    break;
                }
            }
        }
        int n4 = nFSDirectory.read_only_hosts.size();
        n = nFSDirectory.read_write_hosts.size();
        if (n4 == 0 && n == 0) {
            if (bl2) {
                nFSDirectory.AllHostsReadOnly = new Boolean(true);
            } else {
                nFSDirectory.AllHostsReadWrite = new Boolean(true);
            }
            hashtable.put(nFSDirectory.m_Name, nFSDirectory);
            return;
        }
        if (bl) {
            if (n4 > 0 && n == 0) {
                nFSDirectory.OtherHostsReadWrite = new Boolean(true);
            }
            if (n > 0 && n4 == 0 && bl2) {
                nFSDirectory.OtherHostsReadOnly = new Boolean(true);
            }
        }
        hashtable.put(nFSDirectory.m_Name, nFSDirectory);
    }

    private void write_exports_file(NFSParameterSet nFSParameterSet) {
        RegistryValue registryValue = new RegistryValue();
        registryValue.Key = "System\\CurrentControlSet\\Services\\NFSD\\Parameters\\ETC";
        registryValue.Name = String.valueOf(this.ETC_PATH) + "\\EXPORTS";
        registryValue.Type = 5;
        Hashtable<NFSDirectory, NFSDirectory> hashtable = new Hashtable<NFSDirectory, NFSDirectory>();
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = nFSParameterSet.DirectoryList.elements();
        while (enumeration.hasMoreElements()) {
            NFSDirectory nFSDirectory = (NFSDirectory)enumeration.nextElement();
            if (hashtable.containsKey(nFSDirectory)) continue;
            this.store_data(stringBuffer, nFSDirectory, false);
            hashtable.put(nFSDirectory, nFSDirectory);
        }
        if (nFSParameterSet.WebNFSPublicDirectory != null && !nFSParameterSet.WebNFSPublicDirectory.equals("")) {
            stringBuffer.append("\"");
            stringBuffer.append(nFSParameterSet.WebNFSPublicDirectory);
            stringBuffer.append("\"");
            stringBuffer.append(" ");
            stringBuffer.append("public");
            stringBuffer.append(" # WebNFS public file handle\n");
        }
        registryValue.Value = stringBuffer.toString();
        ntr.putValue(registryValue);
    }

    private void store_data(StringBuffer stringBuffer, NFSDirectory nFSDirectory, boolean bl) {
        int n = 0;
        if (nFSDirectory.read_only_hosts.size() > 0) {
            n += this.write_exports_line(stringBuffer, nFSDirectory.m_Name, nFSDirectory.m_Alias, nFSDirectory.NoNTSecurity, " -ro ", nFSDirectory.read_only_hosts, bl, nFSDirectory.Comment);
        }
        if (nFSDirectory.read_write_hosts.size() > 0) {
            n += this.write_exports_line(stringBuffer, nFSDirectory.m_Name, nFSDirectory.m_Alias, nFSDirectory.NoNTSecurity, " -rw ", nFSDirectory.read_write_hosts, bl, nFSDirectory.Comment);
        }
        VectorX vectorX = new VectorX();
        if (n == 0) {
            if (nFSDirectory.AllHostsReadOnly.booleanValue() || nFSDirectory.OtherHostsReadOnly.booleanValue()) {
                this.write_exports_line(stringBuffer, nFSDirectory.m_Name, nFSDirectory.m_Alias, nFSDirectory.NoNTSecurity, " -ro ", vectorX, bl, nFSDirectory.Comment);
            }
            if (nFSDirectory.AllHostsReadWrite.booleanValue() || nFSDirectory.OtherHostsReadWrite.booleanValue()) {
                this.write_exports_line(stringBuffer, nFSDirectory.m_Name, nFSDirectory.m_Alias, nFSDirectory.NoNTSecurity, "FORCE", null, bl, nFSDirectory.Comment);
            }
            return;
        }
        if (nFSDirectory.OtherHostsReadOnly.booleanValue()) {
            this.write_exports_line(stringBuffer, nFSDirectory.m_Name, nFSDirectory.m_Alias, nFSDirectory.NoNTSecurity, " -ro ", vectorX, bl, nFSDirectory.Comment);
        }
        if (nFSDirectory.OtherHostsReadWrite.booleanValue()) {
            this.write_exports_line(stringBuffer, nFSDirectory.m_Name, nFSDirectory.m_Alias, nFSDirectory.NoNTSecurity, "FORCE", null, bl, nFSDirectory.Comment);
        }
    }

    private int write_exports_line(StringBuffer stringBuffer, String string, String string2, boolean bl, String string3, VectorX vectorX, boolean bl2, String string4) {
        int n = 0;
        if (bl2 && stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == "\"".charAt(0)) {
            stringBuffer.append(ListDelimiter);
        }
        if (string3 == "FORCE") {
            if (bl2) {
                stringBuffer.append("\"");
                stringBuffer.append(string);
            } else {
                stringBuffer.append("\"");
                stringBuffer.append(string);
                stringBuffer.append("\"");
            }
            if (bl) {
                stringBuffer.append(" -nontsec ");
            }
            if (!string2.equals(string) && !string2.trim().equals("")) {
                stringBuffer.append(" -Alias ");
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                stringBuffer.append("\"");
                stringBuffer.append(stringTokenizer.nextToken());
                stringBuffer.append("\"");
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(" ");
                    stringBuffer.append("\"");
                    stringBuffer.append(stringTokenizer.nextToken());
                    stringBuffer.append("\"");
                }
            }
            if (string4.length() > 0) {
                stringBuffer.append(" # ");
                stringBuffer.append(string4);
            }
            if (bl2) {
                stringBuffer.append("\"");
            } else {
                stringBuffer.append("\n");
            }
            return 1;
        }
        if (bl2) {
            stringBuffer.append("\"");
            stringBuffer.append(string);
        } else {
            stringBuffer.append("\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
        }
        if (bl) {
            stringBuffer.append(" -nontsec ");
        }
        if (!string2.equals(string) && !string2.trim().equals("")) {
            stringBuffer.append(" -Alias ");
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            stringBuffer.append("\"");
            stringBuffer.append(stringTokenizer.nextToken());
            stringBuffer.append("\"");
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(" ");
                stringBuffer.append("\"");
                stringBuffer.append(stringTokenizer.nextToken());
                stringBuffer.append("\"");
            }
        } else {
            stringBuffer.append(" ");
        }
        stringBuffer.append(string3);
        int n2 = 0;
        while (n2 < vectorX.size()) {
            stringBuffer.append((String)vectorX.elementAt(n2));
            stringBuffer.append(" ");
            ++n2;
        }
        if (string4.length() > 0) {
            stringBuffer.append(" # ");
            stringBuffer.append(string4);
        }
        if (bl2) {
            stringBuffer.append("\"");
        } else {
            stringBuffer.append("\n");
        }
        n = 1;
        return n;
    }
}

