/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.config.agents;

import com.ibm.eNetwork.onDemand.common.Copyright;
import com.ibm.eNetwork.onDemand.config.agents.AgentsNodeMgr;
import com.ibm.eNetwork.onDemand.config.agents.BaseDaemon;
import com.ibm.eNetwork.onDemand.config.agents.Host;
import com.ibm.eNetwork.onDemand.config.agents.ParameterSet;
import com.ibm.eNetwork.onDemand.config.nls.MsgTranslator;
import com.ibm.eNetwork.onDemand.config.node.BaseNode;
import com.ibm.eNetwork.onDemand.config.node.NodeMenuItemDescriptor;
import com.ibm.eNetwork.onDemand.config.node.NodeMenuItemDescriptorList;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.io.Serializable;

public class NodeParameterSet
extends BaseNode
implements ClipboardOwner {
    private static final String cStmt1 = Copyright.COPYRIGHT_98;
    ParameterSet ps;
    Host host;
    BaseDaemon daemon;
    private static final int DELETE_ID = 1;
    private static final int ACTIVATE_ID = 3;
    private static final int COPY_ID = 4;
    private static final String COPY_MI_CLASS = "com.ibm.eNetwork.onDemand.config.agents.CopyMenuItem";
    private static final String BASE_MI_CLASS = "com.ibm.eNetwork.onDemand.config.node.BaseMenuItem";
    private static final String RENAME_MI_CLASS = "com.ibm.eNetwork.onDemand.config.agents.RenameMenuItem";
    public static final String IMAGES_DIR = "/com/ibm/eNetwork/onDemand/config/images";
    public static final String inactive_ind = "/com/ibm/eNetwork/onDemand/config/images/configIU.gif";
    public static final String active_ind = "/com/ibm/eNetwork/onDemand/config/images/configAU.gif";
    public static final String inactive_valid = "/com/ibm/eNetwork/onDemand/config/images/configIV.gif";
    public static final String active_valid = "/com/ibm/eNetwork/onDemand/config/images/configAV.gif";
    public static final String inactive_invalid = "/com/ibm/eNetwork/onDemand/config/images/configII.gif";
    public static final String active_invalid = "/com/ibm/eNetwork/onDemand/config/images/configAI.gif";
    public static final int isParameterSetActiveOid = 301;
    public static final int isParameterSetValidOid = 302;
    public static final int setNameOid = 303;
    private static int uniqueId;
    private String uniqueName;

    public NodeParameterSet(Host host, BaseDaemon baseDaemon, ParameterSet parameterSet) {
        this.ps = parameterSet;
        this.host = host;
        this.daemon = baseDaemon;
        this.setNodeMgr(this.daemon.getNodeMgr());
        this.setIcon(this.getNewIcon());
        this.setMenuItemDescriptors(this.getMenuItems());
        this.setLabel(this.getNewLabel());
        this.setParent(this.daemon);
        this.uniqueName = String.valueOf(this.host.getUniqueName()) + "\u00a7" + this.daemon.getClass().getName() + "\u00a7" + this.getUniqueID();
    }

    private synchronized String getUniqueID() {
        return Integer.toString(uniqueId++);
    }

    public String getNewLabel() {
        if (this.ps != null) {
            return this.ps.getLabel();
        }
        return "NodeParameterSet";
    }

    public String getNewIcon() {
        if (!this.daemon.isValidatable()) {
            if (this.ps.getActive()) {
                return active_ind;
            }
            return inactive_ind;
        }
        if (this.ps.getActive()) {
            if (this.ps.getValid()) {
                return active_valid;
            }
            return active_invalid;
        }
        if (this.ps.getValid()) {
            return inactive_valid;
        }
        return inactive_invalid;
    }

    public void setActive(boolean bl) {
        this.ps.setActive(bl);
        this.setIcon(this.getNewIcon());
        this.setMenuItemDescriptors(this.getMenuItems());
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public NodeMenuItemDescriptorList getMenuItems() {
        MsgTranslator msgTranslator = this.daemon.getNodeMgr().getMsgTranslator();
        boolean bl = this.ps.getActive();
        NodeMenuItemDescriptorList nodeMenuItemDescriptorList = new NodeMenuItemDescriptorList();
        NodeMenuItemDescriptor nodeMenuItemDescriptor = new NodeMenuItemDescriptor(msgTranslator.get("Open", "OPEN_MENU"), BaseDaemon.OPEN_MI_CLASS, true, true);
        if (this.daemon.getView() != null) {
            nodeMenuItemDescriptor.setCargo(this.daemon.getView());
        } else {
            nodeMenuItemDescriptor.setCargo((Serializable)((Object)this.daemon.getHtmlFile()));
        }
        nodeMenuItemDescriptorList.addElement(nodeMenuItemDescriptor);
        if (!bl) {
            nodeMenuItemDescriptor = new NodeMenuItemDescriptor(msgTranslator.get("Delete", "DELETE_MENU_ITEM"), BASE_MI_CLASS, true);
            nodeMenuItemDescriptor.setCargo(new Integer(1));
            nodeMenuItemDescriptorList.addElement(nodeMenuItemDescriptor);
        }
        nodeMenuItemDescriptor = new NodeMenuItemDescriptor(msgTranslator.get("Rename", "RENAME_MENU_ITEM"), RENAME_MI_CLASS, true);
        nodeMenuItemDescriptorList.addElement(nodeMenuItemDescriptor);
        nodeMenuItemDescriptor = new NodeMenuItemDescriptor(msgTranslator.get("Copy", "COPY_MENU_ITEM"), COPY_MI_CLASS, true);
        nodeMenuItemDescriptor.setCargo((Serializable)((Object)this.ps.getClass().getName()));
        nodeMenuItemDescriptorList.addElement(nodeMenuItemDescriptor);
        String[] stringArray = new String[]{this.daemon.getLabel()};
        nodeMenuItemDescriptor = new NodeMenuItemDescriptor(msgTranslator.get("Paste to Parent", "PASTE_PARAMETERSET", stringArray), BaseDaemon.PASTE_MI_CLASS, true);
        nodeMenuItemDescriptor.setCargo((Serializable)((Object)this.ps.getClass().getName()));
        nodeMenuItemDescriptorList.addElement(nodeMenuItemDescriptor);
        if (!bl) {
            nodeMenuItemDescriptor = new NodeMenuItemDescriptor(msgTranslator.get("Activate", "ACTIVATE_MENU_ITEM"), BASE_MI_CLASS, true);
            nodeMenuItemDescriptor.setCargo(new Integer(3));
            nodeMenuItemDescriptorList.addElement(nodeMenuItemDescriptor);
        }
        return nodeMenuItemDescriptorList;
    }

    public ParameterSet getParameterSet() {
        return this.ps;
    }

    public Object performOperation(int n, Object object) {
        AgentsNodeMgr.getAgentsNodeMgr();
        switch (n) {
            case 1: {
                if (object.equals(new Integer(1))) {
                    this.daemon.deleteParameterSet(this);
                }
                if (!object.equals(new Integer(3))) break;
                this.daemon.activateParameterSet(this.ps);
                break;
            }
            case 301: {
                return new Boolean(this.ps.getActive());
            }
            case 302: {
                boolean bl = this.daemon.isValid((ParameterSet)object);
                this.ps.setValid(bl);
                return new Boolean(bl);
            }
            case 303: {
                this.ps.setLabel((String)object);
                this.ps.setSaveable(true);
                this.setLabel(this.ps.getLabel());
                break;
            }
            case 104: {
                boolean bl = this.ps.getActive();
                this.ps = (ParameterSet)object;
                if (!bl) break;
                this.daemon.setParameterSet(this.ps);
                break;
            }
            case 103: {
                return this.ps;
            }
            default: {
                return this.daemon.performOperation(n, object);
            }
        }
        return null;
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

