/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.config.agents;

import com.ibm.eNetwork.onDemand.common.Copyright;
import com.ibm.eNetwork.onDemand.config.agents.Daemon;
import com.ibm.eNetwork.onDemand.config.agents.Detector;
import com.ibm.eNetwork.onDemand.config.agents.URLBaseDaemon;
import com.ibm.eNetwork.onDemand.config.agents.URLElement;
import com.ibm.eNetwork.onDemand.config.nls.MsgTranslator;
import com.ibm.eNetwork.onDemand.config.node.NodeMenuItemDescriptor;
import com.ibm.eNetwork.onDemand.config.node.NodeMenuItemDescriptorList;
import com.ibm.eNetwork.onDemand.config.util.Debug;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class URLDetector
implements Detector {
    private static final String cStmt1 = Copyright.COPYRIGHT_98;
    private static final String NUMPROP = "URLDetector.numClients";
    private static final String OPEN_MI_CLASS = "com.ibm.eNetwork.onDemand.config.agents.OpenMenuItem";
    Vector urlElements;
    Vector startedDaemons;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    Debug debug = new Debug("URLDetector");
    MsgTranslator mt;

    public URLDetector() {
        this.startedDaemons = new Vector();
        this.urlElements = new Vector();
    }

    public void setProperties(Properties properties) {
        this.readDaemons(properties, "URLDetector");
    }

    public void readDaemons(Properties properties, String string) {
        int n = 0;
        if (properties == null) {
            return;
        }
        try {
            n = Integer.parseInt(properties.getProperty(String.valueOf(string) + ".numClients"));
        }
        catch (NumberFormatException numberFormatException) {
            this.pcs.firePropertyChange("LogAMessage", NUMPROP, "CFW2002E");
            return;
        }
        int n2 = 1;
        while (n2 <= n) {
            String string2 = properties.getProperty(String.valueOf(string) + ".URL." + n2);
            String string3 = properties.getProperty(String.valueOf(string) + ".label." + n2);
            String string4 = properties.getProperty(String.valueOf(string) + ".labelMsgID." + n2);
            String string5 = properties.getProperty(String.valueOf(string) + ".client." + n2);
            String string6 = properties.getProperty(String.valueOf(string) + ".msgCatalog." + n2);
            int n3 = 0;
            try {
                n3 = Integer.parseInt(properties.getProperty(String.valueOf(string) + ".numMenus." + n2));
            }
            catch (Exception exception) {}
            this.debug.print("props " + string2 + " " + string3 + " " + string5);
            if (string2 != null && string3 != null && string5 != null) {
                URLElement uRLElement = new URLElement();
                uRLElement.url = string2;
                uRLElement.label = string3;
                uRLElement.labelMsgID = string4;
                uRLElement.client = string5;
                uRLElement.MsgCatalog = string6;
                if (n3 > 0) {
                    this.lookForMenuItems(properties, uRLElement, n2, n3, string);
                }
                this.urlElements.addElement(uRLElement);
            }
            ++n2;
        }
    }

    private void lookForMenuItems(Properties properties, URLElement uRLElement, int n, int n2, String string) {
        Vector<URLMenuItem> vector = new Vector<URLMenuItem>();
        int n3 = 1;
        while (n3 < n2 + 1) {
            String string2 = properties.getProperty(String.valueOf(string) + "." + n + ".MenuTitle." + n3);
            String string3 = properties.getProperty(String.valueOf(string) + "." + n + ".MenuMsgID." + n3);
            String string4 = properties.getProperty(String.valueOf(string) + "." + n + ".MenuURL." + n3);
            if (string2 != null && string4 != null) {
                URLMenuItem uRLMenuItem = new URLMenuItem(string2, string3, string4);
                vector.addElement(uRLMenuItem);
            }
            ++n3;
        }
        uRLElement.MenuItems = vector;
    }

    public int getNumberOfDaemons() {
        return this.urlElements.size() + this.startedDaemons.size();
    }

    private Daemon startDaemon(String string) {
        if (string == null) {
            return null;
        }
        try {
            return (Daemon)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.pcs.firePropertyChange("LogAMessage", classNotFoundException.getMessage(), "CFW2001E");
        }
        catch (Exception exception) {
            this.pcs.firePropertyChange("LogAMessage", exception.getMessage(), "CFW2003E");
        }
        return null;
    }

    public Daemon getDaemon(String string) {
        URLBaseDaemon uRLBaseDaemon;
        int n = 0;
        while (n < this.startedDaemons.size()) {
            uRLBaseDaemon = (URLBaseDaemon)this.startedDaemons.elementAt(n);
            if (string.equals(uRLBaseDaemon.getClass().getName())) {
                return uRLBaseDaemon;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.urlElements.size()) {
            URLElement uRLElement = (URLElement)this.urlElements.elementAt(n2);
            if (string.equals(uRLElement.client) && (uRLBaseDaemon = (URLBaseDaemon)this.startDaemon(string)) != null) {
                uRLBaseDaemon.setLabel(this.findLabel(uRLElement));
                try {
                    URL uRL = new URL(uRLElement.url);
                    uRLBaseDaemon.setURL(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    uRLBaseDaemon.setHTML(uRLElement.url);
                }
                uRLBaseDaemon.setUserMenus(this.findMenus(uRLElement));
                this.startedDaemons.addElement(uRLBaseDaemon);
                this.urlElements.removeElement(uRLElement);
                return uRLBaseDaemon;
            }
            ++n2;
        }
        return null;
    }

    public void getDaemons() {
        int n = 0;
        while (n < this.urlElements.size()) {
            URLElement uRLElement = (URLElement)this.urlElements.elementAt(n);
            Daemon daemon = this.getDaemon(uRLElement.client);
            if (daemon != null) {
                this.pcs.firePropertyChange("New_Daemon", null, daemon);
            }
            ++n;
        }
        this.pcs.firePropertyChange("DaemonListComplete", new Integer(1), new Integer(0));
    }

    public boolean isDaemonInstalled(String string) {
        int n = 0;
        while (n < this.startedDaemons.size()) {
            URLBaseDaemon uRLBaseDaemon = (URLBaseDaemon)this.startedDaemons.elementAt(n);
            if (string.equals(uRLBaseDaemon.getClass().getName())) {
                return true;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.urlElements.size()) {
            URLElement uRLElement = (URLElement)this.urlElements.elementAt(n2);
            if (string.equals(uRLElement.client)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setMsgTranslator(MsgTranslator msgTranslator) {
        this.mt = msgTranslator;
    }

    public MsgTranslator getMsgTranslator() {
        return this.mt;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private String findLabel(URLElement uRLElement) {
        if (uRLElement.labelMsgID != null && uRLElement.MsgCatalog != null && this.getMsgTranslator() != null) {
            MsgTranslator msgTranslator = this.getMsgTranslator().getMsgTranslator(uRLElement.MsgCatalog);
            String string = msgTranslator.get(uRLElement.label, uRLElement.labelMsgID);
            return string;
        }
        return uRLElement.label;
    }

    private NodeMenuItemDescriptorList findMenus(URLElement uRLElement) {
        NodeMenuItemDescriptorList nodeMenuItemDescriptorList = new NodeMenuItemDescriptorList();
        MsgTranslator msgTranslator = null;
        if (uRLElement.MsgCatalog != null && this.getMsgTranslator() != null) {
            msgTranslator = this.getMsgTranslator().getMsgTranslator(uRLElement.MsgCatalog);
        }
        if (uRLElement.MenuItems == null) {
            return nodeMenuItemDescriptorList;
        }
        if (uRLElement.MenuItems.size() > 0) {
            Enumeration enumeration = uRLElement.MenuItems.elements();
            while (enumeration.hasMoreElements()) {
                URLMenuItem uRLMenuItem = (URLMenuItem)enumeration.nextElement();
                String string = uRLMenuItem.title;
                if (msgTranslator != null && uRLMenuItem.MsgId != null) {
                    string = msgTranslator.get(string, uRLMenuItem.MsgId);
                }
                NodeMenuItemDescriptor nodeMenuItemDescriptor = new NodeMenuItemDescriptor(string, OPEN_MI_CLASS, true);
                try {
                    URL uRL = new URL(uRLMenuItem.url);
                    nodeMenuItemDescriptor.setCargo(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    nodeMenuItemDescriptor.setCargo((Serializable)((Object)uRLMenuItem.url));
                }
                nodeMenuItemDescriptorList.addElement(nodeMenuItemDescriptor);
            }
        }
        return nodeMenuItemDescriptorList;
    }

    class URLMenuItem {
        String title;
        String MsgId;
        String url;

        URLMenuItem(String string, String string2, String string3) {
            URLDetector.this = URLDetector.this;
            this.title = string;
            this.MsgId = string2;
            this.url = string3;
        }
    }
}

