/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.config.agents.tftpd;

import com.ibm.eNetwork.onDemand.common.Copyright;
import com.ibm.eNetwork.onDemand.config.agents.Host;
import com.ibm.eNetwork.onDemand.config.agents.NTBaseDaemon;
import com.ibm.eNetwork.onDemand.config.agents.NTRegistryUser;
import com.ibm.eNetwork.onDemand.config.agents.ParameterSet;
import com.ibm.eNetwork.onDemand.config.agents.tftpd.TftpdParameterSet;
import com.ibm.eNetwork.onDemand.config.nls.MsgTranslator;
import com.ibm.eNetwork.onDemand.config.node.NodeMgr;
import com.ibm.eNetwork.onDemand.config.util.Log;
import java.util.Hashtable;
import java.util.Properties;

public class TftpdDaemon
extends NTBaseDaemon
implements NTRegistryUser {
    private static final String cStmt1 = Copyright.COPYRIGHT_98;
    final String TFTP_PARAM = "\\Tftpd\\Parameters";
    final String TFTP_TRACE = "\\Tftpd\\Trace";
    final String HtmlFile = "tftp.html";
    final String HelpHtmlFile = "tftpx.htm";
    Log log;
    MsgTranslator mt;
    public String Default_Trace_Filename;
    public static String DAEMON_ID = "Tftpd";
    TftpdParameterSet cps;
    public static final Integer DEFAULT_PORT_NUMBER = new Integer(69);
    public static final Boolean DEFAULT_ENABLE_LOGGING = new Boolean(false);
    public static final Integer DEFAULT_TIMEOUT = new Integer(5);
    public static final Boolean DEFAULT_ENABLE_WRITE_ACCESS = new Boolean(true);
    public static final Boolean DEFAULT_ENABLE_READ_ACCESS = new Boolean(true);
    public static final Integer DEFAULT_MAXIMUM_SEGMENT_SIZE = new Integer(8196);
    public static final Integer DEFAULT_RETRY_LIMIT = new Integer(5);
    public static final Boolean DEFAULT_ENABLE_TRACE = new Boolean(false);
    public static final Integer DEFAULT_MAXIMUM_TRACE_FILE_SIZE = new Integer(64);
    public static final Integer DEFAULT_NUMBER_OF_TRACE_FILES = new Integer(2);
    public static final Integer DEFAULT_TRACE_OPTIONS = new Integer(-1);

    public TftpdDaemon() {
        super("TFTPD");
    }

    public void setNodeMgr(NodeMgr nodeMgr) {
        super.setNodeMgr(nodeMgr);
        if (nodeMgr != null) {
            this.log = nodeMgr.getLog();
            this.mt = nodeMgr.getMsgTranslator();
        }
        if (this.mt != null) {
            this.setLabel(this.mt.get("Tftpd", "TFTPD_NAME"));
        }
    }

    public void setHost(Host host) {
        super.setHost(host);
        this.Default_Trace_Filename = new String(String.valueOf(this.getHost().getInstalledDirectory("ETC")) + "\\tftp.trc");
    }

    public String getHtmlFile() {
        String string = "tftpd.html";
        return string;
    }

    public Properties getHelpProperties() {
        Properties properties = new Properties();
        ((Hashtable)properties).put("Contents", "tftpx.htm");
        ((Hashtable)properties).put("Window_Help", "");
        ((Hashtable)properties).put("How_Do_I", "tftph.htm");
        ((Hashtable)properties).put("Before_You_Start", "tftpb.htm");
        ((Hashtable)properties).put("Window_tftp_adv", "tftp.htm#Service_tab");
        ((Hashtable)properties).put("Window_tftp_dirs", "tftp.htm#Directories_tab");
        ((Hashtable)properties).put("Window_tftp_trace", "tftp.htm#Trace_tab");
        return properties;
    }

    public ParameterSet getParameterSet() {
        this.getHost();
        this.cps = new TftpdParameterSet();
        this.cps.PortNumber = new Integer(DEFAULT_PORT_NUMBER);
        this.cps.EnableLogging = new Boolean(DEFAULT_ENABLE_LOGGING);
        this.cps.Timeout = new Integer(DEFAULT_TIMEOUT);
        this.cps.EnableWriteAccess = new Boolean(DEFAULT_ENABLE_WRITE_ACCESS);
        this.cps.EnableReadAccess = new Boolean(DEFAULT_ENABLE_READ_ACCESS);
        this.cps.MaximumSegmentSize = new Integer(DEFAULT_MAXIMUM_SEGMENT_SIZE);
        this.cps.RetryLimit = new Integer(DEFAULT_RETRY_LIMIT);
        this.cps.EnableTrace = new Boolean(DEFAULT_ENABLE_TRACE);
        this.cps.MaximumTraceFileSize = new Integer(DEFAULT_MAXIMUM_TRACE_FILE_SIZE);
        this.cps.NumberOfTraceFiles = new Integer(DEFAULT_NUMBER_OF_TRACE_FILES);
        this.cps.TraceOptions = new Integer(DEFAULT_TRACE_OPTIONS);
        this.cps.AccessDirectories = new String[0];
        this.cps.TraceFilename = this.Default_Trace_Filename;
        this.load_data(this.cps);
        return this.cps;
    }

    public void setParameterSet(ParameterSet parameterSet) {
        if (parameterSet instanceof TftpdParameterSet) {
            this.save_data((TftpdParameterSet)parameterSet);
        }
    }

    public Boolean isTraceFileNameValid(TftpdParameterSet tftpdParameterSet) {
        boolean bl = true;
        if (this.getHost() != null) {
            String string = tftpdParameterSet.TraceFilename;
            String string2 = string.replace('/', '\\');
            if (string.indexOf("\\") != -1) {
                string2 = string.substring(0, string.lastIndexOf("\\"));
                String string3 = string.substring(string.lastIndexOf("\\") + 1);
                if (!string3.trim().equals("")) {
                    if (string2.endsWith(":")) {
                        string2 = String.valueOf(string2) + "\\";
                    }
                    bl = this.getHost().isDirectoryValid(string2);
                } else {
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return new Boolean(bl);
    }

    public boolean isValid(ParameterSet parameterSet) {
        boolean bl = false;
        if (parameterSet instanceof TftpdParameterSet) {
            TftpdParameterSet tftpdParameterSet = (TftpdParameterSet)parameterSet;
            bl = this.isTraceFileNameValid(tftpdParameterSet);
        }
        return bl;
    }

    private void load_data(TftpdParameterSet tftpdParameterSet) {
        tftpdParameterSet.PortNumber = this.load_Int_value("System\\CurrentControlSet\\Services\\Tftpd\\Parameters", "PortNumber", tftpdParameterSet.PortNumber);
        tftpdParameterSet.EnableLogging = this.load_Boolean_value("System\\CurrentControlSet\\Services\\Tftpd\\Parameters", "Logging", tftpdParameterSet.EnableLogging);
        tftpdParameterSet.RetryLimit = this.load_Int_value("System\\CurrentControlSet\\Services\\Tftpd\\Parameters", "MaxRetry", tftpdParameterSet.RetryLimit);
        tftpdParameterSet.MaximumSegmentSize = this.load_Int_value("System\\CurrentControlSet\\Services\\Tftpd\\Parameters", "SegmentSize", tftpdParameterSet.MaximumSegmentSize);
        tftpdParameterSet.Timeout = this.load_Int_value("System\\CurrentControlSet\\Services\\Tftpd\\Parameters", "TimeOut", tftpdParameterSet.Timeout);
        tftpdParameterSet.AccessDirectories = this.load_string_array_value("System\\CurrentControlSet\\Services\\Tftpd\\Parameters", "AccessDirs", tftpdParameterSet.AccessDirectories);
        tftpdParameterSet.EnableWriteAccess = this.load_Boolean_value("System\\CurrentControlSet\\Services\\Tftpd\\Parameters", "EnableWriteAccess", tftpdParameterSet.EnableWriteAccess);
        tftpdParameterSet.EnableReadAccess = this.load_Boolean_value("System\\CurrentControlSet\\Services\\Tftpd\\Parameters", "EnableReadAccess", tftpdParameterSet.EnableReadAccess);
        tftpdParameterSet.EnableTrace = this.load_Boolean_value("System\\CurrentControlSet\\Services\\Tftpd\\Trace", "Trace", tftpdParameterSet.EnableTrace);
        tftpdParameterSet.TraceOptions = this.load_Int_value("System\\CurrentControlSet\\Services\\Tftpd\\Trace", "TraceOptions", tftpdParameterSet.TraceOptions);
        tftpdParameterSet.NumberOfTraceFiles = this.load_Int_value("System\\CurrentControlSet\\Services\\Tftpd\\Trace", "NumberOfTraceFiles", tftpdParameterSet.NumberOfTraceFiles);
        tftpdParameterSet.MaximumTraceFileSize = this.load_Int_value("System\\CurrentControlSet\\Services\\Tftpd\\Trace", "MaxTraceFileSize", tftpdParameterSet.MaximumTraceFileSize);
        tftpdParameterSet.TraceFilename = this.getHost().normalizePathName(this.load_String_value("System\\CurrentControlSet\\Services\\Tftpd\\Trace", "TraceFilePath", tftpdParameterSet.TraceFilename));
        this.setTraceStatus(tftpdParameterSet.EnableTrace);
    }

    private void save_data(TftpdParameterSet tftpdParameterSet) {
        this.save_Int_value("System\\CurrentControlSet\\Services\\Tftpd\\Parameters", "PortNumber", tftpdParameterSet.PortNumber);
        this.save_Boolean_value("System\\CurrentControlSet\\Services\\Tftpd\\Parameters", "EnableReadAccess", tftpdParameterSet.EnableReadAccess);
        this.save_Boolean_value("System\\CurrentControlSet\\Services\\Tftpd\\Parameters", "EnableWriteAccess", tftpdParameterSet.EnableWriteAccess);
        this.save_Boolean_value("System\\CurrentControlSet\\Services\\Tftpd\\Parameters", "Logging", tftpdParameterSet.EnableLogging);
        this.save_Int_value("System\\CurrentControlSet\\Services\\Tftpd\\Parameters", "MaxRetry", tftpdParameterSet.RetryLimit);
        this.save_Int_value("System\\CurrentControlSet\\Services\\Tftpd\\Parameters", "SegmentSize", tftpdParameterSet.MaximumSegmentSize);
        this.save_Int_value("System\\CurrentControlSet\\Services\\Tftpd\\Parameters", "TimeOut", tftpdParameterSet.Timeout);
        this.save_string_array_value("System\\CurrentControlSet\\Services\\Tftpd\\Parameters", "AccessDirs", tftpdParameterSet.AccessDirectories);
        this.save_Boolean_value("System\\CurrentControlSet\\Services\\Tftpd\\Trace", "Trace", tftpdParameterSet.EnableTrace);
        this.save_Int_value("System\\CurrentControlSet\\Services\\Tftpd\\Trace", "MaxTraceFileSize", tftpdParameterSet.MaximumTraceFileSize);
        this.save_Int_value("System\\CurrentControlSet\\Services\\Tftpd\\Trace", "NumberOfTraceFiles", tftpdParameterSet.NumberOfTraceFiles);
        this.save_Int_value("System\\CurrentControlSet\\Services\\Tftpd\\Trace", "TraceOptions", tftpdParameterSet.TraceOptions);
        this.save_String_value("System\\CurrentControlSet\\Services\\Tftpd\\Trace", "TraceFilePath", this.getHost().normalizePathName(tftpdParameterSet.TraceFilename));
    }
}

