/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.config.agents.tftpd;

import com.ibm.eNetwork.onDemand.common.Copyright;
import com.ibm.eNetwork.onDemand.common.swing.JNumericField;
import com.ibm.eNetwork.onDemand.config.agents.BaseDetailsWithParameterSet;
import com.ibm.eNetwork.onDemand.config.agents.ParameterSet;
import com.ibm.eNetwork.onDemand.config.agents.tftpd.TftpdParameterSet;
import com.ibm.eNetwork.onDemand.config.nls.MsgTranslator;
import com.ibm.eNetwork.onDemand.config.node.Node;
import com.ibm.eNetwork.onDemand.config.node.NodeMgr;
import com.ibm.eNetwork.onDemand.config.util.Debug;
import com.ibm.eNetwork.onDemand.config.util.Log;
import com.ibm.eNetwork.onDemand.config.util.TwoColumnLayoutManager;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JCheckBox;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JList;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTabbedPane;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.text.JTextComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;

public class TftpdDetails
extends BaseDetailsWithParameterSet {
    private static final String cStmt1 = Copyright.COPYRIGHT_98;
    private static final int VISIBLE_TRACE_OPTIONS_ROW_COUNT = 4;
    private static final String DEFAULT_TRACENAMES = "Requested packets(RRQ.WRQ)-received|Error packets(ERR): Sent and received|OACK packets: Sent|Retransmissions(Sent) & duplicates(Received) of (DATA, ACK)|Regular transmissions(DATA,ACK) sent and received|Successful completion of requests|Timing out of a transaction after retries";
    private Log log;
    JTabbedPane pane;
    Debug debug = new Debug("TFTPDetails", true);
    JPanel servicePanel = new JPanel();
    String service_tab_label;
    JCheckBox enableWrite = new JCheckBox("");
    JCheckBox enableRead = new JCheckBox("");
    JTextField portNum = new JNumericField(5);
    JTextField retryLimit = new JNumericField(5);
    JTextField timeout = new JNumericField(5);
    JTextField maxSegSize = new JNumericField(5);
    JPanel directoriesPanel = new JPanel();
    String directories_tab_label;
    JList accessDirs = new JList();
    Vector accessDirsVector;
    JTextField dirName = new JTextField(10);
    JButton dirBrowse;
    JPanel tracePanel = new JPanel();
    String trace_tab_label;
    JCheckBox enableTrace = new JCheckBox("");
    JTextField traceFileName = new JTextField(20);
    JButton traceBrowse;
    JTextField maxTraceSize = new JNumericField("64", 3);
    JTextField numFiles = new JNumericField("2", 3);
    JList traceOptions = new JList();
    String tracenames;
    boolean traceOptionsAlreadySet = false;
    int numTraceOptions;
    Integer currTraceOptions;
    TftpdParameterSet ps = new TftpdParameterSet();
    JCheckBox enableLogging = new JCheckBox("");

    public String getNodeClassName() {
        return "com.ibm.eNetwork.onDemand.config.agents.tftpd.TftpdDaemon";
    }

    public String getPanelID(Component component) {
        String string = null;
        if (component == this.servicePanel) {
            string = "tftpd_settings";
        } else if (component == this.tracePanel) {
            string = "tftpd_trace";
        } else if (component == this.directoriesPanel) {
            string = "tftpd_directories";
        }
        return string;
    }

    public void init() {
        super.init();
        Node node = this.getNode();
        if (node == null) {
            this.debug.print("TftpdDetails: NODE WAS NULL");
            return;
        }
        NodeMgr nodeMgr = node.getNodeMgr();
        if (nodeMgr == null) {
            this.debug.print("TftpdDetails: NODE MGR WAS NULL");
            return;
        }
        MsgTranslator msgTranslator = nodeMgr.getMsgTranslator();
        if (msgTranslator == null) {
            this.debug.print("TftpdDetails: MSG TRANS WAS NULL");
            return;
        }
        this.pane = this.getTabbedPane();
        TwoColumnLayoutManager twoColumnLayoutManager = new TwoColumnLayoutManager((Container)this.servicePanel);
        this.service_tab_label = msgTranslator.get("Service", "ALL_SG_SERVICE");
        this.servicePanel.setLayout(twoColumnLayoutManager);
        this.enableWrite.setText(msgTranslator.get("Enable write", "TFTPD_SG_ENABLEWRITEACCESS"));
        twoColumnLayoutManager.add((Component)this.enableWrite);
        this.enableRead.setText(msgTranslator.get("Enable read", "TFTPD_SG_ENABLEREADACCESS"));
        twoColumnLayoutManager.add((Component)this.enableRead);
        twoColumnLayoutManager.add((Component)new JLabel(msgTranslator.get("Port number", "ALL_SG_PORTNUMBER")), (Component)this.portNum);
        twoColumnLayoutManager.add((Component)new JLabel(msgTranslator.get("Retry limit", "TFTPD_SG_RETRYLIMIT")), (Component)this.retryLimit);
        JPanel jPanel = new JPanel((LayoutManager)new FlowLayout(0, 2, 0));
        jPanel.add((Component)this.timeout);
        jPanel.add((Component)new JLabel(msgTranslator.get("(Seconds)", "TFTPD_SG_SECONDS")));
        twoColumnLayoutManager.add((Component)new JLabel(msgTranslator.get("Timeout", "TFTPD_SG_TIMEOUT")), (Component)jPanel);
        jPanel = new JPanel((LayoutManager)new FlowLayout(0, 2, 0));
        jPanel.add((Component)this.maxSegSize);
        jPanel.add((Component)new JLabel(msgTranslator.get("(Bytes)", "TFTPD_SG_BYTES")));
        twoColumnLayoutManager.add((Component)new JLabel(msgTranslator.get("Maximum segment size", "TFTPD_SG_MAXIMUMSEGMENTSIZE")), (Component)jPanel);
        this.pane.addTab(this.service_tab_label, (Component)this.servicePanel);
        this.directories_tab_label = msgTranslator.get("Directories", "ALL_SG_DIRECTORIES");
        this.directoriesPanel.setLayout(new FlowLayout(1, 2, 2));
        jPanel = new JPanel((LayoutManager)new BorderLayout());
        jPanel.add((Component)new JLabel(msgTranslator.get("Access directories", "TFTPD_SG_ACCESSDIRECTORIES")), "North");
        this.accessDirs.setPrototypeCellValue((Object)"\\This\\is\\a\\really\\bogus\\path.");
        JScrollPane jScrollPane = new JScrollPane((Component)this.accessDirs, 22, 32);
        jPanel.add((Component)jScrollPane, "Center");
        this.directoriesPanel.add((Component)jPanel);
        jPanel = new JPanel();
        twoColumnLayoutManager = new TwoColumnLayoutManager((Container)jPanel);
        jPanel.setLayout(twoColumnLayoutManager);
        JButton jButton = new JButton(msgTranslator.get("Add", "ALL_SG_ADD"));
        twoColumnLayoutManager.add((Component)jButton);
        jButton.addActionListener((ActionListener)new 1());
        JButton jButton2 = new JButton(msgTranslator.get("Replace", "ALL_SG_REPLACE"));
        twoColumnLayoutManager.add((Component)jButton2);
        jButton2.addActionListener((ActionListener)new 2());
        JButton jButton3 = new JButton(msgTranslator.get("Remove", "ALL_SG_REMOVE"));
        twoColumnLayoutManager.add((Component)jButton3);
        jButton3.addActionListener((ActionListener)new 3());
        this.directoriesPanel.add((Component)jPanel);
        jPanel = new JPanel((LayoutManager)new BorderLayout());
        jPanel.add((Component)new JLabel(msgTranslator.get("Directory name", "TFTPD_SG_DIRECTORYNAME")), "North");
        jPanel.add((Component)this.dirName, "Center");
        this.dirBrowse = new JButton(msgTranslator.get("Browse", "ALL_SG_BROWSE"));
        JPanel jPanel2 = new JPanel((LayoutManager)new FlowLayout(1, 3, 3));
        jPanel2.add((Component)this.dirBrowse);
        jPanel.add((Component)jPanel2, "South");
        this.dirBrowse.addActionListener((ActionListener)new 4());
        this.directoriesPanel.add((Component)jPanel);
        this.pane.addTab(this.directories_tab_label, (Component)this.directoriesPanel);
        twoColumnLayoutManager = new TwoColumnLayoutManager((Container)this.tracePanel);
        this.trace_tab_label = msgTranslator.get("Trace", "ALL_SG_TRACE");
        this.tracePanel.setLayout(twoColumnLayoutManager);
        this.enableTrace.setText(msgTranslator.get("Enable trace", "ALL_SG_ENABLETRACE"));
        twoColumnLayoutManager.add((Component)this.enableTrace);
        this.traceBrowse = new JButton(msgTranslator.get("Browse", "ALL_SG_BROWSE"));
        jPanel = new JPanel((LayoutManager)new FlowLayout(0, 0, 0));
        jPanel.add((Component)this.traceFileName);
        JPanel jPanel3 = new JPanel((LayoutManager)new FlowLayout(0, 5, 0));
        jPanel3.add((Component)this.traceBrowse);
        jPanel.add((Component)jPanel3);
        this.traceBrowse.addActionListener((ActionListener)new 5());
        twoColumnLayoutManager.add((Component)new JLabel(msgTranslator.get("File name", "ALL_SG_FILENAME")), (Component)jPanel);
        jPanel3 = new JPanel((LayoutManager)new FlowLayout(0, 0, 0));
        jPanel3.add((Component)this.maxTraceSize);
        twoColumnLayoutManager.add((Component)new JLabel(msgTranslator.get("Maximum size (K)", "TFTPD_SG_MAXIMUMSIZE")), (Component)jPanel3);
        jPanel3 = new JPanel((LayoutManager)new FlowLayout(0, 0, 0));
        jPanel3.add((Component)this.numFiles);
        twoColumnLayoutManager.add((Component)new JLabel(msgTranslator.get("Number of files", "TFTPD_SG_NUMBEROFFILES")), (Component)jPanel3);
        jPanel3 = new JPanel((LayoutManager)new BorderLayout());
        jPanel3.add((Component)new JLabel(msgTranslator.get("Trace options", "TFTPD_SG_TRACEOPTIONS")), "North");
        this.traceOptions.setSelectionMode(2);
        this.traceOptions.setVisibleRowCount(4);
        JScrollPane jScrollPane2 = new JScrollPane((Component)this.traceOptions, 22, 32);
        jPanel3.add((Component)jScrollPane2, "Center");
        twoColumnLayoutManager.add((Component)jPanel3);
        this.pane.addTab(this.trace_tab_label, (Component)this.tracePanel);
        ((Container)((Object)this)).validate();
    }

    public ParameterSet getParameterSet() {
        this.ps = new TftpdParameterSet();
        this.ps.PortNumber = new Integer(this.portNum.getText());
        this.ps.EnableLogging = new Boolean(this.enableLogging.isSelected());
        this.ps.Timeout = new Integer(this.timeout.getText());
        this.ps.EnableWriteAccess = new Boolean(this.enableWrite.isSelected());
        this.ps.EnableReadAccess = new Boolean(this.enableRead.isSelected());
        this.ps.MaximumSegmentSize = new Integer(this.maxSegSize.getText());
        this.ps.RetryLimit = new Integer(this.retryLimit.getText());
        if (this.accessDirsVector.size() > 0) {
            this.ps.AccessDirectories = new String[this.accessDirsVector.size()];
            this.accessDirsVector.copyInto(this.ps.AccessDirectories);
        } else {
            this.ps.AccessDirectories = null;
        }
        this.ps.EnableTrace = new Boolean(this.enableTrace.isSelected());
        this.ps.MaximumTraceFileSize = new Integer(this.maxTraceSize.getText());
        this.ps.NumberOfTraceFiles = new Integer(this.numFiles.getText());
        this.ps.TraceOptions = this.getHighlightedOptions(this.traceOptions, this.numTraceOptions);
        this.ps.TraceFilename = new String(this.traceFileName.getText());
        return this.ps;
    }

    public void setParameterSet(ParameterSet parameterSet) {
        if (!(parameterSet instanceof TftpdParameterSet)) {
            return;
        }
        this.ps = (TftpdParameterSet)parameterSet;
        if (this.ps.PortNumber != null) {
            this.portNum.setText(this.ps.PortNumber.toString());
        }
        if (this.ps.EnableLogging != null) {
            this.enableLogging.setSelected(this.ps.EnableLogging.booleanValue());
        }
        if (this.ps.Timeout != null) {
            this.timeout.setText(this.ps.Timeout.toString());
        }
        if (this.ps.EnableWriteAccess != null) {
            this.enableWrite.setSelected(this.ps.EnableWriteAccess.booleanValue());
        }
        if (this.ps.EnableReadAccess != null) {
            this.enableRead.setSelected(this.ps.EnableReadAccess.booleanValue());
        }
        if (this.ps.MaximumSegmentSize != null) {
            this.maxSegSize.setText(this.ps.MaximumSegmentSize.toString());
        }
        if (this.ps.RetryLimit != null) {
            this.retryLimit.setText(this.ps.RetryLimit.toString());
        }
        if (this.ps.AccessDirectories != null) {
            this.accessDirsVector = new Vector(this.ps.AccessDirectories.length + 5);
            int n = 0;
            while (n < this.ps.AccessDirectories.length) {
                this.accessDirsVector.addElement(this.ps.AccessDirectories[n]);
                ++n;
            }
            this.accessDirs.setListData(this.accessDirsVector);
        }
        if (this.ps.EnableTrace != null) {
            this.enableTrace.setSelected(this.ps.EnableTrace.booleanValue());
        }
        if (this.ps.MaximumTraceFileSize != null) {
            this.maxTraceSize.setText(this.ps.MaximumTraceFileSize.toString());
        }
        if (this.ps.NumberOfTraceFiles != null) {
            this.numFiles.setText(this.ps.NumberOfTraceFiles.toString());
        }
        if (!this.traceOptionsAlreadySet) {
            if (this.tracenames == null) {
                this.tracenames = this.mt.get(DEFAULT_TRACENAMES, "TFTPD_SG_TRACENAMES");
            }
            Vector<String> vector = new Vector<String>(12);
            int n = 0;
            int n2 = this.tracenames.indexOf(124);
            int n3 = this.tracenames.length();
            while (n2 >= 0) {
                vector.addElement(this.tracenames.substring(n, n2));
                n = n2 + 1;
                n2 = n < n3 ? this.tracenames.indexOf(124, n) : -1;
            }
            if (n < n3) {
                vector.addElement(this.tracenames.substring(n));
            }
            this.numTraceOptions = vector.size();
            this.traceOptions.setListData(vector);
            this.traceOptionsAlreadySet = true;
        }
        if (this.ps.TraceOptions != null) {
            this.currTraceOptions = this.ps.TraceOptions;
            this.highlightOptions(this.traceOptions, this.numTraceOptions, this.ps.TraceOptions);
        }
        if (this.ps.TraceFilename != null) {
            this.traceFileName.setText(this.ps.TraceFilename.toString());
        }
    }

    private void highlightOptions(JList jList, int n, Integer n2) {
        Vector<Integer> vector = new Vector<Integer>(n);
        String string = Integer.toBinaryString(n2);
        int n3 = 0;
        int n4 = string.length() - 1;
        while (n4 >= 0 && n3 < n) {
            if (string.charAt(n4) == '1') {
                this.debug.print("Setting list index: " + n3);
                vector.addElement(new Integer(n3));
            }
            ++n3;
            --n4;
        }
        int[] nArray = new int[vector.size()];
        n4 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            nArray[n4++] = (Integer)enumeration.nextElement();
        }
        jList.setSelectedIndices(nArray);
    }

    private Integer getHighlightedOptions(JList jList, int n) {
        int n2 = this.currTraceOptions;
        n2 >>= n;
        int n3 = n - 1;
        while (n3 >= 0) {
            n2 <<= 1;
            if (jList.isSelectedIndex(n3)) {
                this.debug.print("Selected index = " + n3);
                ++n2;
            }
            --n3;
        }
        this.currTraceOptions = new Integer(n2);
        return this.currTraceOptions;
    }

    private boolean hasDups() {
        boolean bl = false;
        String string = this.dirName.getText();
        Enumeration enumeration = this.accessDirsVector.elements();
        while (enumeration.hasMoreElements() && !bl) {
            bl = ((String)enumeration.nextElement()).equals(string);
        }
        if (bl) {
            this.errorDialog((Component)((Object)this), this.mt.get("Duplicate directory name. Please retry.", "TFTPD_SG_DUPLICATEDIR"));
        }
        return bl;
    }

    private boolean empty() {
        boolean bl;
        boolean bl2 = bl = this.dirName.getText().length() == 0;
        if (bl) {
            this.errorDialog((Component)((Object)this), this.mt.get("Directory name is blank. Please supply a name and try again.", "TFTPD_SG_NODIRNAME"));
        }
        return bl;
    }

    private boolean someSelected() {
        boolean bl;
        boolean bl2 = bl = this.accessDirs.getSelectedValue() != null;
        if (!bl) {
            this.errorDialog((Component)((Object)this), this.mt.get("No files selected. Please select some files in the list and try again.", "TFTPD_SG_NONESELECTED"));
        }
        return bl;
    }

    private void addDirectory() {
        if (!this.hasDups() && !this.empty()) {
            this.accessDirsVector.addElement(this.dirName.getText());
            this.accessDirs.setListData(this.accessDirsVector);
            this.accessDirs.repaint();
        }
    }

    private void replDirectory() {
        if (!this.hasDups() && !this.empty() && this.someSelected()) {
            Object[] objectArray = this.accessDirs.getSelectedValues();
            int n = 0;
            while (n < objectArray.length) {
                this.accessDirsVector.removeElement(objectArray[n]);
                ++n;
            }
            this.accessDirsVector.addElement(this.dirName.getText());
            this.accessDirs.setListData(this.accessDirsVector);
            this.accessDirs.repaint();
        }
    }

    private void remDirectory() {
        if (this.someSelected()) {
            Object[] objectArray = this.accessDirs.getSelectedValues();
            int n = 0;
            while (n < objectArray.length) {
                this.accessDirsVector.removeElement(objectArray[n]);
                ++n;
            }
        }
        this.accessDirs.setListData(this.accessDirsVector);
        this.accessDirs.repaint();
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            TftpdDetails.this.addDirectory();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            TftpdDetails.this.replDirectory();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            TftpdDetails.this.remDirectory();
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            TftpdDetails.this.fileBrowse((JTextComponent)TftpdDetails.this.dirName);
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            TftpdDetails.this.fileBrowse((JTextComponent)TftpdDetails.this.traceFileName);
        }

        /* synthetic */ 5() {
        }
    }
}

