/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.config.agents.timed;

import com.ibm.eNetwork.onDemand.common.Copyright;
import com.ibm.eNetwork.onDemand.common.nativecode.NTRegistry;
import com.ibm.eNetwork.onDemand.config.agents.Host;
import com.ibm.eNetwork.onDemand.config.agents.NTBaseDaemon;
import com.ibm.eNetwork.onDemand.config.agents.NTRegistryUser;
import com.ibm.eNetwork.onDemand.config.agents.ParameterSet;
import com.ibm.eNetwork.onDemand.config.agents.timed.TimedParameterSet;
import com.ibm.eNetwork.onDemand.config.nls.MsgTranslator;
import com.ibm.eNetwork.onDemand.config.node.NodeMgr;
import com.ibm.eNetwork.onDemand.config.util.Log;
import java.util.Hashtable;
import java.util.Properties;

public class TimedDaemon
extends NTBaseDaemon
implements NTRegistryUser {
    private static final String cStmt1 = Copyright.COPYRIGHT_98;
    final String TIMED_PARAM = "\\TIMED\\Parameters";
    final String TIMED_TRACE = "\\TIMED\\Trace";
    Log log;
    MsgTranslator mt;
    NTRegistry m_RegIf = new NTRegistry();
    public static String DAEMON_ID = "Timed";
    TimedParameterSet wps;
    public final Integer DEFAULT_PORT_NUMBER = new Integer(37);
    public final Boolean DEFAULT_ADJUST_TO_LOCAL_TIME = new Boolean(false);
    public final Boolean DEFAULT_ENABLE_TRACE = new Boolean(false);
    public String Default_Trace_Filename;

    public TimedDaemon() {
        super("TIMED");
    }

    public void setNodeMgr(NodeMgr nodeMgr) {
        super.setNodeMgr(nodeMgr);
        if (nodeMgr != null) {
            this.log = nodeMgr.getLog();
            this.mt = nodeMgr.getMsgTranslator();
        }
        if (this.mt != null) {
            this.setLabel(this.mt.get("Timed", "TIMED_NAME"));
        }
    }

    public void setHost(Host host) {
        super.setHost(host);
        this.Default_Trace_Filename = String.valueOf(this.getHost().getInstalledDirectory("ETC")) + "/timed.trc";
    }

    public String getHtmlFile() {
        String string = "timed.html";
        return string;
    }

    public Properties getHelpProperties() {
        Properties properties = new Properties();
        ((Hashtable)properties).put("Contents", "timex.htm");
        ((Hashtable)properties).put("Window_Help", "");
        ((Hashtable)properties).put("How_Do_I", "timeh.htm");
        ((Hashtable)properties).put("Before_You_Start", "timeb.htm");
        ((Hashtable)properties).put("Window_timed_settings", "time.htm#TIMED_Port_number");
        ((Hashtable)properties).put("Window_timed_trace", "time.htm#TIMED_Enable_trace");
        return properties;
    }

    public ParameterSet getParameterSet() {
        this.getHost();
        this.wps = new TimedParameterSet();
        this.wps.PortNumber = this.DEFAULT_PORT_NUMBER;
        this.wps.AdjustToLocalTime = this.DEFAULT_ADJUST_TO_LOCAL_TIME;
        this.wps.EnableTrace = this.DEFAULT_ENABLE_TRACE;
        this.wps.TraceFileName = this.Default_Trace_Filename;
        this.load_data(this.wps);
        return this.wps;
    }

    public void setParameterSet(ParameterSet parameterSet) {
        if (parameterSet instanceof TimedParameterSet) {
            this.save_data((TimedParameterSet)parameterSet);
        }
    }

    public Boolean isTraceFileNameValid(TimedParameterSet timedParameterSet) {
        boolean bl = true;
        if (this.getHost() != null) {
            String string = timedParameterSet.TraceFileName;
            String string2 = string.replace('/', '\\');
            if (string.indexOf("\\") != -1) {
                string2 = string.substring(0, string.lastIndexOf("\\"));
                String string3 = string.substring(string.lastIndexOf("\\") + 1);
                if (string3.trim().equals("")) {
                    return new Boolean(false);
                }
                if (string2.endsWith(":")) {
                    string2 = String.valueOf(string2) + "\\";
                }
                bl = this.getHost().isDirectoryValid(string2);
            } else {
                return new Boolean(false);
            }
        }
        return new Boolean(bl);
    }

    public boolean isValid(ParameterSet parameterSet) {
        if (parameterSet instanceof TimedParameterSet) {
            TimedParameterSet timedParameterSet = (TimedParameterSet)parameterSet;
            return this.isTraceFileNameValid(timedParameterSet);
        }
        return false;
    }

    private void load_data(TimedParameterSet timedParameterSet) {
        timedParameterSet.PortNumber = this.load_Int_value("System\\CurrentControlSet\\Services\\TIMED\\Parameters", "ServerPort", timedParameterSet.PortNumber);
        timedParameterSet.AdjustToLocalTime = this.load_Boolean_value("System\\CurrentControlSet\\Services\\TIMED\\Parameters", "ServerAdjustTimeToLocal", timedParameterSet.AdjustToLocalTime);
        timedParameterSet.EnableTrace = this.load_Boolean_value("System\\CurrentControlSet\\Services\\TIMED\\Trace", "Trace", timedParameterSet.EnableTrace);
        if (this.getHost() != null) {
            timedParameterSet.TraceFileName = this.getHost().normalizePathName(this.load_String_value("System\\CurrentControlSet\\Services\\TIMED\\Trace", "TraceFilePath", timedParameterSet.TraceFileName));
        }
        this.setTraceStatus(timedParameterSet.EnableTrace);
    }

    private void save_data(TimedParameterSet timedParameterSet) {
        this.save_Int_value("System\\CurrentControlSet\\Services\\TIMED\\Parameters", "ServerPort", timedParameterSet.PortNumber);
        this.save_Boolean_value("System\\CurrentControlSet\\Services\\TIMED\\Parameters", "ServerAdjustTimeToLocal", timedParameterSet.AdjustToLocalTime);
        this.save_Boolean_value("System\\CurrentControlSet\\Services\\TIMED\\Trace", "Trace", timedParameterSet.EnableTrace);
        this.save_String_value("System\\CurrentControlSet\\Services\\TIMED\\Trace", "TraceFilePath", this.getHost().normalizePathName(timedParameterSet.TraceFileName));
    }
}

