/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.config.comm.client;

import com.ibm.eNetwork.onDemand.common.Copyright;
import com.ibm.eNetwork.onDemand.common.RegistryControl;
import com.ibm.eNetwork.onDemand.config.comm.NodeChangeEvent;
import com.ibm.eNetwork.onDemand.config.comm.NodeChangeListener;
import com.ibm.eNetwork.onDemand.config.comm.NodeInfo;
import com.ibm.eNetwork.onDemand.config.comm.NodeInfoList;
import com.ibm.eNetwork.onDemand.config.comm.SvrNode;
import com.ibm.eNetwork.onDemand.config.nls.ClientMsgViewer;
import com.ibm.eNetwork.onDemand.config.node.Node;
import com.ibm.eNetwork.onDemand.config.node.NodeList;
import com.ibm.eNetwork.onDemand.config.node.NodeMenuItemDescriptor;
import com.ibm.eNetwork.onDemand.config.node.NodeMenuItemDescriptorList;
import com.ibm.eNetwork.onDemand.config.node.NodeMgr;
import com.ibm.eNetwork.onDemand.config.util.Debug;
import java.awt.Container;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ClntNode
extends UnicastRemoteObject
implements NodeChangeListener,
Node {
    private static final String copyright = Copyright.COPYRIGHT_98;
    private NodeInfo nodeInfo;
    private static Hashtable nodeTable = new Hashtable();
    private static final int CACHE_REQUEST_SIZE = 50;
    private SvrNode rootSvrNode;
    private Debug debug = new Debug("ClntNode", false);
    private SvrNode svrNode;
    private int treeDepth;
    private Node parent;
    private Vector childList;
    private int childListSize;
    private Container container;
    private PropertyChangeSupport pcs;
    private NodeMgr nodeMgr;
    private boolean isRoot = false;

    public ClntNode() throws RemoteException {
        this.isRoot = true;
        this.pcs = new PropertyChangeSupport(this);
        this.debug.print("ClntNode root constructed.");
    }

    private ClntNode(ClntNode clntNode, NodeInfo nodeInfo) throws RemoteException {
        this.nodeInfo = nodeInfo;
        this.parent = clntNode;
        this.treeDepth = clntNode.getDepth() + 1;
        this.nodeInfo = nodeInfo;
        nodeTable.put(nodeInfo.getRefID(), this);
        this.rootSvrNode = clntNode.getRootSvrNode();
        this.pcs = new PropertyChangeSupport(this);
        this.isRoot = false;
        this.setNodeMgr(clntNode.getNodeMgr());
        this.translateStrings(this.nodeInfo);
        this.debug.print("ClntNode child for '" + nodeInfo.getRefID() + "' constructed.");
    }

    private SvrNode getRootSvrNode() {
        return this.rootSvrNode;
    }

    public void setURL(URL uRL) {
        this.isRoot = true;
        this.debug.print("Setting URL '" + uRL + "'");
        if (this.rootSvrNode == null) {
            try {
                this.debug.print("Getting remote reference to WKN");
                this.svrNode = this.getRemoteReference(uRL);
                if (this.svrNode != null) {
                    this.rootSvrNode = this.svrNode;
                    this.isRoot = true;
                    this.debug.print("WellKnownNode obtained.");
                } else {
                    this.debug.print("WellKnownNode not obtained!!");
                }
            }
            catch (Exception exception) {
                this.debug.print("ERROR: setURL Caught exception " + exception);
            }
            if (this.svrNode != null) {
                try {
                    this.nodeInfo = this.svrNode.getNodeInfo(this);
                    nodeTable.put(this.nodeInfo.getRefID(), this);
                    this.translateStrings(this.nodeInfo);
                    this.debug.print("Node '" + this.nodeInfo.getLabel() + "' has " + this.nodeInfo.getNumChildren() + " children");
                }
                catch (RemoteException remoteException) {
                    System.out.println("Could not get node info from server node.");
                    remoteException.printStackTrace();
                }
            }
        }
        try {
            this.debug.print("Exporting WKN ClntNode for external reference.");
            UnicastRemoteObject.exportObject(this);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void nodeChange(NodeChangeEvent nodeChangeEvent) throws RemoteException {
        this.debug.print("Node '" + nodeChangeEvent.getRefID() + "' changed.");
        if (!nodeChangeEvent.getRefID().equals(this.getUniqueName())) {
            this.debug.print("Routing to proper node...");
            NodeChangeListener nodeChangeListener = (NodeChangeListener)nodeTable.get(nodeChangeEvent.getRefID());
            if (nodeChangeListener != null) {
                try {
                    nodeChangeListener.nodeChange(nodeChangeEvent);
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
        } else {
            boolean bl = true;
            String string = nodeChangeEvent.getPropertyName();
            Object object = nodeChangeEvent.getNewValue();
            Object object2 = nodeChangeEvent.getOldValue();
            NodeInfo nodeInfo = nodeChangeEvent.getNodeInfo();
            this.translateStrings(nodeInfo);
            if (string.equals("label")) {
                object2 = this.getLabel();
                object = nodeInfo.getLabel();
            } else if (string.equals("icon")) {
                object2 = this.getIcon();
                object = nodeInfo.getIcon();
            } else if (string.equals("child")) {
                int n = (Integer)object;
                int n2 = (Integer)object2;
                if (n2 < 0 && n < 0) {
                    this.debug.print("Children vastly changed.");
                    this.childListSize = 0;
                    this.childList = null;
                } else if (n2 < this.childListSize) {
                    this.childListSize = n2;
                }
            } else if (string.equals("menuItem")) {
                object2 = this.getMenuItems();
                object = nodeInfo.getMenuItems();
            } else {
                bl = false;
                this.debug.print("Unrecognized property: " + string);
            }
            this.nodeInfo = nodeInfo;
            if (bl) {
                this.debug.print("Firing property change.");
                this.pcs.firePropertyChange(string, object2, object);
            }
        }
    }

    private boolean isWKN() {
        return this.isRoot;
    }

    public void finalize() {
        if (this.isWKN()) {
            try {
                this.svrNode.removeNodeChangeListener(this);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }
    }

    public Node getParent() {
        if (this.parent == null && !this.isWKN()) {
            this.parent = this.getNodeByUniqueName(this.nodeInfo.getParentRefID());
            if (this.parent == null) {
                this.debug.print("WARNING: no parent found for child node '" + this.getLabel() + "'");
            }
        }
        return this.parent;
    }

    public NodeList getChildren() {
        return this.getChildren(0, 0);
    }

    public synchronized NodeList getChildren(int n, int n2) {
        NodeList nodeList = null;
        if (n < 0) {
            n = 0;
        }
        if (this.getNumChildren() > 0) {
            int n3;
            if (n2 <= 0) {
                n2 = this.getNumChildren() - n;
            }
            if ((n3 = n + n2 - 1) >= this.getNumChildren()) {
                n3 = this.getNumChildren() - 1;
            }
            this.debug.print("rhs=" + n3 + ", listsize=" + this.childListSize);
            if (this.childListSize <= n3) {
                if (this.rootSvrNode != null) {
                    SvrNode svrNode = this.getRemoteReference();
                    if (svrNode != null) {
                        NodeInfoList nodeInfoList = null;
                        int n4 = this.childListSize;
                        int n5 = ((n3 - this.childListSize + 1) / 50 + 1) * 50;
                        int n6 = 0;
                        if (n5 > this.getNumChildren() - n4) {
                            n5 = this.getNumChildren() - n4;
                        }
                        this.debug.print("Requesting children " + n4 + ", width=" + n5);
                        try {
                            nodeInfoList = svrNode.bsGetChildren(n4, n5);
                            n6 = nodeInfoList.size();
                            this.childListSize += n6;
                        }
                        catch (Exception exception) {
                            this.debug.print("Exception " + exception + " while getting children NIs");
                            n6 = 0;
                        }
                        if (this.childList == null) {
                            this.childList = new Vector(this.getNumChildren());
                        }
                        int n7 = 0;
                        while (n7 < n6) {
                            NodeInfo nodeInfo = (NodeInfo)nodeInfoList.elementAt(n7);
                            this.debug.print("Node '" + nodeInfo.getLabel() + "' has " + nodeInfo.getNumChildren() + " children");
                            ClntNode clntNode = (ClntNode)nodeTable.get(nodeInfo.getRefID());
                            if (clntNode == null) {
                                try {
                                    clntNode = new ClntNode(this, nodeInfo);
                                }
                                catch (Exception exception) {}
                            }
                            this.childList.addElement(clntNode);
                            ++n7;
                        }
                        this.debug.print("New list size: " + this.childListSize);
                        nodeInfoList = null;
                    } else {
                        this.debug.print("Could not get remote reference in getChildren()");
                    }
                } else {
                    this.debug.print("No root SvrNode exists in getChildren()");
                }
            }
            if (this.childListSize > n3) {
                nodeList = new NodeList(n2);
                while (n2 > 0) {
                    nodeList.addElement(this.childList.elementAt(n));
                    ++n;
                    --n2;
                }
            } else {
                this.debug.print("getChildren() Could not get requested information.");
            }
        }
        if (nodeList == null) {
            nodeList = new NodeList(0);
        }
        return nodeList;
    }

    public Node getChildAt(int n) {
        Node node = null;
        if (n < 0) {
            n = 0;
        }
        if (n < this.getNumChildren()) {
            if (n >= this.childListSize) {
                this.getChildren(n, 1);
            }
            node = (Node)this.childList.elementAt(n);
        } else {
            this.debug.print("index exceeds number of children.");
        }
        return node;
    }

    private synchronized SvrNode getRemoteReference(URL uRL) {
        this.debug.print("enter getRemoteReference()");
        String string = uRL.getHost();
        String string2 = uRL.getFile();
        if (string.equals("")) {
            string = "localhost";
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "/Agents.WKN";
        } else if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        try {
            this.debug.print("Getting registry at server '" + string + "'");
            Registry registry = RegistryControl.getRegistry(string);
            this.debug.print("Getting reference to object '" + string2 + "'");
            this.svrNode = (SvrNode)registry.lookup(string2);
            if (this.svrNode != null) {
                this.debug.print("node obtained. uniqueName=" + string2);
            } else {
                this.debug.print("node not obtained!! uniqueName=" + string2);
                this.svrNode = null;
            }
        }
        catch (Exception exception) {
            this.debug.print("ERROR: getRemoteObject Caught exception " + exception);
            this.svrNode = null;
        }
        this.debug.print("exit getRemoteReference()");
        return this.svrNode;
    }

    private SvrNode getRemoteReference() {
        if (this.rootSvrNode != null) {
            if (this.svrNode == null) {
                try {
                    this.svrNode = this.rootSvrNode.getSvrNodeByUniqueName(this.getUniqueName());
                }
                catch (RemoteException remoteException) {
                    this.debug.print("Could not get SvrNode " + this.getUniqueName());
                }
            }
        } else {
            this.debug.print("No rootSvrNode exists in getRemoteReference()");
        }
        return this.svrNode;
    }

    public int getDepth() {
        return this.treeDepth;
    }

    public int getIndex(Node node) {
        return this.childList.indexOf(node);
    }

    public String toString() {
        return this.getLabel();
    }

    public void insert(Node node, int n) {
        this.debug.print("Insert not supported.");
    }

    public void remove(int n) {
        this.debug.print("Remove not supported.");
    }

    public NodeMenuItemDescriptorList getMenuItemDescriptors() {
        return this.nodeInfo.getMenuItems();
    }

    public Object performOperation(int n, Object object) {
        Object object2 = null;
        if (this.getRemoteReference() != null) {
            try {
                object2 = this.svrNode.bsPerformOperation(n, object);
            }
            catch (RemoteException remoteException) {
                System.out.println("Could not perform operation " + n + " on server node.");
            }
        } else {
            object2 = "<NULL>";
        }
        return object2;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public NodeMgr getNodeMgr() {
        return this.nodeMgr;
    }

    public void setNodeMgr(NodeMgr nodeMgr) {
        this.nodeMgr = nodeMgr;
    }

    public String getUniqueName() {
        return this.nodeInfo.getRefID();
    }

    public Node getNodeByUniqueName(String string) {
        ClntNode clntNode = null;
        NodeInfo nodeInfo = null;
        if (this.getRemoteReference() != null) {
            clntNode = (ClntNode)nodeTable.get(string);
            if (clntNode == null) {
                System.out.println("Node '" + string + "' not found in cache.");
                try {
                    nodeInfo = this.svrNode.getNodeInfoByUniqueName(string);
                }
                catch (RemoteException remoteException) {
                    System.out.println("Could not get node info by unique name from server node.");
                }
                if (nodeInfo != null) {
                    try {
                        Node node = this.getNodeByUniqueName(nodeInfo.getParentRefID());
                        if (node == null) {
                            node = this;
                        }
                        clntNode = new ClntNode((ClntNode)node, nodeInfo);
                        clntNode.setNodeMgr(this.nodeMgr);
                    }
                    catch (Exception exception) {}
                }
            } else {
                System.out.println("Node '" + string + "' was found in cache.");
            }
        }
        return clntNode;
    }

    public String getLabel() {
        String string = null;
        if (this.nodeInfo != null) {
            string = this.nodeInfo.getLabel();
        }
        return string;
    }

    public boolean isLeaf() {
        if (this.nodeInfo != null) {
            return this.nodeInfo.isLeaf();
        }
        return this.getNumChildren() == 0;
    }

    public String getIcon() {
        String string = null;
        if (this.nodeInfo != null) {
            string = this.nodeInfo.getIcon();
        }
        return string;
    }

    public int getNumChildren() {
        int n = 0;
        if (this.nodeInfo != null) {
            n = this.nodeInfo.getNumChildren();
        }
        return n;
    }

    public void setLabel(String string) {
        this.nodeInfo.setLabel(string);
    }

    public void setIcon(String string) {
        this.nodeInfo.setIcon(string);
    }

    private NodeMenuItemDescriptorList getMenuItems() {
        NodeMenuItemDescriptorList nodeMenuItemDescriptorList = null;
        if (this.nodeInfo != null) {
            nodeMenuItemDescriptorList = this.nodeInfo.getMenuItems();
        }
        return nodeMenuItemDescriptorList;
    }

    private void translateStrings(NodeInfo nodeInfo) {
        nodeInfo.setLabel(ClientMsgViewer.view(nodeInfo.getLabel(), this.nodeMgr));
        NodeMenuItemDescriptorList nodeMenuItemDescriptorList = nodeInfo.getMenuItems();
        Enumeration enumeration = nodeMenuItemDescriptorList.elements();
        while (enumeration.hasMoreElements()) {
            this.translateMenuStrings((NodeMenuItemDescriptor)enumeration.nextElement());
        }
    }

    private void translateMenuStrings(NodeMenuItemDescriptor nodeMenuItemDescriptor) {
        NodeMenuItemDescriptorList nodeMenuItemDescriptorList;
        if (nodeMenuItemDescriptor.getLabel() != null) {
            nodeMenuItemDescriptor.setLabel(ClientMsgViewer.view(nodeMenuItemDescriptor.getLabel(), this.nodeMgr));
        }
        if (!nodeMenuItemDescriptor.isLeaf() && (nodeMenuItemDescriptorList = nodeMenuItemDescriptor.getNmidl()) != null) {
            Enumeration enumeration = nodeMenuItemDescriptorList.elements();
            while (enumeration.hasMoreElements()) {
                this.translateMenuStrings((NodeMenuItemDescriptor)enumeration.nextElement());
            }
        }
    }
}

