/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.config.comm.server;

import com.ibm.eNetwork.onDemand.common.Copyright;
import com.ibm.eNetwork.onDemand.config.comm.NodeChangeEvent;
import com.ibm.eNetwork.onDemand.config.comm.NodeChangeListener;
import com.ibm.eNetwork.onDemand.config.comm.NodeInfo;
import com.ibm.eNetwork.onDemand.config.comm.NodeInfoList;
import com.ibm.eNetwork.onDemand.config.comm.SvrNode;
import com.ibm.eNetwork.onDemand.config.comm.server.NodeChangeNotifierThread;
import com.ibm.eNetwork.onDemand.config.node.Node;
import com.ibm.eNetwork.onDemand.config.node.NodeList;
import com.ibm.eNetwork.onDemand.config.util.Debug;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BaseSvrNode
extends UnicastRemoteObject
implements SvrNode,
PropertyChangeListener {
    private static final String copyright = Copyright.COPYRIGHT_98;
    private static Vector pcs = null;
    private static Hashtable nodeTable = new Hashtable();
    private Debug debug = new Debug("BaseSvrNode", false);
    private BaseSvrNode parent;
    private Node node;
    private Node clientRootNode;
    private NodeInfo oldNodeInfo;

    public BaseSvrNode() throws RemoteException {
    }

    private BaseSvrNode(Node node) throws RemoteException {
        this.node = node;
        nodeTable.put(node.getUniqueName(), this);
        node.addPropertyChangeListener(this);
    }

    public BaseSvrNode(String string, Node node, Registry registry) throws RemoteException {
        this(node);
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            this.debug.print("Registering BaseSvrNode '" + node.getLabel() + "' in RMI registry under name '" + string + "'");
            registry.rebind(string, this);
            this.debug.print("BaseSvrNode registered.");
        }
        catch (Exception exception) {
            this.debug.print("BaseSvrNode  err: " + exception.getMessage());
            exception.printStackTrace();
        }
        pcs = new Vector(50);
    }

    public BaseSvrNode(BaseSvrNode baseSvrNode, Node node) throws RemoteException {
        this(node);
        this.parent = baseSvrNode;
    }

    public synchronized void addNodeChangeListener(NodeChangeListener nodeChangeListener) throws RemoteException {
        if (pcs != null) {
            pcs.addElement(nodeChangeListener);
        }
    }

    public synchronized void removeNodeChangeListener(NodeChangeListener nodeChangeListener) throws RemoteException {
        if (pcs != null) {
            pcs.removeElement(nodeChangeListener);
        }
    }

    private BaseSvrNode getBaseServerNode(Node node, String string) {
        BaseSvrNode baseSvrNode;
        block2: {
            baseSvrNode = (BaseSvrNode)nodeTable.get(node.getUniqueName());
            if (baseSvrNode != null) break block2;
            try {
                baseSvrNode = new BaseSvrNode(this, node);
            }
            catch (Exception exception) {}
        }
        return baseSvrNode;
    }

    public NodeInfoList bsGetChildren(int n, int n2) throws RemoteException {
        this.debug.print("entry bsGetChildren(" + n + "," + n2 + ")");
        NodeInfoList nodeInfoList = null;
        NodeList nodeList = this.node.getChildren();
        int n3 = nodeList != null ? nodeList.size() : 0;
        String string = this.getClass().getName();
        if (n < 0) {
            n = 0;
        }
        if (n2 <= 0) {
            n2 = n3;
        }
        if (n < n3) {
            if (n + n2 > n3) {
                n2 = n3 - n;
            }
            nodeInfoList = new NodeInfoList(n2);
            int n4 = n + n2;
            int n5 = n;
            while (n5 < n4) {
                BaseSvrNode baseSvrNode = this.getBaseServerNode((Node)nodeList.elementAt(n5), string);
                try {
                    nodeInfoList.addElement(baseSvrNode.getNodeInfo());
                }
                catch (Exception exception) {}
                ++n5;
            }
        } else {
            this.debug.print("Get children request out of bounds.");
        }
        if (nodeInfoList == null) {
            nodeInfoList = new NodeInfoList(0);
        }
        this.debug.print("exit list size=" + nodeInfoList.size());
        return nodeInfoList;
    }

    private Enumeration getChildrenBSN() {
        Enumeration enumeration = this.node.getChildren().elements();
        Vector<BaseSvrNode> vector = new Vector<BaseSvrNode>(this.node.getNumChildren());
        String string = this.getClass().getName();
        while (enumeration.hasMoreElements()) {
            BaseSvrNode baseSvrNode = this.getBaseServerNode((Node)enumeration.nextElement(), string);
            vector.addElement(baseSvrNode);
        }
        return vector.elements();
    }

    public Object bsPerformOperation(int n, Object object) throws RemoteException {
        Object object2 = null;
        if (this.node != null) {
            object2 = this.node.performOperation(n, object);
        }
        if (object2 == null) {
            object2 = new String("<NULL>");
        }
        return object2;
    }

    public NodeInfo getNodeInfo(NodeChangeListener nodeChangeListener) throws RemoteException {
        this.addNodeChangeListener(nodeChangeListener);
        return this.getNodeInfo();
    }

    public NodeInfo getNodeInfo() throws RemoteException {
        return new NodeInfo(this.node);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (pcs != null) {
            int n = 0;
            int n2 = pcs.size();
            NodeInfo nodeInfo = null;
            try {
                nodeInfo = this.getNodeInfo();
            }
            catch (Exception exception) {
                System.err.println("Could not create newNodeInfo");
            }
            n = 0;
            while (n < n2) {
                NodeChangeListener nodeChangeListener = (NodeChangeListener)pcs.elementAt(n);
                NodeChangeEvent nodeChangeEvent = new NodeChangeEvent(this.node.getUniqueName(), propertyChangeEvent.getPropertyName(), nodeInfo, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                NodeChangeNotifierThread nodeChangeNotifierThread = new NodeChangeNotifierThread(this, nodeChangeListener, nodeChangeEvent);
                nodeChangeNotifierThread.start();
                ++n;
            }
            this.oldNodeInfo = nodeInfo;
        }
    }

    public NodeInfo getNodeInfoByUniqueName(String string) throws RemoteException {
        BaseSvrNode baseSvrNode;
        NodeInfo nodeInfo = null;
        if (string != null && (baseSvrNode = this.getBSNByUniqueName(string)) != null) {
            nodeInfo = baseSvrNode.getNodeInfo();
        }
        return nodeInfo;
    }

    private BaseSvrNode getBSNByUniqueName(String string) {
        BaseSvrNode baseSvrNode = null;
        if (string.equals(this.getUniqueName())) {
            baseSvrNode = this;
        } else {
            Node node = this.node.getNodeByUniqueName(string);
            if (node != null) {
                baseSvrNode = this.getBaseServerNode(node, this.getClass().getName());
            }
        }
        return baseSvrNode;
    }

    public SvrNode getSvrNodeByUniqueName(String string) throws RemoteException {
        SvrNode svrNode = null;
        try {
            svrNode = (SvrNode)nodeTable.get(string);
        }
        catch (Exception exception) {}
        return svrNode;
    }

    private String getUniqueName() {
        return this.node.getUniqueName();
    }
}

