/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.config.comm.server;

import com.ibm.eNetwork.onDemand.common.Copyright;
import com.ibm.eNetwork.onDemand.common.RegistryControl;
import com.ibm.eNetwork.onDemand.config.comm.server.BaseSvrNode;
import com.ibm.eNetwork.onDemand.config.gui.SvrGuiContext;
import com.ibm.eNetwork.onDemand.config.node.Node;
import com.ibm.eNetwork.onDemand.config.node.NodeMgr;
import com.ibm.eNetwork.onDemand.config.util.Debug;
import com.ibm.eNetwork.onDemand.config.util.DummyLog;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NodeServlet
extends HttpServlet {
    private static final String copyright = Copyright.COPYRIGHT_98;
    private static final String DEFAULT_NODEMGR = "com.ibm.eNetwork.onDemand.config.comm.agents.AgentsNodeMgr";
    private static final String DEFAULT_ROOTLOCATION = "Agents.WKN";
    private String nodeMgrClass;
    private String rootLocation;
    private String messages;
    private String optionalParm;
    private BaseSvrNode bsn;
    private boolean initialized = false;
    private Debug debug = new Debug("NodeServlet", true);
    private static boolean df = true;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.debug.print("************************************************************");
        this.addMessage("NodeServlet initialization at " + new Date().toString());
        try {
            this.initialize();
            return;
        }
        catch (Exception exception) {
            this.addMessage("ERROR: NodeServlet caught exception during init: " + exception);
            return;
        }
    }

    private void initialize() throws RemoteException {
        if (df) {
            this.debug.print("Initialize entry");
        }
        if (!this.initialized) {
            boolean bl;
            block27: {
                if (df) {
                    this.debug.print("Initializing");
                }
                this.initialized = true;
                Registry registry = RegistryControl.startRegistry();
                bl = false;
                this.nodeMgrClass = this.getInitParameter("nodeMgr");
                this.rootLocation = this.getInitParameter("rootLocation");
                this.optionalParm = this.getInitParameter("parameter");
                if (df) {
                    this.debug.print("Parameters obtained.");
                }
                if (this.nodeMgrClass == null) {
                    this.addMessage("INFO: Using default node manager.");
                    this.nodeMgrClass = DEFAULT_NODEMGR;
                }
                if (this.rootLocation == null) {
                    this.addMessage("INFO: Using default root location.");
                    this.rootLocation = DEFAULT_ROOTLOCATION;
                }
                if (df) {
                    this.debug.print("nodeMgr='" + this.nodeMgrClass + "'");
                    this.debug.print("rootLocation='" + this.rootLocation + "'");
                    this.debug.print("parameter='" + (this.optionalParm == null ? "<NULL>" : this.optionalParm) + "'");
                }
                NodeMgr nodeMgr = null;
                try {
                    if (df) {
                        this.debug.print("Getting node manager '" + this.nodeMgrClass + "'");
                    }
                    nodeMgr = NodeMgr.getNodeMgr(this.nodeMgrClass);
                }
                catch (Exception exception) {
                    this.addMessage("Caught exception while getting node manager: " + exception);
                    nodeMgr = null;
                }
                if (nodeMgr != null) {
                    if (df) {
                        this.debug.print("Setting gui context.");
                    }
                    nodeMgr.setGuiContext(new SvrGuiContext());
                    nodeMgr.setLog(new DummyLog());
                    Node node = null;
                    try {
                        if (df) {
                            this.debug.print("Getting root node with optional parm=" + this.optionalParm);
                        }
                        node = nodeMgr.getRoot(this.optionalParm);
                    }
                    catch (Exception exception) {
                        this.addMessage("Caught exception while getting root node: " + exception);
                        node = null;
                    }
                    if (node != null) {
                        try {
                            if (df) {
                                this.debug.print("Getting base svr node. Registry name: '" + this.rootLocation + "'");
                            }
                            this.bsn = new BaseSvrNode(this.rootLocation, node, registry);
                            if (this.bsn != null) {
                                if (df) {
                                    this.debug.print("Node registered.");
                                }
                                bl = true;
                                break block27;
                            }
                            this.addMessage("ERROR: BSN not created.");
                        }
                        catch (Exception exception) {
                            this.addMessage("ERROR: Caught exception while getting BSN: " + exception);
                            this.bsn = null;
                        }
                    } else {
                        this.addMessage("ERROR: Could not obtain root node.");
                    }
                } else {
                    this.addMessage("ERROR: Could not obtain node manager.");
                }
            }
            if (bl) {
                this.addMessage("INFO: Node manager successfully registered.");
            } else {
                this.addMessage("ERROR: Node manager could not be registered.");
            }
        } else {
            this.debug.print("INFO: Already initialized.");
        }
        if (df) {
            this.debug.print("Initialize exit");
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (df) {
            this.debug.print("doGet entry");
        }
        try {
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            servletOutputStream.println("<html> <head>");
            servletOutputStream.println("<title>Configuration Management Servlet</title>");
            servletOutputStream.println("</head>");
            servletOutputStream.println("<body>");
            servletOutputStream.println("<center><h1>Configuration Management Servlet</h1></center>");
            servletOutputStream.println("<hr>");
            servletOutputStream.println("<h2>Parameters</h2><P>");
            servletOutputStream.println("<UL>");
            servletOutputStream.println("<LI>Node Manager: ");
            servletOutputStream.println(this.nodeMgrClass == null ? "NULL" : this.nodeMgrClass);
            servletOutputStream.println("</li>");
            servletOutputStream.println("<LI>Registered as: ");
            servletOutputStream.println(this.rootLocation == null ? "NULL" : this.rootLocation);
            servletOutputStream.println("</li>");
            servletOutputStream.println("<LI>Parameter: ");
            servletOutputStream.println(this.optionalParm == null ? "NULL" : this.optionalParm);
            servletOutputStream.println("</li>");
            servletOutputStream.println("</ul></p>");
            servletOutputStream.println("<h2>Messages</h2><P><OL>" + (this.messages == null ? "none." : this.messages));
            servletOutputStream.println("</ol></p>");
            servletOutputStream.println("<h2>Debugging</h2><P>Turned " + (df ? "on" : "off") + ".</p>");
            servletOutputStream.println("</body> </html>");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new Error(throwable.getMessage());
        }
        if (df) {
            this.debug.print("doGet exit.");
        }
    }

    public String getServletInfo() {
        return "This servlet bootstraps the Configuration Management Server.";
    }

    private void addMessage(String string) {
        if (this.messages == null) {
            this.messages = "";
        }
        if (string == null) {
            string = "";
        }
        if (df) {
            this.debug.print("MSG: " + string);
        }
        this.messages = String.valueOf(this.messages) + "<LI>" + string + "</li>";
    }
}

