/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.config.filesys;

import com.ibm.eNetwork.onDemand.config.filesys.FileNode;
import com.ibm.eNetwork.onDemand.config.filesys.FileSysNode;
import com.ibm.eNetwork.onDemand.config.node.Node;
import com.ibm.eNetwork.onDemand.config.node.NodeList;
import com.ibm.eNetwork.onDemand.config.node.NodeMenuItemDescriptor;
import com.ibm.eNetwork.onDemand.config.node.NodeMenuItemDescriptorList;
import com.ibm.eNetwork.onDemand.config.util.Debug;
import java.io.File;
import java.util.Vector;

public class DirNode
extends FileSysNode {
    private Debug debug = new Debug("DirNode", true);
    private static final String DIRURL = "images/closed.gif";
    Vector children;
    NodeMenuItemDescriptorList nmidl = new NodeMenuItemDescriptorList(2);

    public DirNode(String string) {
        this(null, new File(string));
    }

    public DirNode(DirNode dirNode, File file) {
        super(dirNode, file);
        this.debug.print("DirNode(" + dirNode + ", " + file + ")");
        this.nmidl.addElement(new NodeMenuItemDescriptor("CommonNodeMenuItem", "com.ibm.eNetwork.onDemand.config.filesys.CommonNodeMenuItem", true));
        this.nmidl.addElement(new NodeMenuItemDescriptor("ConfigureHost", "com.ibm.eNetwork.onDemand.config.filesys.DisplayURLMenuItem", true));
    }

    void loadChildren() {
        if (this.children == null) {
            File file = this.getFile();
            String[] stringArray = file.list();
            this.children = new Vector(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(file, stringArray[n]);
                if (file2.isDirectory()) {
                    this.children.addElement(new DirNode(this, file2));
                } else {
                    this.children.addElement(new FileNode(this, file2));
                }
                ++n;
            }
        }
    }

    public boolean isLeaf() {
        return false;
    }

    public Node getChildAt(int n) {
        this.debug.print("getChildAt " + n);
        String[] stringArray = this.getFile().list();
        if (stringArray.length > n) {
            File file = new File(this.getFile(), stringArray[n]);
            if (file.isDirectory()) {
                return new DirNode(this, file);
            }
            return new FileNode(this, file);
        }
        return null;
    }

    public int getNumChildren() {
        String[] stringArray = this.getFile().list();
        this.debug.print("getNumChildren " + stringArray.length);
        return stringArray.length;
    }

    public NodeList getChildren() {
        this.debug.print("getChildren");
        String[] stringArray = this.getFile().list();
        int n = stringArray.length;
        NodeList nodeList = new NodeList(n);
        int n2 = 0;
        while (n2 < n) {
            File file = new File(this.getFile(), stringArray[n2]);
            if (file.isDirectory()) {
                nodeList.addElement(new DirNode(this, file));
            } else {
                nodeList.addElement(new FileNode(this, file));
            }
            ++n2;
        }
        return nodeList;
    }

    public int getIndex(Node node) {
        this.debug.print("getIndex " + node);
        String[] stringArray = this.getFile().list();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(node.getUniqueName())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void insert(Node node, int n) {
        System.err.println("Insert not implemented.");
    }

    public void remove(int n) {
        System.err.println("Remove not implemented.");
    }

    public NodeMenuItemDescriptorList getMenuItemDescriptors() {
        return this.nmidl;
    }

    public Object performOperation(int n, Object object) {
        System.err.println("Dirnode operation: " + n);
        return new String("<NULL>");
    }

    public String getIcon() {
        return DIRURL;
    }

    public Node getNodeByUniqueName(String string) {
        this.debug.print("getNodeByUniqueName from " + this + ":" + string);
        if (string.equals(this.getUniqueName())) {
            return this;
        }
        File file = new File(string);
        if (file.exists()) {
            Vector<File> vector = new Vector<File>();
            vector.addElement(file);
            while (file.getParent() != null && !file.equals(this.getFile())) {
                file = new File(file.getParent());
                vector.addElement(file);
            }
            if (!file.equals(this.getFile())) {
                this.debug.print(this + " is not parent of " + file);
                return null;
            }
            if (vector.size() > 1) {
                int n = vector.size();
                DirNode dirNode = this;
                int n2 = n - 2;
                while (n2 >= 0) {
                    File file2 = (File)vector.elementAt(n2);
                    FileSysNode fileSysNode = file2.isDirectory() ? new DirNode(dirNode, file2) : new FileNode(dirNode, file2);
                    dirNode = fileSysNode;
                    --n2;
                }
                return dirNode;
            }
            return this;
        }
        return null;
    }
}

