/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.config.filesys;

import com.ibm.eNetwork.onDemand.config.nls.IdentMsgTranslator;
import com.ibm.eNetwork.onDemand.config.nls.MsgTranslator;
import com.ibm.eNetwork.onDemand.config.node.BaseMenuItem;
import com.ibm.eNetwork.onDemand.config.node.Node;
import com.ibm.eNetwork.onDemand.config.node.NodeMgr;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class RenameFileNodeMenuItem
extends BaseMenuItem
implements WindowListener,
ActionListener {
    public static final String LABEL_TAG = "RenameFileNodeMenuItem";
    public static final String DEFAULT_LABEL = "Rename node";
    public static final String OK_LABEL = "OK";
    public static final String RENAME_LABEL = "Rename to: ";
    public static final String OK_TAG = "OK";
    public static final String RENAME_TAG = "RenameTo";
    private String label = "Rename node";
    private transient Node node;
    private transient NodeMgr nodeMgr;
    private transient TextField ta;

    public String getLabel() {
        return this.label;
    }

    public void setNode(Node node) {
        this.node = node;
        this.nodeMgr = this.node.getNodeMgr();
        this.label = this.getMsgTrans().get(DEFAULT_LABEL, LABEL_TAG);
        this.ta = new TextField(20);
    }

    private MsgTranslator getMsgTrans() {
        MsgTranslator msgTranslator = this.nodeMgr != null ? this.nodeMgr.getMsgTranslator() : new IdentMsgTranslator();
        return msgTranslator;
    }

    public boolean performMenuItem() {
        boolean bl;
        block5: {
            MsgTranslator msgTranslator = this.getMsgTrans();
            Frame frame = new Frame(msgTranslator.get(DEFAULT_LABEL, LABEL_TAG));
            frame.setLayout(new FlowLayout());
            System.out.println("Renaming file: '" + this.node.getLabel() + "'");
            bl = false;
            if (this.node != null) {
                try {
                    if (frame != null) {
                        Label label = new Label(msgTranslator.get(RENAME_LABEL, RENAME_TAG));
                        Button button = new Button(msgTranslator.get("OK", "OK"));
                        ((TextComponent)this.ta).setText(this.node.getLabel());
                        frame.add(label);
                        frame.add(this.ta);
                        frame.add(button);
                        button.addActionListener(this);
                        ((Component)frame).setSize(300, 200);
                        ((Component)frame).setVisible(true);
                        frame.addWindowListener(this);
                        bl = true;
                        break block5;
                    }
                    System.out.println("Frame is null!");
                }
                catch (Exception exception) {
                    System.out.println("PerformMenuItem Caught exception: " + exception);
                }
            } else {
                System.out.println("PerformMenuItem: No node for remote operation.");
            }
        }
        return bl;
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        Window window = windowEvent.getWindow();
        window.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
        Window window = windowEvent.getWindow();
        window.dispose();
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.ta.getText();
        if (!string.equals(this.node.getLabel())) {
            this.node.performOperation(2, string);
        }
    }
}

