/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.config.gui;

import com.ibm.eNetwork.onDemand.config.gui.NodeMenuItemAction;
import com.ibm.eNetwork.onDemand.config.node.Node;
import com.ibm.eNetwork.onDemand.config.node.NodeMenuItem;
import com.ibm.eNetwork.onDemand.config.node.NodeMenuItemDescriptor;
import com.ibm.eNetwork.onDemand.config.node.NodeMenuItemDescriptorList;
import com.ibm.eNetwork.onDemand.config.util.Debug;
import com.sun.java.swing.Action;
import com.sun.java.swing.JMenu;
import com.sun.java.swing.JMenuItem;
import com.sun.java.swing.JPopupMenu;
import com.sun.java.swing.JTree;
import com.sun.java.swing.tree.TreePath;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;

public class NodeMouseListener
extends MouseAdapter {
    Debug debug = new Debug("NodeMouseListener", false);

    Node getNode(MouseEvent mouseEvent) {
        JTree jTree = (JTree)mouseEvent.getSource();
        TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null) {
            return (Node)treePath.getLastPathComponent();
        }
        return null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.debug.print("mouseClicked: " + mouseEvent);
        if (mouseEvent.getClickCount() > 1) {
            Node node = this.getNode(mouseEvent);
            if (node == null) {
                return;
            }
            NodeMenuItemDescriptorList nodeMenuItemDescriptorList = node.getMenuItemDescriptors();
            if (nodeMenuItemDescriptorList == null || nodeMenuItemDescriptorList.size() <= 0) {
                return;
            }
            Enumeration enumeration = nodeMenuItemDescriptorList.elements();
            while (enumeration.hasMoreElements()) {
                NodeMenuItemDescriptor nodeMenuItemDescriptor = (NodeMenuItemDescriptor)enumeration.nextElement();
                if (!nodeMenuItemDescriptor.isDefault()) continue;
                String string = nodeMenuItemDescriptor.getClassname();
                try {
                    this.getClass();
                    NodeMenuItem nodeMenuItem = (NodeMenuItem)Class.forName(string).newInstance();
                    if (nodeMenuItem == null) continue;
                    nodeMenuItem.setNode(node);
                    nodeMenuItem.setCargo(nodeMenuItemDescriptor.getCargo());
                    nodeMenuItem.performMenuItem();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.debug.print("mousePressed: " + mouseEvent);
        this.handlePopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.debug.print("mouseReleased: " + mouseEvent);
        this.handlePopup(mouseEvent);
    }

    private JMenu buildPopup(NodeMenuItemDescriptor nodeMenuItemDescriptor, Node node) {
        JMenu jMenu = new JMenu(nodeMenuItemDescriptor.getLabel());
        NodeMenuItemDescriptorList nodeMenuItemDescriptorList = nodeMenuItemDescriptor.getNmidl();
        Enumeration enumeration = nodeMenuItemDescriptorList.elements();
        while (enumeration.hasMoreElements()) {
            NodeMenuItemDescriptor nodeMenuItemDescriptor2 = (NodeMenuItemDescriptor)enumeration.nextElement();
            if (nodeMenuItemDescriptor2.isSeparator()) {
                jMenu.addSeparator();
                continue;
            }
            if (nodeMenuItemDescriptor2.isLeaf()) {
                jMenu.add((Action)new NodeMenuItemAction(nodeMenuItemDescriptor2, node));
                continue;
            }
            jMenu.add((JMenuItem)this.buildPopup(nodeMenuItemDescriptor2, node));
        }
        return jMenu;
    }

    void handlePopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.debug.print("Found PopupTrigger");
            Node node = this.getNode(mouseEvent);
            if (node == null) {
                return;
            }
            NodeMenuItemDescriptorList nodeMenuItemDescriptorList = node.getMenuItemDescriptors();
            if (nodeMenuItemDescriptorList.size() <= 0) {
                return;
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            Enumeration enumeration = nodeMenuItemDescriptorList.elements();
            while (enumeration.hasMoreElements()) {
                NodeMenuItemDescriptor nodeMenuItemDescriptor = (NodeMenuItemDescriptor)enumeration.nextElement();
                if (nodeMenuItemDescriptor.isSeparator()) {
                    jPopupMenu.addSeparator();
                    continue;
                }
                if (nodeMenuItemDescriptor.isLeaf()) {
                    jPopupMenu.add((Action)new NodeMenuItemAction(nodeMenuItemDescriptor, node));
                    continue;
                }
                jPopupMenu.add((JMenuItem)this.buildPopup(nodeMenuItemDescriptor, node));
            }
            jPopupMenu.pack();
            jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

